/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedIsToolChainSupported;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.HoldsOptions;
import org.eclipse.cdt.managedbuilder.internal.core.TargetPlatform;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.StorableEnvironment;
import org.eclipse.cdt.managedbuilder.internal.macros.StorableMacros;
import org.eclipse.cdt.managedbuilder.macros.IConfigurationBuildMacroSupplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ToolChain
extends HoldsOptions
implements IToolChain {
    private static final String EMPTY_STRING = new String();
    private static final boolean resolvedDefault = true;
    private String superClassId;
    private IConfiguration parent;
    private List toolList;
    private Map toolMap;
    private TargetPlatform targetPlatform;
    private Builder builder;
    private String unusedChildren;
    private String errorParserIds;
    private List osList;
    private List archList;
    private String targetToolIds;
    private String secondaryOutputIds;
    private Boolean isAbstract;
    private String scannerConfigDiscoveryProfileId;
    private String versionsSupported;
    private String convertToId;
    private IConfigurationElement managedIsToolChainSupportedElement = null;
    private IManagedIsToolChainSupported managedIsToolChainSupported = null;
    private IConfigurationElement environmentVariableSupplierElement = null;
    private IConfigurationEnvironmentVariableSupplier environmentVariableSupplier = null;
    private IConfigurationElement buildMacroSupplierElement = null;
    private IConfigurationBuildMacroSupplier buildMacroSupplier = null;
    private boolean isExtensionToolChain = false;
    private boolean isDirty = false;
    private boolean resolved = true;
    private StorableMacros userDefinedMacros;
    private StorableEnvironment userDefinedEnvironment;
    private IConfigurationElement previousMbsVersionConversionElement = null;
    private IConfigurationElement currentMbsVersionConversionElement = null;

    public ToolChain(IConfiguration parent, IManagedConfigElement element, String managedBuildRevision) {
        super(false);
        IManagedConfigElement[] builders;
        this.resolved = false;
        this.parent = parent;
        this.isExtensionToolChain = true;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionToolChain(this);
        IManagedConfigElement[] targetPlatforms = element.getChildren("targetPlatform");
        if (targetPlatforms.length >= 1) {
            int cfr_ignored_0 = targetPlatforms.length;
        }
        if (targetPlatforms.length > 0) {
            this.targetPlatform = new TargetPlatform((IToolChain)this, targetPlatforms[0], managedBuildRevision);
        }
        if ((builders = element.getChildren("builder")).length >= 1) {
            int cfr_ignored_1 = builders.length;
        }
        if (builders.length > 0) {
            this.builder = new Builder((IToolChain)this, builders[0], managedBuildRevision);
        }
        IManagedConfigElement[] toolChainElements = element.getChildren();
        int l = 0;
        while (l < toolChainElements.length) {
            IManagedConfigElement toolChainElement = toolChainElements[l];
            if (!this.loadChild(toolChainElement) && toolChainElement.getName().equals("tool")) {
                Tool toolChild = new Tool((IBuildObject)this, toolChainElement, managedBuildRevision);
                this.addTool(toolChild);
            }
            ++l;
        }
    }

    public ToolChain(Configuration parent, IToolChain superClass, String Id, String name, boolean isExtensionElement) {
        super(true);
        this.parent = parent;
        this.setSuperClass(superClass);
        this.setManagedBuildRevision(parent.getManagedBuildRevision());
        if (this.getSuperClass() != null) {
            this.superClassId = this.getSuperClass().getId();
        }
        this.setId(Id);
        this.setName(name);
        this.setVersion(this.getVersionFromId());
        this.isExtensionToolChain = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionToolChain(this);
        } else {
            this.setDirty(true);
        }
    }

    public ToolChain(IConfiguration parent, Element element, String managedBuildRevision) {
        super(true);
        this.parent = parent;
        this.isExtensionToolChain = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromProject(element);
        NodeList configElements = element.getChildNodes();
        int i = 0;
        while (i < configElements.getLength()) {
            Node configElement = configElements.item(i);
            if (!this.loadChild(configElement)) {
                if (configElement.getNodeName().equals("tool")) {
                    Tool tool = new Tool((IBuildObject)this, (Element)configElement, managedBuildRevision);
                    this.addTool(tool);
                } else if (configElement.getNodeName().equals("targetPlatform")) {
                    this.targetPlatform = new TargetPlatform((IToolChain)this, (Element)configElement, managedBuildRevision);
                } else if (configElement.getNodeName().equals("builder")) {
                    this.builder = new Builder((IToolChain)this, (Element)configElement, managedBuildRevision);
                } else if (configElement.getNodeName().equals("macros")) {
                    this.userDefinedMacros = new StorableMacros((Element)configElement);
                }
            }
            ++i;
        }
    }

    public ToolChain(IConfiguration parent, String Id, String name, ToolChain toolChain) {
        super(true);
        this.parent = parent;
        this.setSuperClass(toolChain.getSuperClass());
        if (this.getSuperClass() != null && toolChain.superClassId != null) {
            this.superClassId = new String(toolChain.superClassId);
        }
        this.setId(Id);
        this.setName(name);
        this.setManagedBuildRevision(toolChain.getManagedBuildRevision());
        this.setVersion(this.getVersionFromId());
        this.isExtensionToolChain = false;
        if (toolChain.versionsSupported != null) {
            this.versionsSupported = new String(toolChain.versionsSupported);
        }
        if (toolChain.convertToId != null) {
            this.convertToId = new String(toolChain.convertToId);
        }
        if (toolChain.unusedChildren != null) {
            this.unusedChildren = new String(toolChain.unusedChildren);
        }
        if (toolChain.errorParserIds != null) {
            this.errorParserIds = new String(toolChain.errorParserIds);
        }
        if (toolChain.osList != null) {
            this.osList = new ArrayList(toolChain.osList);
        }
        if (toolChain.archList != null) {
            this.archList = new ArrayList(toolChain.archList);
        }
        if (toolChain.targetToolIds != null) {
            this.targetToolIds = new String(toolChain.targetToolIds);
        }
        if (toolChain.secondaryOutputIds != null) {
            this.secondaryOutputIds = new String(toolChain.secondaryOutputIds);
        }
        if (toolChain.isAbstract != null) {
            this.isAbstract = new Boolean(toolChain.isAbstract);
        }
        if (toolChain.scannerConfigDiscoveryProfileId != null) {
            this.scannerConfigDiscoveryProfileId = new String(toolChain.scannerConfigDiscoveryProfileId);
        }
        this.managedIsToolChainSupportedElement = toolChain.managedIsToolChainSupportedElement;
        this.managedIsToolChainSupported = toolChain.managedIsToolChainSupported;
        this.environmentVariableSupplierElement = toolChain.environmentVariableSupplierElement;
        this.environmentVariableSupplier = toolChain.environmentVariableSupplier;
        this.buildMacroSupplierElement = toolChain.buildMacroSupplierElement;
        this.buildMacroSupplier = toolChain.buildMacroSupplier;
        super.copyChildren(toolChain);
        if (toolChain.builder != null) {
            String subName;
            String subId;
            if (toolChain.builder.getSuperClass() != null) {
                subId = ManagedBuildManager.calculateChildId(toolChain.builder.getSuperClass().getId(), null);
                subName = toolChain.builder.getSuperClass().getName();
            } else {
                subId = ManagedBuildManager.calculateChildId(toolChain.builder.getId(), null);
                subName = toolChain.builder.getName();
            }
            this.builder = new Builder(this, subId, subName, toolChain.builder);
        }
        if (toolChain.targetPlatform != null) {
            String subName;
            String subId;
            int nnn = ManagedBuildManager.getRandomNumber();
            if (toolChain.targetPlatform.getSuperClass() != null) {
                subId = String.valueOf(toolChain.targetPlatform.getSuperClass().getId()) + "." + nnn;
                subName = toolChain.targetPlatform.getSuperClass().getName();
            } else {
                subId = String.valueOf(toolChain.targetPlatform.getId()) + "." + nnn;
                subName = toolChain.targetPlatform.getName();
            }
            this.targetPlatform = new TargetPlatform(this, subId, subName, toolChain.targetPlatform);
        }
        if (toolChain.toolList != null) {
            ListIterator iter = toolChain.getToolList().listIterator();
            while (iter.hasNext()) {
                String subName;
                String tmpId;
                Tool toolChild = (Tool)iter.next();
                int nnn = ManagedBuildManager.getRandomNumber();
                if (toolChild.getSuperClass() != null) {
                    tmpId = toolChild.getSuperClass().getId();
                    subName = toolChild.getSuperClass().getName();
                } else {
                    tmpId = toolChild.getId();
                    subName = toolChild.getName();
                }
                String version = ManagedBuildManager.getVersionFromIdAndVersion(tmpId);
                String subId = version != null ? String.valueOf(ManagedBuildManager.getIdFromIdAndVersion(tmpId)) + "." + nnn + "_" + version : String.valueOf(tmpId) + "." + nnn;
                Tool newTool = new Tool((IBuildObject)this, null, subId, subName, toolChild);
                this.addTool(newTool);
            }
        }
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String buildMacroSupplier;
        String environmentVariableSupplier;
        String managedIsToolChainSupported;
        String arch;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.setVersion(this.getVersionFromId());
        this.superClassId = element.getAttribute("superClass");
        this.unusedChildren = element.getAttribute("unusedChildren");
        String isAbs = element.getAttribute("isAbstract");
        if (isAbs != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        this.errorParserIds = element.getAttribute("errorParsers");
        this.secondaryOutputIds = element.getAttribute("secondaryOutputs");
        this.targetToolIds = element.getAttribute("targetTool");
        this.scannerConfigDiscoveryProfileId = element.getAttribute("scannerConfigDiscoveryProfileId");
        this.versionsSupported = element.getAttribute("versionsSupported");
        this.convertToId = element.getAttribute("convertToId");
        String os = element.getAttribute("osList");
        if (os != null) {
            this.osList = new ArrayList();
            String[] osTokens = os.split(",");
            int i = 0;
            while (i < osTokens.length) {
                this.osList.add(osTokens[i].trim());
                ++i;
            }
        }
        if ((arch = element.getAttribute("archList")) != null) {
            this.archList = new ArrayList();
            String[] archTokens = arch.split(",");
            int j = 0;
            while (j < archTokens.length) {
                this.archList.add(archTokens[j].trim());
                ++j;
            }
        }
        if ((managedIsToolChainSupported = element.getAttribute("isToolChainSupported")) != null && element instanceof DefaultManagedConfigElement) {
            this.managedIsToolChainSupportedElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((environmentVariableSupplier = element.getAttribute("configurationEnvironmentSupplier")) != null && element instanceof DefaultManagedConfigElement) {
            this.environmentVariableSupplierElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((buildMacroSupplier = element.getAttribute("configurationMacroSupplier")) != null && element instanceof DefaultManagedConfigElement) {
            this.buildMacroSupplierElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
    }

    protected void loadFromProject(Element element) {
        String arch;
        String os;
        String isAbs;
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        this.setVersion(this.getVersionFromId());
        this.superClassId = element.getAttribute("superClass");
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.setSuperClass(ManagedBuildManager.getExtensionToolChain(this.superClassId));
            this.checkForMigrationSupport();
        }
        if (element.hasAttribute("unusedChildren")) {
            this.unusedChildren = element.getAttribute("unusedChildren");
        }
        if (element.hasAttribute("isAbstract") && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if (element.hasAttribute("errorParsers")) {
            this.errorParserIds = element.getAttribute("errorParsers");
        }
        if (element.hasAttribute("secondaryOutputs")) {
            this.secondaryOutputIds = element.getAttribute("secondaryOutputs");
        }
        if (element.hasAttribute("targetTool")) {
            this.targetToolIds = element.getAttribute("targetTool");
        }
        if (element.hasAttribute("scannerConfigDiscoveryProfileId")) {
            this.scannerConfigDiscoveryProfileId = element.getAttribute("scannerConfigDiscoveryProfileId");
        }
        if (element.hasAttribute("versionsSupported")) {
            this.versionsSupported = element.getAttribute("versionsSupported");
        }
        if (element.hasAttribute("convertToId")) {
            this.convertToId = element.getAttribute("convertToId");
        }
        if (element.hasAttribute("osList") && (os = element.getAttribute("osList")) != null) {
            this.osList = new ArrayList();
            String[] osTokens = os.split(",");
            int i = 0;
            while (i < osTokens.length) {
                this.osList.add(osTokens[i].trim());
                ++i;
            }
        }
        if (element.hasAttribute("archList") && (arch = element.getAttribute("archList")) != null) {
            this.archList = new ArrayList();
            String[] archTokens = arch.split(",");
            int j = 0;
            while (j < archTokens.length) {
                this.archList.add(archTokens[j].trim());
                ++j;
            }
        }
    }

    public void serialize(Document doc, Element element) {
        try {
            String current;
            String listValue;
            if (this.getSuperClass() != null) {
                element.setAttribute("superClass", this.getSuperClass().getId());
            }
            element.setAttribute("id", this.id);
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            if (this.unusedChildren != null) {
                element.setAttribute("unusedChildren", this.unusedChildren);
            }
            if (this.isAbstract != null) {
                element.setAttribute("isAbstract", this.isAbstract.toString());
            }
            if (this.errorParserIds != null) {
                element.setAttribute("errorParsers", this.errorParserIds);
            }
            if (this.secondaryOutputIds != null) {
                element.setAttribute("secondaryOutputs", this.secondaryOutputIds);
            }
            if (this.targetToolIds != null) {
                element.setAttribute("targetTool", this.targetToolIds);
            }
            if (this.scannerConfigDiscoveryProfileId != null) {
                element.setAttribute("scannerConfigDiscoveryProfileId", this.scannerConfigDiscoveryProfileId);
            }
            if (this.versionsSupported != null) {
                element.setAttribute("versionsSupported", this.versionsSupported);
            }
            if (this.convertToId != null) {
                element.setAttribute("convertToId", this.convertToId);
            }
            if (this.osList != null) {
                ListIterator osIter = this.osList.listIterator();
                listValue = EMPTY_STRING;
                while (osIter.hasNext()) {
                    current = (String)osIter.next();
                    listValue = String.valueOf(listValue) + current;
                    if (!osIter.hasNext()) continue;
                    listValue = String.valueOf(listValue) + ",";
                }
                element.setAttribute("osList", listValue);
            }
            if (this.archList != null) {
                ListIterator archIter = this.archList.listIterator();
                listValue = EMPTY_STRING;
                while (archIter.hasNext()) {
                    current = (String)archIter.next();
                    listValue = String.valueOf(listValue) + current;
                    if (!archIter.hasNext()) continue;
                    listValue = String.valueOf(listValue) + ",";
                }
                element.setAttribute("archList", listValue);
            }
            super.serialize(doc, element);
            if (this.targetPlatform != null) {
                Element targetPlatformElement = doc.createElement("targetPlatform");
                element.appendChild(targetPlatformElement);
                this.targetPlatform.serialize(doc, targetPlatformElement);
            }
            if (this.builder != null) {
                Element builderElement = doc.createElement("builder");
                element.appendChild(builderElement);
                this.builder.serialize(doc, builderElement);
            }
            List toolElements = this.getToolList();
            ListIterator iter = toolElements.listIterator();
            while (iter.hasNext()) {
                Tool tool = (Tool)iter.next();
                Element toolElement = doc.createElement("tool");
                element.appendChild(toolElement);
                tool.serialize(doc, toolElement);
            }
            if (this.userDefinedMacros != null) {
                Element macrosElement = doc.createElement("macros");
                element.appendChild(macrosElement);
                this.userDefinedMacros.serialize(doc, macrosElement);
            }
            if (this.userDefinedEnvironment != null) {
                EnvironmentVariableProvider.fUserSupplier.storeEnvironment(this.getParent(), true);
            }
            this.isDirty = false;
        }
        catch (Exception exception) {}
    }

    public IConfiguration getParent() {
        return this.parent;
    }

    public ITargetPlatform createTargetPlatform(ITargetPlatform superClass, String id, String name, boolean isExtensionElement) {
        this.targetPlatform = new TargetPlatform(this, superClass, id, name, isExtensionElement);
        this.setDirty(true);
        return this.targetPlatform;
    }

    public ITargetPlatform getTargetPlatform() {
        if (this.targetPlatform == null && this.getSuperClass() != null) {
            return this.getSuperClass().getTargetPlatform();
        }
        return this.targetPlatform;
    }

    public void removeLocalTargetPlatform() {
        if (this.targetPlatform == null) {
            return;
        }
        this.targetPlatform = null;
        this.setDirty(true);
    }

    public IBuilder createBuilder(IBuilder superClass, String id, String name, boolean isExtensionElement) {
        this.builder = new Builder(this, superClass, id, name, isExtensionElement);
        this.setDirty(true);
        return this.builder;
    }

    public IBuilder getBuilder() {
        if (this.builder == null && this.getSuperClass() != null) {
            return this.getSuperClass().getBuilder();
        }
        return this.builder;
    }

    public void removeLocalBuilder() {
        if (this.builder == null) {
            return;
        }
        this.builder = null;
        this.setDirty(true);
    }

    public ITool createTool(ITool superClass, String id, String name, boolean isExtensionElement) {
        Tool tool = new Tool(this, superClass, id, name, isExtensionElement);
        this.addTool(tool);
        this.setDirty(true);
        return tool;
    }

    public ITool[] getTools() {
        ITool[] tools = null;
        if (this.getSuperClass() != null) {
            tools = this.getSuperClass().getTools();
        }
        if (tools != null) {
            ListIterator iter = this.getToolList().listIterator();
            while (iter.hasNext()) {
                Tool tool = (Tool)iter.next();
                int j = 0;
                while (j < tools.length) {
                    if (tool.getSuperClass() != null && tool.getSuperClass().getId().equals(tools[j].getId())) {
                        tools[j] = tool;
                        break;
                    }
                    ++j;
                }
                if (j != tools.length) continue;
                ITool[] newTools = new ITool[tools.length + 1];
                int k = 0;
                while (k < tools.length) {
                    newTools[k] = tools[k];
                    ++k;
                }
                newTools[j] = tool;
                tools = newTools;
            }
        } else {
            tools = new ITool[this.getToolList().size()];
            ListIterator iter = this.getToolList().listIterator();
            int i = 0;
            while (iter.hasNext()) {
                Tool tool = (Tool)iter.next();
                tools[i++] = tool;
            }
        }
        return tools;
    }

    public ITool getTool(String id) {
        Tool tool = (Tool)this.getToolMap().get(id);
        return tool;
    }

    public ITool[] getToolsBySuperClassId(String id) {
        ArrayList<ITool> retTools = new ArrayList<ITool>();
        if (id != null) {
            ITool[] tools = this.getTools();
            int i = 0;
            while (i < tools.length) {
                ITool targetTool;
                ITool tool = targetTool = tools[i];
                do {
                    if (!id.equals(tool.getId())) continue;
                    retTools.add(targetTool);
                    break;
                } while ((tool = tool.getSuperClass()) != null);
                ++i;
            }
        }
        return retTools.toArray(new ITool[retTools.size()]);
    }

    public List getToolList() {
        if (this.toolList == null) {
            this.toolList = new ArrayList();
        }
        return this.toolList;
    }

    private Map getToolMap() {
        if (this.toolMap == null) {
            this.toolMap = new HashMap();
        }
        return this.toolMap;
    }

    public void addTool(Tool tool) {
        this.getToolList().add(tool);
        this.getToolMap().put(tool.getId(), tool);
    }

    public IToolChain getSuperClass() {
        return (IToolChain)this.superClass;
    }

    private void setSuperClass(IToolChain superClass) {
        this.superClass = superClass;
    }

    public String getName() {
        return this.name == null && this.getSuperClass() != null ? this.getSuperClass().getName() : this.name;
    }

    public boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    public String getUnusedChildren() {
        if (this.unusedChildren != null) {
            return this.unusedChildren;
        }
        return EMPTY_STRING;
    }

    public String getErrorParserIds() {
        String ids = this.errorParserIds;
        if (ids == null && this.getSuperClass() != null) {
            ids = this.getSuperClass().getErrorParserIds();
        }
        if (ids == null) {
            ids = this.builder.getErrorParserIds();
            ITool[] tools = this.getTools();
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                String toolIds = tool.getErrorParserIds();
                if (toolIds != null && toolIds.length() > 0) {
                    if (ids != null) {
                        ids = String.valueOf(ids) + ";";
                        ids = String.valueOf(ids) + toolIds;
                    } else {
                        ids = toolIds;
                    }
                }
                ++i;
            }
        }
        return ids;
    }

    public IOutputType[] getSecondaryOutputs() {
        IOutputType[] types = null;
        String ids = this.secondaryOutputIds;
        if (ids == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getSecondaryOutputs();
            }
            return new IOutputType[0];
        }
        StringTokenizer tok = new StringTokenizer(ids, ";");
        types = new IOutputType[tok.countTokens()];
        ITool[] tools = this.getTools();
        int i = 0;
        block0: while (tok.hasMoreElements()) {
            String id = tok.nextToken();
            int j = 0;
            while (j < tools.length) {
                IOutputType type = tools[j].getOutputTypeById(id);
                if (type != null) {
                    types[i++] = type;
                    continue block0;
                }
                ++j;
            }
        }
        return types;
    }

    public String getTargetToolIds() {
        if (this.targetToolIds == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getTargetToolIds();
            }
            return null;
        }
        return this.targetToolIds;
    }

    public String[] getTargetToolList() {
        String[] targetTools;
        String IDs = this.getTargetToolIds();
        if (IDs != null) {
            if (IDs.length() == 0) {
                targetTools = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(IDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{""};
                targetTools = list.toArray(strArr);
            }
        } else {
            targetTools = new String[]{};
        }
        return targetTools;
    }

    public String getErrorParserIds(IConfiguration config) {
        String ids = this.errorParserIds;
        if (ids == null && this.getSuperClass() != null) {
            ids = this.getSuperClass().getErrorParserIds(config);
        }
        if (ids == null) {
            if (this.builder != null) {
                ids = this.builder.getErrorParserIds();
            }
            ITool[] tools = config.getFilteredTools();
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                String toolIds = tool.getErrorParserIds();
                if (toolIds != null && toolIds.length() > 0) {
                    if (ids != null) {
                        ids = String.valueOf(ids) + ";";
                        ids = String.valueOf(ids) + toolIds;
                    } else {
                        ids = toolIds;
                    }
                }
                ++i;
            }
        }
        return ids;
    }

    public String[] getErrorParserList() {
        String[] errorParsers;
        String parserIDs = this.getErrorParserIds();
        if (parserIDs != null) {
            if (parserIDs.length() == 0) {
                errorParsers = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{""};
                errorParsers = list.toArray(strArr);
            }
        } else {
            errorParsers = new String[]{};
        }
        return errorParsers;
    }

    public String[] getArchList() {
        if (this.archList == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getArchList();
            }
            return new String[]{"all"};
        }
        return this.archList.toArray(new String[this.archList.size()]);
    }

    public String[] getOSList() {
        if (this.osList == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getOSList();
            }
            return new String[]{"all"};
        }
        return this.osList.toArray(new String[this.osList.size()]);
    }

    public void setIsAbstract(boolean b) {
        this.isAbstract = new Boolean(b);
        this.setDirty(true);
    }

    public void setErrorParserIds(String ids) {
        String currentIds = this.getErrorParserIds();
        if (ids == null && currentIds == null) {
            return;
        }
        if (currentIds == null || ids == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    public void setSecondaryOutputs(String newIds) {
        if (this.secondaryOutputIds == null && newIds == null) {
            return;
        }
        if (this.secondaryOutputIds == null || newIds == null || !newIds.equals(this.secondaryOutputIds)) {
            this.secondaryOutputIds = newIds;
            this.isDirty = true;
        }
    }

    public void setTargetToolIds(String newIds) {
        if (this.targetToolIds == null && newIds == null) {
            return;
        }
        if (this.targetToolIds == null || newIds == null || !newIds.equals(this.targetToolIds)) {
            this.targetToolIds = newIds;
            this.isDirty = true;
        }
    }

    public void setOSList(String[] OSs) {
        if (this.osList == null) {
            this.osList = new ArrayList();
        } else {
            this.osList.clear();
        }
        int i = 0;
        while (i < OSs.length) {
            this.osList.add(OSs[i]);
            ++i;
        }
        this.setDirty(true);
    }

    public void setArchList(String[] archs) {
        if (this.archList == null) {
            this.archList = new ArrayList();
        } else {
            this.archList.clear();
        }
        int i = 0;
        while (i < archs.length) {
            this.archList.add(archs[i]);
            ++i;
        }
        this.setDirty(true);
    }

    public String getScannerConfigDiscoveryProfileId() {
        if (this.scannerConfigDiscoveryProfileId == null && this.getSuperClass() != null) {
            return this.getSuperClass().getScannerConfigDiscoveryProfileId();
        }
        return this.scannerConfigDiscoveryProfileId;
    }

    public void setScannerConfigDiscoveryProfileId(String profileId) {
        if (this.scannerConfigDiscoveryProfileId == null && profileId == null) {
            return;
        }
        if (this.scannerConfigDiscoveryProfileId == null || !this.scannerConfigDiscoveryProfileId.equals(profileId)) {
            this.scannerConfigDiscoveryProfileId = profileId;
            this.setDirty(true);
        }
    }

    public boolean isExtensionElement() {
        return this.isExtensionToolChain;
    }

    public boolean isDirty() {
        if (this.isExtensionToolChain) {
            return false;
        }
        if (this.isDirty) {
            return true;
        }
        if (this.userDefinedMacros != null && this.userDefinedMacros.isDirty()) {
            return true;
        }
        if (this.userDefinedEnvironment != null && this.userDefinedEnvironment.isDirty()) {
            return true;
        }
        if (this.builder != null && this.builder.isDirty()) {
            return true;
        }
        ListIterator iter = this.getToolList().listIterator();
        while (iter.hasNext()) {
            Tool toolChild = (Tool)iter.next();
            if (!toolChild.isDirty()) continue;
            return true;
        }
        if (super.isDirty()) {
            return true;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        super.setDirty(isDirty);
        if (!isDirty) {
            ListIterator iter = this.getToolList().listIterator();
            while (iter.hasNext()) {
                Tool toolChild = (Tool)iter.next();
                toolChild.setDirty(false);
            }
        }
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.setSuperClass(ManagedBuildManager.getExtensionToolChain(this.superClassId));
                if (this.getSuperClass() == null) {
                    ManagedBuildManager.OutputResolveError("superClass", this.superClassId, "toolChain", this.getId());
                }
            }
            super.resolveReferences();
            if (this.targetPlatform != null) {
                this.targetPlatform.resolveReferences();
            }
            if (this.builder != null) {
                this.builder.resolveReferences();
            }
            ListIterator iter = this.getToolList().listIterator();
            while (iter.hasNext()) {
                Tool toolChild = (Tool)iter.next();
                toolChild.resolveReferences();
            }
        }
    }

    public void normalizeOutputExtensions() {
        ITool[] tools = this.getTools();
        if (tools != null) {
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                String[] extensions = tool.getOutputsAttribute();
                if (extensions == null) {
                    tool.setOutputsAttribute("");
                } else if (extensions.length == 0) {
                    tool.setOutputsAttribute("");
                }
                ++i;
            }
        }
    }

    public String getConvertToId() {
        if (this.convertToId == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getConvertToId();
            }
            return EMPTY_STRING;
        }
        return this.convertToId;
    }

    public void setConvertToId(String convertToId) {
        if (convertToId == null && this.convertToId == null) {
            return;
        }
        if (convertToId == null || this.convertToId == null || !convertToId.equals(this.convertToId)) {
            this.convertToId = convertToId;
            this.setDirty(true);
        }
    }

    public String getVersionsSupported() {
        if (this.versionsSupported == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getVersionsSupported();
            }
            return EMPTY_STRING;
        }
        return this.versionsSupported;
    }

    public void setVersionsSupported(String versionsSupported) {
        if (versionsSupported == null && this.versionsSupported == null) {
            return;
        }
        if (versionsSupported == null || this.versionsSupported == null || !versionsSupported.equals(this.versionsSupported)) {
            this.versionsSupported = versionsSupported;
            this.setDirty(true);
        }
    }

    private IConfigurationElement getIsToolChainSupportedElement() {
        if (this.managedIsToolChainSupportedElement == null && this.superClass != null && this.superClass instanceof ToolChain) {
            return ((ToolChain)this.superClass).getIsToolChainSupportedElement();
        }
        return this.managedIsToolChainSupportedElement;
    }

    public boolean isSupported() {
        IConfigurationElement element;
        if (this.managedIsToolChainSupported == null && (element = this.getIsToolChainSupportedElement()) != null) {
            try {
                if (element.getAttribute("isToolChainSupported") != null) {
                    this.managedIsToolChainSupported = (IManagedIsToolChainSupported)element.createExecutableExtension("isToolChainSupported");
                }
            }
            catch (CoreException coreException) {}
        }
        if (this.managedIsToolChainSupported != null) {
            return this.managedIsToolChainSupported.isSupported(this, null, null);
        }
        return true;
    }

    public IConfigurationElement getEnvironmentVariableSupplierElement() {
        if (this.environmentVariableSupplierElement == null && this.getSuperClass() != null && this.getSuperClass() instanceof ToolChain) {
            return ((ToolChain)this.getSuperClass()).getEnvironmentVariableSupplierElement();
        }
        return this.environmentVariableSupplierElement;
    }

    public IConfigurationEnvironmentVariableSupplier getEnvironmentVariableSupplier() {
        if (this.environmentVariableSupplier != null) {
            return this.environmentVariableSupplier;
        }
        IConfigurationElement element = this.getEnvironmentVariableSupplierElement();
        if (element != null) {
            try {
                if (element.getAttribute("configurationEnvironmentSupplier") != null) {
                    this.environmentVariableSupplier = (IConfigurationEnvironmentVariableSupplier)element.createExecutableExtension("configurationEnvironmentSupplier");
                    return this.environmentVariableSupplier;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public StorableMacros getUserDefinedMacros() {
        if (this.isExtensionToolChain) {
            return null;
        }
        if (this.userDefinedMacros == null) {
            this.userDefinedMacros = new StorableMacros();
        }
        return this.userDefinedMacros;
    }

    public StorableEnvironment getUserDefinedEnvironment() {
        if (this.isExtensionToolChain) {
            return null;
        }
        return this.userDefinedEnvironment;
    }

    public void setUserDefinedEnvironment(StorableEnvironment env) {
        if (!this.isExtensionToolChain) {
            this.userDefinedEnvironment = env;
        }
    }

    public IConfigurationElement getBuildMacroSupplierElement() {
        if (this.buildMacroSupplierElement == null && this.superClass != null && this.superClass instanceof ToolChain) {
            return ((ToolChain)this.superClass).getBuildMacroSupplierElement();
        }
        return this.buildMacroSupplierElement;
    }

    public IConfigurationBuildMacroSupplier getBuildMacroSupplier() {
        if (this.buildMacroSupplier != null) {
            return this.buildMacroSupplier;
        }
        IConfigurationElement element = this.getBuildMacroSupplierElement();
        if (element != null) {
            try {
                if (element.getAttribute("configurationMacroSupplier") != null) {
                    this.buildMacroSupplier = (IConfigurationBuildMacroSupplier)element.createExecutableExtension("configurationMacroSupplier");
                    return this.buildMacroSupplier;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public void checkForMigrationSupport() {
        boolean isExists = false;
        if (this.getSuperClass() == null) {
            String high = (String)ManagedBuildManager.getExtensionToolChainMap().lastKey();
            SortedMap subMap = null;
            if (this.superClassId.compareTo(high) > 0) {
                IConfiguration parentConfig = this.getParent();
                IManagedProject managedProject = parentConfig.getManagedProject();
                if (managedProject != null) {
                    managedProject.setValid(false);
                }
                return;
            }
            subMap = ManagedBuildManager.getExtensionToolChainMap().subMap(this.superClassId, String.valueOf(high) + "\u0000");
            String baseId = ManagedBuildManager.getIdFromIdAndVersion(this.superClassId);
            String version = this.getVersionFromId().toString();
            IToolChain[] toolChainElements = (IToolChain[])subMap.values().toArray();
            int i = 0;
            while (i < toolChainElements.length) {
                String versionsSupported;
                IToolChain toolChainElement = toolChainElements[i];
                if (ManagedBuildManager.getIdFromIdAndVersion(toolChainElement.getId()).compareTo(baseId) > 0) break;
                if (ManagedBuildManager.getIdFromIdAndVersion(toolChainElement.getId()).equals(baseId) && (versionsSupported = toolChainElement.getVersionsSupported()) != null && !versionsSupported.equals("")) {
                    String[] tmpVersions = versionsSupported.split(",");
                    int j = 0;
                    while (j < tmpVersions.length) {
                        if (new PluginVersionIdentifier(version).equals((Object)new PluginVersionIdentifier(tmpVersions[j]))) {
                            String supportedVersion = ManagedBuildManager.getVersionFromIdAndVersion(toolChainElement.getId());
                            this.setId(String.valueOf(ManagedBuildManager.getIdFromIdAndVersion(this.getId())) + "_" + supportedVersion);
                            this.setSuperClass(toolChainElement);
                            this.superClassId = this.getSuperClass().getId();
                            isExists = true;
                            break;
                        }
                        ++j;
                    }
                    if (isExists) break;
                }
                ++i;
            }
        }
        if (this.getSuperClass() != null) {
            String convertToId = this.getSuperClass().getConvertToId();
            if (convertToId == null || convertToId.equals("")) {
                return;
            }
            this.getConverter(convertToId);
        } else {
            IConfiguration parentConfig = this.getParent();
            IManagedProject managedProject = parentConfig.getManagedProject();
            if (managedProject != null) {
                managedProject.setValid(false);
            }
        }
    }

    private void getConverter(String convertToId) {
        IConfiguration parentConfig;
        IManagedProject managedProject;
        String fromId = null;
        String toId = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter")) {
                        fromId = element.getAttribute("fromId");
                        toId = element.getAttribute("toId");
                        if (fromId.equals(this.getSuperClass().getId()) && toId.equals(convertToId)) {
                            String mbsVersion = element.getAttribute("mbsVersion");
                            PluginVersionIdentifier currentMbsVersion = ManagedBuildManager.getBuildInfoVersion();
                            if (currentMbsVersion.isGreaterThan(new PluginVersionIdentifier(mbsVersion))) {
                                this.previousMbsVersionConversionElement = element;
                            } else {
                                this.currentMbsVersionConversionElement = element;
                            }
                            return;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if ((managedProject = (parentConfig = this.getParent()).getManagedProject()) != null) {
            managedProject.setValid(false);
        }
    }

    public IConfigurationElement getPreviousMbsVersionConversionElement() {
        return this.previousMbsVersionConversionElement;
    }

    public IConfigurationElement getCurrentMbsVersionConversionElement() {
        return this.currentMbsVersionConversionElement;
    }

    public void updateManagedBuildRevision(String revision) {
        super.updateManagedBuildRevision(revision);
        Iterator iter = this.getToolList().iterator();
        while (iter.hasNext()) {
            ((Tool)iter.next()).updateManagedBuildRevision(revision);
        }
        if (this.builder != null) {
            this.builder.updateManagedBuildRevision(revision);
        }
    }
}

