/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.envvar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.envvar.StorableEnvironment;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class StorableEnvironmentLoader {
    protected abstract ISerializeInfo getSerializeInfo(Object var1);

    protected StorableEnvironment loadEnvironment(Object context) {
        ISerializeInfo serializeInfo = this.getSerializeInfo(context);
        if (serializeInfo == null) {
            return null;
        }
        InputStream stream = this.loadInputStream(serializeInfo.getNode(), serializeInfo.getPrefName());
        if (stream == null) {
            return new StorableEnvironment();
        }
        return this.loadEnvironmentFromStream(stream);
    }

    protected void storeEnvironment(StorableEnvironment env, Object context, boolean force) throws CoreException {
        if (!env.isDirty() && !force) {
            return;
        }
        ISerializeInfo serializeInfo = this.getSerializeInfo(context);
        if (serializeInfo == null) {
            return;
        }
        ByteArrayOutputStream stream = this.storeEnvironmentToStream(env);
        if (stream == null) {
            return;
        }
        this.storeOutputStream(stream, serializeInfo.getNode(), serializeInfo.getPrefName());
    }

    private StorableEnvironment loadEnvironmentFromStream(InputStream stream) {
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource inputSource = new InputSource(stream);
            Document document = parser.parse(inputSource);
            Element rootElement = document.getDocumentElement();
            if (!"environment".equals(rootElement.getNodeName())) {
                return null;
            }
            return new StorableEnvironment(rootElement);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private ByteArrayOutputStream storeEnvironmentToStream(StorableEnvironment env) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement("environment");
            document.appendChild(rootElement);
            env.serialize(document, rootElement);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            return stream;
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, e.getMessage(), (Throwable)e));
        }
        catch (TransformerConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, e.getMessage(), (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, e.getMessage(), (Throwable)e));
        }
    }

    private InputStream loadInputStream(Preferences node, String key) {
        byte[] bytes;
        if (node == null || key == null) {
            return null;
        }
        String value = node.get(key, null);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = value.getBytes();
        }
        return new ByteArrayInputStream(bytes);
    }

    private void storeOutputStream(ByteArrayOutputStream stream, Preferences node, String key) throws CoreException {
        if (stream == null || node == null || key == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ManagedMakeMessages.getResourceString("StorableEnvironmentLoader.storeOutputStream.wrong.arguments"), null));
        }
        byte[] bytes = stream.toByteArray();
        String val = null;
        try {
            val = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            val = new String(bytes);
        }
        node.put(key, val);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, e.getMessage(), (Throwable)e));
        }
    }

    protected static interface ISerializeInfo {
        public Preferences getNode();

        public String getPrefName();
    }
}

