/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroStatus;
import org.eclipse.core.runtime.Status;

public class BuildMacroStatus
extends Status
implements IBuildMacroStatus {
    private static final String PREFIX = "BuildMacroStatus";
    private static final String STATUS = "BuildMacroStatus.status";
    private static final String STATUS_MACRO_UNDEFINED = "BuildMacroStatus.status.macro.undefined";
    private static final String STATUS_MACROS_REFERENCE_EACHOTHER = "BuildMacroStatus.status.reference.eachother";
    private static final String STATUS_MACRO_REFERENCE_INCORRECT = "BuildMacroStatus.status.reference.incorrect";
    private static final String STATUS_MACRO_NOT_STRING = "BuildMacroStatus.status.macro.not.string";
    private static final String STATUS_MACRO_NOT_STRINGLIST = "BuildMacroStatus.status.macro.not.stringlist";
    private static final String STATUS_ERROR = "BuildMacroStatus.status.error";
    private static final String VALUE_UNDEFINED = "BuildMacroStatus.value.undefined";
    private String fMacroName;
    private String fExpression;
    private String fReferencedName;
    private int fContextType;
    private Object fContextData;

    public BuildMacroStatus(int severity, int code, String message, Throwable exception, String macroName, String expression, String referencedName, int contextType, Object contextData) {
        super(severity, ManagedBuilderCorePlugin.getUniqueIdentifier(), code, message != null ? message : "", exception);
        this.fExpression = expression;
        this.fReferencedName = referencedName;
        this.fContextType = contextType;
        this.fContextData = contextData;
        this.fMacroName = macroName;
        if (message == null) {
            this.setMessage(this.generateMessage());
        }
    }

    public BuildMacroStatus(int code, String message, Throwable exception, String macroName, String expression, String referencedName, int contextType, Object contextData) {
        this(4, code, message, exception, macroName, expression, referencedName, contextType, contextData);
    }

    public BuildMacroStatus(int code, String macroName, String expression, String referencedName, int contextType, Object contextData) {
        this(4, code, null, null, macroName, expression, referencedName, contextType, contextData);
    }

    protected String generateMessage() {
        String message = null;
        switch (this.getCode()) {
            case 1: {
                String refName = this.fReferencedName;
                if (refName == null) {
                    refName = ManagedMakeMessages.getResourceString(VALUE_UNDEFINED);
                }
                message = ManagedMakeMessages.getFormattedString(STATUS_MACRO_UNDEFINED, refName);
                break;
            }
            case 2: {
                String name = this.fMacroName;
                String refName = this.fReferencedName;
                if (name == null) {
                    name = ManagedMakeMessages.getResourceString(VALUE_UNDEFINED);
                }
                if (refName == null) {
                    refName = ManagedMakeMessages.getResourceString(VALUE_UNDEFINED);
                }
                message = ManagedMakeMessages.getFormattedString(STATUS_MACROS_REFERENCE_EACHOTHER, new String[]{name, refName});
                break;
            }
            case 3: {
                String refName = this.fReferencedName;
                if (refName == null) {
                    refName = ManagedMakeMessages.getResourceString(VALUE_UNDEFINED);
                }
                message = ManagedMakeMessages.getFormattedString(STATUS_MACRO_REFERENCE_INCORRECT, refName);
                break;
            }
            case 4: {
                String refName = this.fReferencedName;
                if (refName == null) {
                    refName = ManagedMakeMessages.getResourceString(VALUE_UNDEFINED);
                }
                message = ManagedMakeMessages.getFormattedString(STATUS_MACRO_NOT_STRING, refName);
                break;
            }
            case 5: {
                String refName = this.fReferencedName;
                if (refName == null) {
                    refName = ManagedMakeMessages.getResourceString(VALUE_UNDEFINED);
                }
                message = ManagedMakeMessages.getFormattedString(STATUS_MACRO_NOT_STRINGLIST, refName);
                break;
            }
            default: {
                message = ManagedMakeMessages.getResourceString(STATUS_ERROR);
            }
        }
        return message;
    }

    public String getMacroName() {
        return this.fMacroName;
    }

    public String getExpression() {
        return this.fExpression;
    }

    public String getReferencedMacroName() {
        return this.fReferencedName;
    }

    public int getContextType() {
        return this.fContextType;
    }

    public Object getContextData() {
        return this.fContextData;
    }
}

