/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarOperationProcessor;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroSupplier;
import org.eclipse.cdt.managedbuilder.macros.IConfigurationBuildMacroSupplier;
import org.eclipse.cdt.managedbuilder.macros.IProjectBuildMacroSupplier;

public class ExternalExtensionMacroSupplier
implements IBuildMacroSupplier {
    private static final String[] fNonOverloadableMacros = new String[]{"CWD", "PWD"};
    private static ExternalExtensionMacroSupplier fInstance;

    private ExternalExtensionMacroSupplier() {
    }

    public static ExternalExtensionMacroSupplier getInstance() {
        if (fInstance == null) {
            fInstance = new ExternalExtensionMacroSupplier();
        }
        return fInstance;
    }

    public IBuildMacro getMacro(String macroName, int contextType, Object contextData) {
        if ((macroName = this.getValidName(macroName)) == null) {
            return null;
        }
        switch (contextType) {
            case 3: {
                if (contextData instanceof IConfiguration) {
                    IConfiguration cfg = (IConfiguration)contextData;
                    IConfigurationBuildMacroSupplier supplier = cfg.getBuildMacroSupplier();
                    if (supplier == null) {
                        return null;
                    }
                    return supplier.getMacro(macroName, cfg, new ExtensionMacroProvider(contextType, contextData));
                }
            }
            case 4: {
                if (!(contextData instanceof IManagedProject)) break;
                IManagedProject project = (IManagedProject)contextData;
                IProjectBuildMacroSupplier supplier = project.getProjectType().getBuildMacroSupplier();
                if (supplier == null) {
                    return null;
                }
                return supplier.getMacro(macroName, project, new ExtensionMacroProvider(contextType, contextData));
            }
        }
        return null;
    }

    public IBuildMacro[] getMacros(int contextType, Object contextData) {
        IBuildMacro[] macros = null;
        switch (contextType) {
            case 3: {
                IConfiguration cfg;
                IConfigurationBuildMacroSupplier supplier;
                if (!(contextData instanceof IConfiguration) || (supplier = (cfg = (IConfiguration)contextData).getBuildMacroSupplier()) == null) break;
                macros = supplier.getMacros(cfg, new ExtensionMacroProvider(contextType, contextData));
                break;
            }
            case 4: {
                IManagedProject project;
                IProjectBuildMacroSupplier supplier;
                if (!(contextData instanceof IManagedProject) || (supplier = (project = (IManagedProject)contextData).getProjectType().getBuildMacroSupplier()) == null) break;
                macros = supplier.getMacros(project, new ExtensionMacroProvider(contextType, contextData));
            }
        }
        return this.filterMacros(macros);
    }

    protected String getValidName(String name) {
        if (name == null || (name = name.trim()).length() == 0) {
            return null;
        }
        if (fNonOverloadableMacros != null) {
            int i = 0;
            while (i < fNonOverloadableMacros.length) {
                if (fNonOverloadableMacros[i].equals(EnvVarOperationProcessor.normalizeName(name))) {
                    return null;
                }
                ++i;
            }
        }
        return name;
    }

    protected IBuildMacro[] filterMacros(IBuildMacro[] macros) {
        return MacroResolver.filterMacros(macros, fNonOverloadableMacros);
    }

    protected IBuildMacroSupplier[] filterValidSuppliers(IBuildMacroSupplier[] suppliers) {
        if (suppliers == null) {
            return null;
        }
        int i = 0;
        int j = 0;
        i = 0;
        while (i < suppliers.length) {
            if (suppliers[i] == this) break;
            ++i;
        }
        if (i >= suppliers.length) {
            return null;
        }
        int startNum = i + 1;
        IBuildMacroSupplier[] validSuppliers = new IBuildMacroSupplier[suppliers.length - startNum];
        i = startNum;
        j = 0;
        while (i < suppliers.length) {
            validSuppliers[j] = suppliers[i];
            ++i;
            ++j;
        }
        return validSuppliers;
    }

    private class ExtensionMacroProvider
    extends BuildMacroProvider {
        private IMacroContextInfo fStartInfo;
        private int fContextType;
        private Object fContextData;
        private boolean fStartInitialized;

        public ExtensionMacroProvider(int contextType, Object contextData) {
            this.fContextType = contextType;
            this.fContextData = contextData;
        }

        public IBuildMacro getMacro(String macroName, int contextType, Object contextData, boolean includeParent) {
            if (ExternalExtensionMacroSupplier.this.getValidName(macroName) == null) {
                return null;
            }
            return super.getMacro(macroName, contextType, contextData, includeParent);
        }

        public IBuildMacro[] getMacros(int contextType, Object contextData, boolean includeParent) {
            return ExternalExtensionMacroSupplier.this.filterMacros(super.getMacros(contextType, contextData, includeParent));
        }

        public IMacroContextInfo getMacroContextInfo(int contextType, Object contextData) {
            IMacroContextInfo startInfo = this.getStartInfo();
            if (contextType == this.fContextType && contextData == this.fContextData) {
                return startInfo;
            }
            IMacroContextInfo info = super.getMacroContextInfo(contextType, contextData);
            if (info == null) {
                return null;
            }
            if (this.checkParentContextRelation(startInfo, info)) {
                return info;
            }
            return null;
        }

        protected IMacroContextInfo getStartInfo() {
            if (this.fStartInfo == null && !this.fStartInitialized) {
                IMacroContextInfo info = super.getMacroContextInfo(this.fContextType, this.fContextData);
                if (info != null) {
                    IBuildMacroSupplier[] suppliers = info.getSuppliers();
                    this.fStartInfo = (suppliers = ExternalExtensionMacroSupplier.this.filterValidSuppliers(suppliers)) != null ? new DefaultMacroContextInfo(this.fContextType, this.fContextData, suppliers) : info.getNext();
                    this.fStartInitialized = true;
                }
                this.fStartInitialized = true;
            }
            return this.fStartInfo;
        }
    }
}

