/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.macros.IOptionContextData;

public class OptionContextData
implements IOptionContextData {
    private IOption fOption;
    private IBuildObject fParent;

    public OptionContextData(IOption option, IBuildObject parent) {
        this.fOption = option;
        this.fParent = parent;
    }

    public IOption getOption() {
        return this.fOption;
    }

    public IBuildObject getParent() {
        return this.fParent;
    }

    public static IHoldsOptions getHolder(IOptionContextData data) {
        IBuildObject buildObj = data.getParent();
        IToolChain tCh = null;
        IHoldsOptions ho = null;
        IResourceConfiguration rcCfg = null;
        if (buildObj instanceof ITool) {
            ho = (ITool)buildObj;
        } else if (buildObj instanceof IToolChain) {
            tCh = (IToolChain)buildObj;
        } else if (buildObj instanceof IResourceConfiguration) {
            rcCfg = (IResourceConfiguration)buildObj;
        } else if (buildObj instanceof IConfiguration) {
            tCh = ((IConfiguration)buildObj).getToolChain();
        }
        if (ho == null) {
            IOption option = data.getOption();
            if (option == null) {
                return null;
            }
            ho = option.getOptionHolder();
            ITool[] tools = null;
            if (tCh != null) {
                IToolChain cur = tCh;
                while (cur != null) {
                    if (cur == ho) {
                        return tCh;
                    }
                    cur = cur.getSuperClass();
                }
                tools = tCh.getTools();
            } else if (rcCfg != null) {
                tools = rcCfg.getTools();
            }
            if (tools != null) {
                int i = 0;
                while (i < tools.length) {
                    ITool cur = tools[i];
                    while (cur != null) {
                        if (cur == ho) {
                            return tools[i];
                        }
                        cur = cur.getSuperClass();
                    }
                    ++i;
                }
            }
        }
        return ho;
    }
}

