/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.macros.StorableMacros;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroSupplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UserDefinedMacroSupplier
implements IBuildMacroSupplier {
    public static final String NODENAME = "macros";
    public static final String PREFNAME_WORKSPACE = "workspace";
    private static UserDefinedMacroSupplier fInstance;
    private StorableMacros fWorkspaceMacros;

    public boolean areMacrosExpanded(IConfiguration cfg) {
        StorableMacros macros = this.getStorableMacros(3, cfg);
        if (macros != null) {
            return macros.isExpanded();
        }
        return false;
    }

    public void setMacrosExpanded(IConfiguration cfg, boolean expanded) {
        StorableMacros macros = this.getStorableMacros(3, cfg);
        if (macros != null) {
            macros.setExpanded(expanded);
        }
    }

    private StorableMacros getStorableMacros(int contextType, Object contextData) {
        StorableMacros macros = null;
        switch (contextType) {
            case 3: {
                IToolChain toolChain;
                if (!(contextData instanceof IConfiguration) || !((toolChain = ((IConfiguration)contextData).getToolChain()) instanceof ToolChain)) break;
                macros = ((ToolChain)toolChain).getUserDefinedMacros();
                break;
            }
            case 4: {
                if (!(contextData instanceof ManagedProject)) break;
                macros = ((ManagedProject)contextData).getUserDefinedMacros();
                break;
            }
            case 5: {
                if (!(contextData instanceof IWorkspace)) break;
                if (this.fWorkspaceMacros == null) {
                    this.fWorkspaceMacros = this.loadWorkspaceMacros();
                }
                macros = this.fWorkspaceMacros;
            }
        }
        return macros;
    }

    private UserDefinedMacroSupplier() {
    }

    public static UserDefinedMacroSupplier getInstance() {
        if (fInstance == null) {
            fInstance = new UserDefinedMacroSupplier();
        }
        return fInstance;
    }

    public IBuildMacro getMacro(String macroName, int contextType, Object contextData) {
        if (macroName == null || "".equals(macroName)) {
            return null;
        }
        StorableMacros macros = this.getStorableMacros(contextType, contextData);
        if (macros != null) {
            return macros.getMacro(macroName);
        }
        return null;
    }

    public IBuildMacro[] getMacros(int contextType, Object contextData) {
        StorableMacros macros = this.getStorableMacros(contextType, contextData);
        if (macros != null) {
            return macros.getMacros();
        }
        return null;
    }

    public IBuildMacro createMacro(String macroName, int type, String value, int contextType, Object contextData) {
        if (macroName == null || "".equals(macroName)) {
            return null;
        }
        StorableMacros macros = this.getStorableMacros(contextType, contextData);
        if (macros == null) {
            return null;
        }
        IBuildMacro macro = macros.createMacro(macroName, type, value);
        if (macros.isChanged()) {
            this.setRebuildStateForContext(contextType, contextData);
        }
        return macro;
    }

    public IBuildMacro createMacro(String macroName, int type, String[] value, int contextType, Object contextData) {
        if (macroName == null || "".equals(macroName)) {
            return null;
        }
        StorableMacros macros = this.getStorableMacros(contextType, contextData);
        if (macros == null) {
            return null;
        }
        IBuildMacro macro = macros.createMacro(macroName, type, value);
        if (macros.isChanged()) {
            this.setRebuildStateForContext(contextType, contextData);
        }
        return macro;
    }

    public IBuildMacro createMacro(IBuildMacro copy, int contextType, Object contextData) {
        if (copy == null) {
            return null;
        }
        String macroName = copy.getName();
        if (macroName == null || "".equals(macroName)) {
            return null;
        }
        StorableMacros macros = this.getStorableMacros(contextType, contextData);
        if (macros == null) {
            return null;
        }
        IBuildMacro macro = macros.createMacro(copy);
        if (macros.isChanged()) {
            this.setRebuildStateForContext(contextType, contextData);
        }
        return macro;
    }

    public IBuildMacro deleteMacro(String name, int contextType, Object contextData) {
        StorableMacros macros = this.getStorableMacros(contextType, contextData);
        if (macros == null) {
            return null;
        }
        IBuildMacro macro = macros.deleteMacro(name);
        if (macro != null) {
            this.setRebuildStateForContext(contextType, contextData);
        }
        return macro;
    }

    public void deleteAll(int contextType, Object contextData) {
        StorableMacros macros = this.getStorableMacros(contextType, contextData);
        if (macros == null) {
            return;
        }
        if (macros.deleteAll()) {
            this.setRebuildStateForContext(contextType, contextData);
        }
    }

    public void setMacros(IBuildMacro[] m, int contextType, Object contextData) {
        StorableMacros macros = this.getStorableMacros(contextType, contextData);
        if (macros == null) {
            return;
        }
        macros.setMacros(m);
        if (macros.isChanged()) {
            this.setRebuildStateForContext(contextType, contextData);
        }
    }

    public void serialize(boolean force) {
        try {
            if (this.fWorkspaceMacros != null) {
                this.storeWorkspaceMacros(this.fWorkspaceMacros, force);
            }
        }
        catch (CoreException coreException) {}
    }

    private Preferences getWorkspaceNode() {
        IEclipsePreferences prefNode = new InstanceScope().getNode(ManagedBuilderCorePlugin.getUniqueIdentifier());
        if (prefNode == null) {
            return null;
        }
        return prefNode.node(NODENAME);
    }

    protected StorableMacros loadWorkspaceMacros() {
        InputStream stream = this.loadInputStream(this.getWorkspaceNode(), PREFNAME_WORKSPACE);
        if (stream == null) {
            return new StorableMacros();
        }
        return this.loadMacrosFromStream(stream);
    }

    protected void storeWorkspaceMacros(StorableMacros macros, boolean force) throws CoreException {
        if (!macros.isDirty() && !force) {
            return;
        }
        ByteArrayOutputStream stream = this.storeMacrosToStream(macros);
        if (stream == null) {
            return;
        }
        this.storeOutputStream(stream, this.getWorkspaceNode(), PREFNAME_WORKSPACE);
    }

    private StorableMacros loadMacrosFromStream(InputStream stream) {
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource inputSource = new InputSource(stream);
            Document document = parser.parse(inputSource);
            Element rootElement = document.getDocumentElement();
            if (!NODENAME.equals(rootElement.getNodeName())) {
                return null;
            }
            return new StorableMacros(rootElement);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    private ByteArrayOutputStream storeMacrosToStream(StorableMacros macros) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(NODENAME);
            document.appendChild(rootElement);
            macros.serialize(document, rootElement);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            return stream;
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, e.getMessage(), (Throwable)e));
        }
        catch (TransformerConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, e.getMessage(), (Throwable)e));
        }
        catch (TransformerException e) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, e.getMessage(), (Throwable)e));
        }
    }

    private InputStream loadInputStream(Preferences node, String key) {
        byte[] bytes;
        if (node == null || key == null) {
            return null;
        }
        String value = node.get(key, null);
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = value.getBytes();
        }
        return new ByteArrayInputStream(bytes);
    }

    private void storeOutputStream(ByteArrayOutputStream stream, Preferences node, String key) throws CoreException {
        if (stream == null || node == null || key == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, ManagedMakeMessages.getResourceString("UserDefinedMacroSupplier.storeOutputStream.wrong.arguments"), null));
        }
        byte[] bytes = stream.toByteArray();
        String val = null;
        try {
            val = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            val = new String(bytes);
        }
        node.put(key, val);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), -1, e.getMessage(), (Throwable)e));
        }
    }

    protected void setRebuildStateForContext(int contextType, Object contextData) {
        switch (contextType) {
            case 3: {
                if (!(contextData instanceof IConfiguration)) break;
                ((IConfiguration)contextData).setRebuildState(true);
                break;
            }
            case 4: {
                if (!(contextData instanceof IManagedProject)) break;
                IConfiguration[] cfgs = ((IManagedProject)contextData).getConfigurations();
                int i = 0;
                while (i < cfgs.length) {
                    cfgs[i].setRebuildState(true);
                    ++i;
                }
                break;
            }
            case 5: {
                if (!(contextData instanceof IWorkspace)) break;
                IProject[] projects = ((IWorkspace)contextData).getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    IManagedBuildInfo info;
                    if (ManagedBuildManager.manages((IResource)projects[i]) && (info = ManagedBuildManager.getBuildInfo((IResource)projects[i])) != null) {
                        IConfiguration[] cfgs = info.getManagedProject().getConfigurations();
                        int j = 0;
                        while (j < cfgs.length) {
                            cfgs[j].setRebuildState(true);
                            ++j;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }
}

