/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.projectconverter;

import java.io.File;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.projectconverter.ConverterMessages;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;

class UpdateManagedProject21 {
    private static final String CONTENT_TYPE_PREF_NODE = "content-types";
    private static final String FULLPATH_CONTENT_TYPE_PREF_NODE = "org.eclipse.core.runtime/content-types";
    private static final String PREF_LOCAL_CONTENT_TYPE_SETTINGS = "enabled";

    UpdateManagedProject21() {
    }

    static void doProjectUpdate(IProgressMonitor monitor, final IProject project) throws CoreException {
        String[] projectName = new String[]{project.getName()};
        IFile file = project.getFile(".cdtbuild");
        File settingsFile = file.getLocation().toFile();
        if (!settingsFile.exists()) {
            monitor.done();
            return;
        }
        monitor.beginTask(ConverterMessages.getFormattedString("UpdateManagedProject20.0", projectName), 1);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        UpdateManagedProjectManager.backupFile(file, "_21backup", monitor, project);
        ((ManagedBuildInfo)info).setVersion(ManagedBuildManager.getBuildInfoVersion().toString());
        info.setValid(true);
        IWorkspace workspace = project.getWorkspace();
        ISchedulingRule rule1 = workspace.getRuleFactory().createRule((IResource)project);
        ISchedulingRule rule2 = workspace.getRuleFactory().refreshRule((IResource)project);
        ISchedulingRule rule = MultiRule.combine((ISchedulingRule)rule1, (ISchedulingRule)rule2);
        WorkspaceJob job = new WorkspaceJob(ConverterMessages.getResourceString("UpdateManagedProject.notice")){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                UpdateManagedProject21.checkForCPPWithC(monitor, project);
                ManagedBuildManager.saveBuildInfo(project, true);
                return Status.OK_STATUS;
            }
        };
        job.setRule(rule);
        job.schedule();
        monitor.done();
    }

    static void checkForCPPWithC(IProgressMonitor monitor, final IProject project) {
        block7: {
            if (CoreModel.hasCCNature((IProject)project)) {
                try {
                    try {
                        IWorkspace workspace = project.getWorkspace();
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                project.refreshLocal(2, monitor);
                            }
                        };
                        workspace.run(runnable, (ISchedulingRule)project, 1, monitor);
                    }
                    catch (Exception exception) {}
                    final boolean[] found = new boolean[1];
                    project.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            if (found[0] || proxy.isDerived()) {
                                return false;
                            }
                            if (proxy.getType() == 1) {
                                String ext = proxy.requestFullPath().getFileExtension();
                                if (ext != null && "c".equals(ext)) {
                                    found[0] = true;
                                }
                                return false;
                            }
                            return true;
                        }
                    }, 0);
                    if (!found[0]) break block7;
                    ProjectScope projectScope = new ProjectScope(project);
                    IEclipsePreferences contentTypePrefs = projectScope.getNode(FULLPATH_CONTENT_TYPE_PREF_NODE);
                    contentTypePrefs.putBoolean(PREF_LOCAL_CONTENT_TYPE_SETTINGS, true);
                    try {
                        contentTypePrefs.flush();
                    }
                    catch (BackingStoreException backingStoreException) {}
                    IContentTypeManager manager = Platform.getContentTypeManager();
                    IContentType contentType = manager.getContentType("org.eclipse.cdt.core.cxxSource");
                    IContentTypeSettings settings = contentType.getSettings((IScopeContext)projectScope);
                    settings.addFileSpec("c", 8);
                }
                catch (CoreException coreException) {}
            }
        }
    }
}

