/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildPropertyPage;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BuildSettingsBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "BuildSettingsBlock";
    private static final String LABEL = "BuildSettingsBlock.label";
    private static final String SETTINGS_LABEL = "BuildSettingsBlock.label.Settings";
    private static final String GROUP = "BuildSettingsBlock.label.makecmdgroup";
    private static final String DEF_BTN = "BuildSettingsBlock.label.makecmddef";
    private static final String OUTPUT_GROUP = "BuildSettingsBlock.label.output.group";
    private static final String OUTPUT_EXT = "BuildSettingsBlock.label.output.extension";
    private static final String OUTPUT_NAME = "BuildSettingsBlock.label.output.name";
    private static final String MACROS_GROUP = "BuildSettingsBlock.label.macros.group";
    private static final String PACROS_EXPAND_BTN = "BuildSettingsBlock.label.macros.expand";
    private static final String EMPTY_STRING = new String();
    protected Text buildArtifactExt;
    protected Text buildArtifactName;
    protected Button makeCommandDefault;
    protected Text makeCommandEntry;
    protected Button buildMacrosExpand;
    protected Group buildMacrosExpandGroup;
    private BuildPropertyPage parent;
    private boolean dirty = false;
    private ModifyListener widgetModified = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            IConfiguration config = BuildSettingsBlock.this.parent.getSelectedConfigurationClone();
            if (e.widget == BuildSettingsBlock.this.buildArtifactName) {
                String val = BuildSettingsBlock.this.buildArtifactName.getText().trim();
                if (!val.equals(config.getArtifactName())) {
                    config.setArtifactName(val);
                    BuildSettingsBlock.this.setValues();
                    BuildSettingsBlock.this.setDirty(true);
                }
            } else if (e.widget == BuildSettingsBlock.this.buildArtifactExt) {
                String val = BuildSettingsBlock.this.buildArtifactExt.getText().trim();
                if (!val.equals(config.getArtifactExtension())) {
                    config.setArtifactExtension(val);
                    BuildSettingsBlock.this.setValues();
                    BuildSettingsBlock.this.setDirty(true);
                }
            } else if (e.widget == BuildSettingsBlock.this.makeCommandEntry) {
                String fullCommand = BuildSettingsBlock.this.makeCommandEntry.getText().trim();
                String buildCommand = BuildSettingsBlock.this.parseMakeCommand(fullCommand);
                String buildArgs = BuildSettingsBlock.this.parseMakeArgs(fullCommand);
                if (!buildCommand.equals(config.getBuildCommand()) || !buildArgs.equals(config.getBuildArguments())) {
                    BuildSettingsBlock.this.parent.getSelectedConfigurationClone().setBuildCommand(buildCommand);
                    BuildSettingsBlock.this.parent.getSelectedConfigurationClone().setBuildArguments(buildArgs);
                    BuildSettingsBlock.this.setValues();
                    BuildSettingsBlock.this.setDirty(true);
                }
            }
        }
    };

    public BuildSettingsBlock(BuildPropertyPage parent) {
        super(ManagedBuilderUIMessages.getResourceString(SETTINGS_LABEL));
        super.setContainer((ICOptionContainer)parent);
        this.parent = parent;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setFont(parent.getFont());
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)comp);
        this.createBuildArtifactGroup(comp);
        this.createMakeCommandGroup(comp);
        this.createExpandMacrosGroup(comp);
    }

    private void createBuildArtifactGroup(Composite parent) {
        Group outputGroup = new Group(parent, 0);
        outputGroup.setFont(parent.getFont());
        outputGroup.setText(ManagedBuilderUIMessages.getResourceString(OUTPUT_GROUP));
        outputGroup.setLayout((Layout)new GridLayout(3, false));
        outputGroup.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label((Composite)outputGroup, 16384);
        nameLabel.setFont(outputGroup.getFont());
        nameLabel.setText(ManagedBuilderUIMessages.getResourceString(OUTPUT_NAME));
        nameLabel.setLayoutData((Object)new GridData(768));
        Label placeHolder = new Label((Composite)outputGroup, 0x1000000);
        placeHolder.setText(new String());
        placeHolder.setLayoutData((Object)new GridData());
        Label extLabel = new Label((Composite)outputGroup, 16384);
        extLabel.setFont(outputGroup.getFont());
        extLabel.setText(ManagedBuilderUIMessages.getResourceString(OUTPUT_EXT));
        extLabel.setLayoutData((Object)new GridData(768));
        this.buildArtifactName = new Text((Composite)outputGroup, 2052);
        this.buildArtifactName.setFont(outputGroup.getFont());
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.buildArtifactName.setLayoutData((Object)data);
        this.buildArtifactName.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BuildSettingsBlock.this.buildArtifactName = null;
            }
        });
        this.buildArtifactName.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ManagedBuilderUIMessages.getResourceString(BuildSettingsBlock.OUTPUT_NAME);
            }
        });
        this.buildArtifactName.addModifyListener(this.widgetModified);
        Label dotLabel = new Label((Composite)outputGroup, 0x1000000);
        dotLabel.setFont(outputGroup.getFont());
        dotLabel.setText(new String("."));
        dotLabel.setLayoutData((Object)new GridData());
        this.buildArtifactExt = new Text((Composite)outputGroup, 2052);
        this.buildArtifactExt.setFont(outputGroup.getFont());
        data = new GridData(768);
        data.widthHint = 100;
        this.buildArtifactExt.setLayoutData((Object)data);
        this.buildArtifactExt.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BuildSettingsBlock.this.buildArtifactExt = null;
            }
        });
        this.buildArtifactExt.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ManagedBuilderUIMessages.getResourceString(BuildSettingsBlock.OUTPUT_EXT);
            }
        });
        this.buildArtifactExt.addModifyListener(this.widgetModified);
    }

    private void createMakeCommandGroup(Composite parent) {
        Group makeCommandGroup = new Group(parent, 0);
        makeCommandGroup.setFont(parent.getFont());
        makeCommandGroup.setText(ManagedBuilderUIMessages.getResourceString(GROUP));
        makeCommandGroup.setLayout((Layout)new GridLayout(1, true));
        makeCommandGroup.setLayoutData((Object)new GridData(768));
        this.makeCommandDefault = new Button((Composite)makeCommandGroup, 16416);
        this.makeCommandDefault.setFont(makeCommandGroup.getFont());
        this.makeCommandDefault.setText(ManagedBuilderUIMessages.getResourceString(DEF_BTN));
        this.makeCommandDefault.setBackground(makeCommandGroup.getBackground());
        this.makeCommandDefault.setForeground(makeCommandGroup.getForeground());
        this.makeCommandDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildSettingsBlock.this.handleUseDefaultPressed();
            }
        });
        this.makeCommandDefault.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BuildSettingsBlock.this.makeCommandDefault = null;
            }
        });
        this.makeCommandEntry = new Text((Composite)makeCommandGroup, 2052);
        this.makeCommandEntry.setFont(makeCommandGroup.getFont());
        this.makeCommandEntry.setLayoutData((Object)new GridData(768));
        this.makeCommandEntry.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BuildSettingsBlock.this.makeCommandEntry = null;
            }
        });
        this.makeCommandEntry.addModifyListener(this.widgetModified);
    }

    private void createExpandMacrosGroup(Composite parent) {
        this.buildMacrosExpandGroup = new Group(parent, 0);
        this.buildMacrosExpandGroup.setFont(parent.getFont());
        this.buildMacrosExpandGroup.setText(ManagedBuilderUIMessages.getResourceString(MACROS_GROUP));
        this.buildMacrosExpandGroup.setLayout((Layout)new GridLayout(1, true));
        this.buildMacrosExpandGroup.setLayoutData((Object)new GridData(768));
        this.buildMacrosExpand = new Button((Composite)this.buildMacrosExpandGroup, 16416);
        this.buildMacrosExpand.setFont(this.buildMacrosExpandGroup.getFont());
        this.buildMacrosExpand.setText(ManagedBuilderUIMessages.getResourceString(PACROS_EXPAND_BTN));
        this.buildMacrosExpand.setBackground(this.buildMacrosExpandGroup.getBackground());
        this.buildMacrosExpand.setForeground(this.buildMacrosExpandGroup.getForeground());
        this.buildMacrosExpand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildMacroProvider provider = (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
                IConfiguration config = BuildSettingsBlock.this.parent.getSelectedConfigurationClone();
                if (BuildSettingsBlock.this.buildMacrosExpand.getSelection() != provider.areMacrosExpandedInBuildfile(config)) {
                    provider.expandMacrosInBuildfile(config, BuildSettingsBlock.this.buildMacrosExpand.getSelection());
                    BuildSettingsBlock.this.setValues();
                    BuildSettingsBlock.this.setDirty(true);
                }
            }
        });
        this.buildMacrosExpand.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BuildSettingsBlock.this.buildMacrosExpand = null;
            }
        });
    }

    protected void initializeValues() {
        this.setValues();
        this.setDirty(false);
    }

    public void updateValues() {
        this.setValues();
        this.makeCommandDefault.setSelection(!this.parent.getSelectedConfigurationClone().hasOverriddenBuildCommand());
        this.makeCommandEntry.setEditable(!this.makeCommandDefault.getSelection());
    }

    protected void setValues() {
        BuildMacroProvider provider;
        IConfiguration config = this.parent.getSelectedConfigurationClone();
        if (!config.getArtifactName().equals(this.buildArtifactName.getText())) {
            this.buildArtifactName.setText(config.getArtifactName());
        }
        if (!config.getArtifactExtension().equals(this.buildArtifactExt.getText())) {
            this.buildArtifactExt.setText(config.getArtifactExtension());
        }
        String makeCommand = config.getBuildCommand();
        String makeArgs = config.getBuildArguments();
        if (makeArgs != null) {
            makeCommand = String.valueOf(makeCommand) + " " + makeArgs;
        }
        if (!makeCommand.equals(this.makeCommandEntry.getText())) {
            this.makeCommandEntry.setText(makeCommand);
        }
        if (!(provider = (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider()).canKeepMacrosInBuildfile(config)) {
            this.buildMacrosExpandGroup.setVisible(false);
        } else {
            this.buildMacrosExpandGroup.setVisible(true);
            this.buildMacrosExpand.setSelection(provider.areMacrosExpandedInBuildfile(config));
        }
    }

    public void removeValues(String id) {
    }

    public void performDefaults() {
        IConfiguration cloneConfig = this.parent.getSelectedConfigurationClone();
        cloneConfig.setArtifactName(cloneConfig.getManagedProject().getDefaultArtifactName());
        cloneConfig.setArtifactExtension(null);
        IBuilder cloneBuilder = cloneConfig.getToolChain().getBuilder();
        if (!cloneBuilder.isExtensionElement()) {
            cloneConfig.getToolChain().removeLocalBuilder();
        }
        BuildMacroProvider provider = (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
        provider.expandMacrosInBuildfile(cloneConfig, false);
        this.setValues();
        this.makeCommandDefault.setSelection(true);
        this.makeCommandEntry.setEditable(false);
        this.setDirty(true);
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        IConfiguration selectedConfiguration = this.parent.getSelectedConfiguration();
        IConfiguration cloneConfig = this.parent.getSelectedConfigurationClone();
        String buildCommand = cloneConfig.getBuildCommand();
        String buildArgs = cloneConfig.getBuildArguments();
        String artifactName = cloneConfig.getArtifactName();
        String artifactExt = cloneConfig.getArtifactExtension();
        if (!selectedConfiguration.getArtifactName().equals(artifactName)) {
            selectedConfiguration.setArtifactName(artifactName);
        }
        if (!selectedConfiguration.getArtifactExtension().equals(artifactExt)) {
            selectedConfiguration.setArtifactExtension(artifactExt);
        }
        if (!selectedConfiguration.getBuildCommand().equals(buildCommand)) {
            selectedConfiguration.setBuildCommand(buildCommand);
        }
        if (!selectedConfiguration.getBuildArguments().equals(buildArgs)) {
            selectedConfiguration.setBuildArguments(buildArgs);
        }
        BuildMacroProvider provider = (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
        provider.expandMacrosInBuildfile(selectedConfiguration, provider.areMacrosExpandedInBuildfile(cloneConfig));
        this.setDirty(false);
    }

    private String parseMakeArgs(String rawCommand) {
        StringBuffer result = new StringBuffer();
        String actualCommand = this.parseMakeCommand(rawCommand);
        String arguments = rawCommand.substring(actualCommand.length());
        if (arguments.length() == 0) {
            return result.toString().trim();
        }
        String[] tokens = arguments.trim().split("\\s");
        Pattern flagPattern = Pattern.compile("C|f|I|j|l|O|W");
        Pattern mixedFlagWithArg = Pattern.compile("-[^CfIjloW]*[CfIjloW]{1}.+");
        int i = 0;
        while (i < tokens.length) {
            String currentToken = tokens[i];
            if (currentToken.startsWith("--")) {
                result.append(currentToken);
                result.append(" ");
            } else if (currentToken.startsWith("-")) {
                if (i + 1 >= tokens.length) {
                    result.append(currentToken);
                } else {
                    String nextToken = tokens[i + 1];
                    Matcher flagMatcher = flagPattern.matcher(currentToken);
                    if (!flagMatcher.find()) {
                        result.append(currentToken);
                        result.append(" ");
                    } else if (mixedFlagWithArg.matcher(currentToken).matches()) {
                        result.append(currentToken);
                        result.append(" ");
                    } else {
                        result.append(currentToken);
                        result.append(" ");
                        result.append(nextToken);
                        result.append(" ");
                        ++i;
                    }
                }
            }
            ++i;
        }
        return result.toString().trim();
    }

    private String parseMakeCommand(String rawCommand) {
        StringBuffer command = new StringBuffer();
        String[] result = rawCommand.split("\\s");
        int i = 0;
        while (i < result.length) {
            String cmdSegment = result[i];
            if (i + 1 >= result.length) {
                command.append(cmdSegment);
            } else {
                String nextSegment = result[i + 1];
                if (nextSegment.startsWith("-")) {
                    command.append(cmdSegment);
                    break;
                }
                command.append(cmdSegment);
                command.append(" ");
            }
            ++i;
        }
        return command.toString().trim();
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setValues();
        }
        super.setVisible(visible);
    }

    protected void handleUseDefaultPressed() {
        boolean checked = this.makeCommandDefault.getSelection();
        IConfiguration config = this.parent.getSelectedConfigurationClone();
        if (checked) {
            config.setBuildCommand(null);
            config.setBuildArguments(null);
            this.makeCommandEntry.setEditable(false);
        } else {
            this.makeCommandEntry.setEditable(true);
        }
        this.setValues();
        this.setDirty(true);
    }

    public void setDirty(boolean b) {
        this.dirty = b;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

