/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuildOptionBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class BuildPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ICOptionContainer {
    private static final String PREFIX = "BuildPreferencePage";
    private static final String LABEL = "BuildPreferencePage.label";
    private static final String SETTINGS_LABEL = "BuildPreferencePage.label.Settings";
    private static final String REBUILD_JOB_NAME = "BuildPreferencePage.job.rebuild";
    private static final String APPLY_INTARNAL_ERROR = "BuildPreferencePage.apply.internal.error";
    protected ManagedBuildOptionBlock fOptionBlock = new ManagedBuildOptionBlock(this);
    private boolean fRebuildNeeded = false;

    public void init(IWorkbench workbench) {
    }

    protected boolean rebuildNeeded() {
        return this.fRebuildNeeded;
    }

    protected void setRebuildState(boolean rebuild) {
        this.fRebuildNeeded = rebuild;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.fOptionBlock.createContents(composite, ResourcesPlugin.getWorkspace());
        return composite;
    }

    public void updateContainer() {
        this.fOptionBlock.update();
        this.setValid(this.fOptionBlock.isValid());
        this.setErrorMessage(this.fOptionBlock.getErrorMessage());
    }

    public IProject getProject() {
        return null;
    }

    public Preferences getPreferences() {
        return null;
    }

    protected void performApply() {
        this.applySettings();
    }

    protected void performDefaults() {
        this.fOptionBlock.performDefaults();
        super.performDefaults();
    }

    public ManagedBuildOptionBlock getOptionBlock() {
        return this.fOptionBlock;
    }

    protected boolean applySettings() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                if (BuildPreferencePage.this.fOptionBlock.isDirty()) {
                    BuildPreferencePage.this.fOptionBlock.performApply(monitor);
                    BuildPreferencePage.this.fOptionBlock.setDirty(false);
                    BuildPreferencePage.this.setRebuildState(true);
                }
            }
        };
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getTargetException();
            ManagedBuilderUIPlugin.errorDialog(this.getShell(), ManagedBuilderUIMessages.getResourceString(APPLY_INTARNAL_ERROR), e1.toString(), e1);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public boolean performCancel() {
        if (this.rebuildNeeded()) {
            this.initiateRebuild();
        }
        return true;
    }

    public boolean performOk() {
        if (!this.applySettings()) {
            return false;
        }
        if (this.rebuildNeeded()) {
            this.initiateRebuild();
        }
        return true;
    }

    private void initiateRebuild() {
        this.setRebuildState(false);
        IWorkspace wsp = ResourcesPlugin.getWorkspace();
        IProject[] projects = wsp.getRoot().getProjects();
        ArrayList<IProject> managedProjectList = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            if (ManagedBuildManager.manages((IResource)projects[i])) {
                managedProjectList.add(projects[i]);
            }
            ++i;
        }
        projects = managedProjectList.toArray(new IProject[managedProjectList.size()]);
        final IProject[] projectsToBuild = wsp.computeProjectOrder((IProject[])projects).projects;
        WorkspaceJob rebuildJob = new WorkspaceJob(ManagedBuilderUIMessages.getResourceString(REBUILD_JOB_NAME)){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD.equals(family);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < projectsToBuild.length) {
                    IManagedBuildInfo bi;
                    if (ManagedBuildManager.manages((IResource)projectsToBuild[i]) && (bi = ManagedBuildManager.getBuildInfo((IResource)projectsToBuild[i])) != null & bi instanceof ManagedBuildInfo) {
                        ((ManagedBuildInfo)bi).initializePathEntries();
                    }
                    ++i;
                }
                i = 0;
                while (i < projectsToBuild.length) {
                    try {
                        projectsToBuild[i].build(6, monitor);
                    }
                    catch (CoreException coreException) {
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        rebuildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        rebuildJob.setUser(true);
        rebuildJob.schedule();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fOptionBlock.setVisible(visible);
    }
}

