/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.Collection;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.internal.macros.MbsMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.ui.ToolsSettingsBlock;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListElement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;

public class BuildToolSettingsPreferenceStore
implements IPreferenceStore {
    public static final String DEFAULT_SEPERATOR = ";";
    private static final String EMPTY_STRING;
    private static final String WHITESPACE = " ";
    public static final String ALL_OPTIONS_ID;
    public static final String COMMAND_LINE_PATTERN_ID = "org.eclipse.commandLinePatternId";
    private IConfiguration config;
    private IResourceConfiguration rcConfig;
    private IOptionCategory optCategory;
    private ToolListElement selectedElement;
    private ListenerList listenerList;
    private boolean dirtyFlag;
    private ToolsSettingsBlock block;

    static {
        ALL_OPTIONS_ID = EMPTY_STRING = new String();
    }

    public BuildToolSettingsPreferenceStore(ToolsSettingsBlock block) {
        this.block = block;
    }

    public void setSelection(IConfiguration cfg, ToolListElement element, IOptionCategory category) {
        this.selectedElement = element;
        this.optCategory = category;
        this.rcConfig = null;
        this.config = cfg;
    }

    public void setSelection(IResourceConfiguration cfg, ToolListElement element, IOptionCategory category) {
        this.selectedElement = element;
        this.optCategory = category;
        this.rcConfig = cfg;
        this.config = cfg.getParent();
    }

    public IConfiguration getSelectedConfig() {
        return this.config;
    }

    public String getOptionPrefName(IOption option) {
        IOption extOption = BuildToolSettingsPreferenceStore.getExtensionOption(option);
        if (extOption != null) {
            return extOption.getId();
        }
        return option.getId();
    }

    private static IOption getExtensionOption(IOption option) {
        while (option != null && (!option.isExtensionElement() || ((Option)option).isAdjustedExtension() || ((Option)option).wasOptRef())) {
            option = option.getSuperClass();
        }
        return option;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.add((Object)listener);
    }

    public boolean contains(String name) {
        if (this.optCategory instanceof Tool) {
            if (this.optCategory.getId().equals(name)) {
                return true;
            }
            if (COMMAND_LINE_PATTERN_ID.equals(name)) {
                return true;
            }
            if (ALL_OPTIONS_ID.equals(name)) {
                return true;
            }
        } else if (this.getOptionValue(name) != null) {
            return true;
        }
        return false;
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        Object[] listeners = this.listenerList.getListeners();
        if (!(listeners.length <= 0 || oldValue != null && oldValue.equals(newValue))) {
            PropertyChangeEvent pe = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            int i = 0;
            while (i < listeners.length) {
                IPropertyChangeListener l = (IPropertyChangeListener)listeners[i];
                l.propertyChange(pe);
                ++i;
            }
        }
    }

    public boolean getBoolean(String name) {
        Object val = this.getOptionValue(name);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return this.getDefaultBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return false;
    }

    public double getDefaultDouble(String name) {
        return 0.0;
    }

    public float getDefaultFloat(String name) {
        return 0.0f;
    }

    public int getDefaultInt(String name) {
        return 0;
    }

    public long getDefaultLong(String name) {
        return 0L;
    }

    public String getDefaultString(String name) {
        return EMPTY_STRING;
    }

    public double getDouble(String name) {
        return this.getDefaultDouble(name);
    }

    public float getFloat(String name) {
        return this.getDefaultFloat(name);
    }

    public int getInt(String name) {
        return this.getDefaultInt(name);
    }

    public long getLong(String name) {
        return this.getDefaultLong(name);
    }

    public String getString(String name) {
        if (this.optCategory instanceof Tool) {
            if (this.optCategory.getId().equals(name)) {
                return ((Tool)this.optCategory).getToolCommand();
            }
            if (COMMAND_LINE_PATTERN_ID.equals(name)) {
                return ((Tool)this.optCategory).getCommandLinePattern();
            }
            if (ALL_OPTIONS_ID.equals(name)) {
                try {
                    return BuildToolSettingsPreferenceStore.listToString(((Tool)this.optCategory).getToolCommandFlags(null, null, (IMacroSubstitutor)new UIMacroSubstitutor(0, null, EMPTY_STRING, WHITESPACE, this.block.obtainMacroProvider())), WHITESPACE);
                }
                catch (BuildException buildException) {}
            }
        } else {
            Object val = this.getOptionValue(name);
            if (val instanceof String) {
                return (String)val;
            }
            if (val instanceof Collection) {
                return BuildToolSettingsPreferenceStore.listToString(((Collection)val).toArray(new String[0]));
            }
        }
        return this.getDefaultString(name);
    }

    public static String listToString(String[] items) {
        return BuildToolSettingsPreferenceStore.listToString(items, DEFAULT_SEPERATOR);
    }

    protected Object getOptionValue(String name) {
        Object[] option = this.getOption(name);
        if (option != null) {
            try {
                IOption opt = (IOption)option[1];
                Object val = opt.getValue();
                if (opt.getValueType() == 1 && val instanceof String) {
                    val = opt.getEnumName((String)val);
                }
                return val;
            }
            catch (BuildException buildException) {}
        }
        return null;
    }

    public Object[] getOption(String name) {
        IHoldsOptions selectedHolder = this.selectedElement.getHoldOptions();
        if (selectedHolder == null) {
            selectedHolder = this.selectedElement.getTool();
        }
        Object[][] options = this.rcConfig != null ? this.optCategory.getOptions(this.rcConfig, selectedHolder) : this.optCategory.getOptions(this.config, selectedHolder);
        int i = 0;
        while (i < options.length) {
            IHoldsOptions ho = (IHoldsOptions)options[i][0];
            if (ho == null) break;
            IOption option = (IOption)options[i][1];
            if (option.getId().equals(name) || (!option.isExtensionElement() || ((Option)option).isAdjustedExtension() || ((Option)option).wasOptRef()) && option.getSuperClass() != null && option.getSuperClass().getId().equals(name)) {
                return options[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isDefault(String name) {
        return false;
    }

    public boolean needsSaving() {
        return this.dirtyFlag;
    }

    public void putValue(String name, String value) {
        this.setValue(name, value);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public void setDefault(String name, double value) {
    }

    public void setDefault(String name, float value) {
    }

    public void setDefault(String name, int value) {
    }

    public void setDefault(String name, long value) {
    }

    public void setDefault(String name, String defaultObject) {
    }

    public void setDefault(String name, boolean value) {
    }

    public void setToDefault(String name) {
    }

    protected void setDirty(boolean isDirty) {
        this.dirtyFlag = isDirty;
    }

    public void setValue(String name, double value) {
    }

    public void setValue(String name, float value) {
    }

    public void setValue(String name, int value) {
    }

    public void setValue(String name, long value) {
    }

    public void setValue(String name, String value) {
        if (this.optCategory instanceof Tool) {
            if (this.optCategory.getId().equals(name)) {
                ((Tool)this.optCategory).setToolCommand(value);
            } else if (COMMAND_LINE_PATTERN_ID.equals(name)) {
                ((Tool)this.optCategory).setCommandLinePattern(value);
            }
        } else {
            this.setOptionValue(name, value);
        }
    }

    public void setValue(String name, boolean value) {
        this.setOptionValue(name, new Boolean(value));
    }

    protected void setOptionValue(String name, Object value) {
        Object[] opt = this.getOption(name);
        if (opt != null) {
            IOption option = (IOption)opt[1];
            IHoldsOptions holder = (IHoldsOptions)opt[0];
            IOption newOption = null;
            try {
                switch (option.getValueType()) {
                    case 2: {
                        if (value instanceof String) {
                            if (this.rcConfig != null) {
                                newOption = this.rcConfig.setOption(holder, option, (String)value);
                                break;
                            }
                            newOption = this.config.setOption(holder, option, (String)value);
                        }
                        break;
                    }
                    case 0: {
                        if (value instanceof Boolean) {
                            boolean val = (Boolean)value;
                            if (this.rcConfig != null) {
                                newOption = this.rcConfig.setOption(holder, option, val);
                                break;
                            }
                            newOption = this.config.setOption(holder, option, val);
                        }
                        break;
                    }
                    case 1: {
                        if (value instanceof String) {
                            String val = (String)value;
                            String enumId = option.getEnumeratedId(val);
                            if (this.rcConfig != null) {
                                newOption = this.rcConfig.setOption(holder, option, enumId != null && enumId.length() > 0 ? enumId : val);
                                break;
                            }
                            newOption = this.config.setOption(holder, option, enumId != null && enumId.length() > 0 ? enumId : val);
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (value instanceof String) {
                            String[] val = BuildToolSettingsPreferenceStore.parseString((String)value);
                            if (this.rcConfig != null) {
                                newOption = this.rcConfig.setOption(holder, option, val);
                                break;
                            }
                            newOption = this.config.setOption(holder, option, val);
                        }
                        break;
                    }
                }
            }
            catch (BuildException buildException) {}
        }
    }

    public static String[] parseString(String stringList) {
        if (stringList == null || stringList.length() == 0) {
            return new String[0];
        }
        return stringList.split(DEFAULT_SEPERATOR);
    }

    public static String listToString(String[] items, String separator) {
        StringBuffer path = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            path.append(items[i]);
            if (i < items.length - 1) {
                path.append(separator);
            }
            ++i;
        }
        return path.toString();
    }

    public class UIMacroSubstitutor
    extends DefaultMacroSubstitutor {
        private BuildMacroProvider fProvider;

        public UIMacroSubstitutor(int contextType, Object contextData, String inexistentMacroValue, String listDelimiter, BuildMacroProvider provider) {
            super(contextType, contextData, inexistentMacroValue, listDelimiter);
            this.fProvider = provider;
        }

        public UIMacroSubstitutor(IMacroContextInfo contextInfo, String inexistentMacroValue, String listDelimiter) {
            super(contextInfo, inexistentMacroValue, listDelimiter);
        }

        protected IMacroContextInfo getMacroContextInfo(int contextType, Object contextData) {
            if (this.fProvider != null) {
                return this.fProvider.getMacroContextInfo(contextType, contextData);
            }
            return super.getMacroContextInfo();
        }

        protected DefaultMacroSubstitutor.ResolvedMacro resolveMacro(IBuildMacro macro) throws BuildMacroException {
            if (macro instanceof MbsMacroSupplier.FileContextMacro) {
                MbsMacroSupplier.FileContextMacro fileMacro = (MbsMacroSupplier.FileContextMacro)macro;
                if (fileMacro.isExplicit()) {
                    String name = macro.getName();
                    return new DefaultMacroSubstitutor.ResolvedMacro((DefaultMacroSubstitutor)this, name, MacroResolver.createMacroReference((String)name));
                }
            } else if (macro instanceof MbsMacroSupplier.OptionMacro) {
                String name = macro.getName();
                return new DefaultMacroSubstitutor.ResolvedMacro((DefaultMacroSubstitutor)this, name, MacroResolver.createMacroReference((String)name));
            }
            return super.resolveMacro(macro);
        }
    }
}

