/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIImages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.properties.IFileListChangeListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class FileListControl {
    private ToolBar toolBar;
    private ToolItem titleItem;
    private ToolItem addItem;
    private ToolItem deleteItem;
    private ToolItem editItem;
    private ToolItem moveUpItem;
    private ToolItem moveDownItem;
    private Label title;
    private Image addImage;
    private Image deleteImage;
    private Image editImage;
    private Image moveUpImage;
    private Image moveDownImage;
    private Composite composite;
    private org.eclipse.swt.widgets.List list;
    private String compTitle;
    private SelectionListener selectionListener;
    private GridData tgdata;
    private GridData grid3;
    private GridData grid4;
    private GridData grid2;
    private int browseType;
    private IPath path;
    private List listeners = new ArrayList();
    private String[] oldValue;
    private static final String ADD_STR = ManagedBuilderUIMessages.getResourceString("FileListControl.add");
    private static final String DEL_STR = ManagedBuilderUIMessages.getResourceString("FileListControl.delete");
    private static final String EDIT_STR = ManagedBuilderUIMessages.getResourceString("FileListControl.edit");
    private static final String MOVEUP_STR = ManagedBuilderUIMessages.getResourceString("FileListControl.moveup");
    private static final String MOVEDOWN_STR = ManagedBuilderUIMessages.getResourceString("FileListControl.movedown");
    private static final String FILE_TITLE = ManagedBuilderUIMessages.getResourceString("BrowseEntryDialog.title.file");
    private static final String DIR_TITLE = ManagedBuilderUIMessages.getResourceString("BrowseEntryDialog.title.directory");
    private static final String FILE_MSG = ManagedBuilderUIMessages.getResourceString("BrowseEntryDialog.message.file");
    private static final String DIR_MSG = ManagedBuilderUIMessages.getResourceString("BrowseEntryDialog.message.directory");
    private static final String TITLE = ManagedBuilderUIMessages.getResourceString("BuildPropertyCommon.label.title");
    private final Image IMG_ADD = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_FILELIST_ADD);
    private final Image IMG_DEL = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_FILELIST_DEL);
    private final Image IMG_EDIT = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_FILELIST_EDIT);
    private final Image IMG_MOVEUP = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_FILELIST_MOVEUP);
    private final Image IMG_MOVEDOWN = ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_FILELIST_MOVEDOWN);

    public FileListControl(Composite parent, String compTitle, int type) {
        this.browseType = type;
        Composite filePanel = new Composite(parent, 0);
        GridLayout form1 = new GridLayout();
        form1.numColumns = 1;
        form1.horizontalSpacing = 0;
        form1.verticalSpacing = 0;
        form1.marginHeight = 0;
        form1.marginWidth = 0;
        filePanel.setLayout((Layout)form1);
        filePanel.setLayoutData((Object)new GridData(1808));
        Composite titlePanel = new Composite(filePanel, 2048);
        GridLayout titleform = new GridLayout(2, false);
        titleform.horizontalSpacing = 0;
        titleform.verticalSpacing = 0;
        titleform.marginHeight = 0;
        titleform.marginWidth = 0;
        titlePanel.setLayout((Layout)titleform);
        this.tgdata = new GridData(768);
        this.tgdata.heightHint = 25;
        titlePanel.setLayoutData((Object)this.tgdata);
        this.title = new Label(titlePanel, 1);
        this.compTitle = "  " + compTitle;
        this.title.setText(this.compTitle);
        this.grid2 = new GridData(768);
        this.title.setLayoutData((Object)this.grid2);
        Composite buttonPanel = new Composite(titlePanel, 0);
        GridLayout form2 = new GridLayout();
        form2.numColumns = 5;
        form2.horizontalSpacing = 0;
        form2.verticalSpacing = 0;
        form2.marginWidth = 0;
        form2.marginHeight = 0;
        buttonPanel.setLayout((Layout)form2);
        this.toolBar = new ToolBar(buttonPanel, 8519936);
        this.addItem = new ToolItem(this.toolBar, 8);
        this.addItem.setImage(this.IMG_ADD);
        this.addItem.setToolTipText(ADD_STR);
        this.addItem.addSelectionListener(this.getSelectionListener());
        this.deleteItem = new ToolItem(this.toolBar, 8);
        this.deleteItem.setImage(this.IMG_DEL);
        this.deleteItem.setToolTipText(DEL_STR);
        this.deleteItem.addSelectionListener(this.getSelectionListener());
        this.editItem = new ToolItem(this.toolBar, 8);
        this.editItem.setImage(this.IMG_EDIT);
        this.editItem.setToolTipText(EDIT_STR);
        this.editItem.addSelectionListener(this.getSelectionListener());
        this.moveUpItem = new ToolItem(this.toolBar, 8);
        this.moveUpItem.setImage(this.IMG_MOVEUP);
        this.moveUpItem.setToolTipText(MOVEUP_STR);
        this.moveUpItem.addSelectionListener(this.getSelectionListener());
        this.moveDownItem = new ToolItem(this.toolBar, 8);
        this.moveDownItem.setImage(this.IMG_MOVEDOWN);
        this.moveDownItem.setToolTipText(MOVEDOWN_STR);
        this.moveDownItem.addSelectionListener(this.getSelectionListener());
        this.grid3 = new GridData(896);
        buttonPanel.setLayoutData((Object)this.grid3);
        this.list = new org.eclipse.swt.widgets.List(filePanel, 2816);
        this.grid4 = new GridData(1808);
        Point preferredSize = titlePanel.computeSize(-1, -1);
        this.grid4.widthHint = preferredSize.x;
        this.grid4.heightHint = preferredSize.y * 3;
        this.grid4.horizontalSpan = 2;
        this.list.setLayoutData((Object)this.grid4);
        this.list.addSelectionListener(this.getSelectionListener());
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FileListControl.this.editSelection();
            }
        });
        this.list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    FileListControl.this.removePressed();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        this.selectionChanged();
    }

    public void setList(String[] listVal) {
        if (this.list != null) {
            this.list.removeAll();
        }
        int i = 0;
        while (i < listVal.length) {
            this.list.add(listVal[i]);
            ++i;
        }
        this.checkNotificationNeeded();
    }

    public void addChangeListener(IFileListChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(IFileListChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void checkNotificationNeeded() {
        String[] items = this.getItems();
        if (this.oldValue != null) {
            if (this.oldValue.length == items.length) {
                int i = 0;
                while (i < this.oldValue.length) {
                    if (!this.oldValue[i].equals(items[i])) break;
                    ++i;
                }
                if (i == this.oldValue.length) {
                    return;
                }
            }
            String[] old = this.oldValue;
            this.oldValue = new String[items.length];
            System.arraycopy(items, 0, this.oldValue, 0, items.length);
            this.notifyListeners(old, this.oldValue);
        } else {
            this.oldValue = new String[items.length];
            System.arraycopy(items, 0, this.oldValue, 0, items.length);
        }
    }

    public void notifyListeners(String[] oldVal, String[] newVal) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((IFileListChangeListener)iter.next()).fileListChanged(this, oldVal, newVal);
        }
    }

    public void setSelection(int sel) {
        if (this.list.getItemCount() > 0) {
            this.list.setSelection(sel);
        }
        this.selectionChanged();
    }

    public void setSelection() {
        if (this.list.getItemCount() > 0) {
            this.list.setSelection(0);
        }
    }

    public void removeAll() {
        if (this.list != null) {
            this.list.removeAll();
            this.checkNotificationNeeded();
        }
    }

    public String[] getItems() {
        return this.list.getItems();
    }

    private void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == FileListControl.this.addItem) {
                    FileListControl.this.addPressed();
                } else if (widget == FileListControl.this.deleteItem) {
                    FileListControl.this.removePressed();
                } else if (widget == FileListControl.this.moveUpItem) {
                    FileListControl.this.upPressed();
                } else if (widget == FileListControl.this.moveDownItem) {
                    FileListControl.this.downPressed();
                } else if (widget == FileListControl.this.list) {
                    FileListControl.this.selectionChanged();
                } else if (widget == FileListControl.this.editItem) {
                    FileListControl.this.editSelection();
                }
            }
        };
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    private void addPressed() {
        String input = this.getNewInputObject();
        if (input != null && input.length() > 0) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
                this.list.setSelection(index + 1);
            } else {
                this.list.add(input, 0);
                this.list.setSelection(0);
            }
            this.checkNotificationNeeded();
        }
        this.selectionChanged();
    }

    private void removePressed() {
        int index = this.list.getSelectionIndex();
        if (this.browseType == 2 || this.browseType == 1) {
            String quest = ManagedBuilderUIMessages.getResourceString("FileListControl.deletedialog.message");
            String title = ManagedBuilderUIMessages.getResourceString("FileListControl.deletedialog.title");
            boolean delDir = MessageDialog.openQuestion((Shell)this.list.getShell(), (String)title, (String)quest);
            if (delDir && index != -1) {
                this.list.remove(index);
                this.checkNotificationNeeded();
            }
        } else if (index != -1) {
            this.list.remove(index);
            this.checkNotificationNeeded();
        }
        this.selectionChanged();
    }

    private void upPressed() {
        int index = this.list.getSelectionIndex();
        String curSelList = this.list.getItem(index);
        String preList = this.list.getItem(index - 1);
        this.list.setItem(index - 1, curSelList);
        this.list.setItem(index, preList);
        this.list.setSelection(index - 1);
        this.checkNotificationNeeded();
        this.selectionChanged();
    }

    private void downPressed() {
        int index = this.list.getSelectionIndex();
        String curSelList = this.list.getItem(index);
        String nextList = this.list.getItem(index + 1);
        this.list.setItem(index + 1, curSelList);
        this.list.setItem(index, nextList);
        this.list.setSelection(index + 1);
        this.checkNotificationNeeded();
        this.selectionChanged();
    }

    private void editSelection() {
        int index = this.list.getSelectionIndex();
        if (index != -1) {
            String selItem = this.list.getItem(index);
            String title = ManagedBuilderUIMessages.getResourceString("FileListControl.editdialog.title");
            if (selItem != null) {
                InputDialog dialog = new InputDialog(null, title, this.compTitle, selItem, null);
                String newItem = null;
                if (dialog.open() == 0 && (newItem = dialog.getValue()) != null && !newItem.equals(selItem)) {
                    this.list.setItem(index, newItem);
                    this.checkNotificationNeeded();
                    this.selectionChanged();
                }
            }
        }
    }

    public void selectionChanged() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        this.deleteItem.setEnabled(size > 0);
        this.moveUpItem.setEnabled(size > 1 && index > 0);
        this.moveDownItem.setEnabled(size > 1 && index >= 0 && index < size - 1);
        this.editItem.setEnabled(size > 0);
    }

    public org.eclipse.swt.widgets.List getListControl() {
        return this.list;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setType(int type) {
        this.browseType = type;
    }

    private String getNewInputObject() {
        String input = null;
        String title = new String();
        String message = new String();
        String initVal = new String();
        if (this.browseType == 2) {
            title = DIR_TITLE;
            message = DIR_MSG;
            initVal = this.path == null ? initVal : this.path.toString();
        } else if (this.browseType == 1) {
            title = FILE_TITLE;
            message = FILE_MSG;
            initVal = this.path == null ? initVal : this.path.toString();
        } else {
            title = TITLE;
            message = this.compTitle;
        }
        SelectPathInputDialog dialog = new SelectPathInputDialog(this.getListControl().getShell(), title, message, initVal, null, this.browseType);
        if (dialog.open() == 0) {
            input = dialog.getValue();
        }
        if (input != null && input.length() > 0 && (this.browseType == 2 || this.browseType == 1)) {
            int firstWhitespace = input.indexOf(" ");
            int firstBackslash = input.indexOf("\\");
            if (firstWhitespace != -1 || firstBackslash != -1) {
                input = "\"" + input + "\"";
            }
        }
        return input;
    }

    public Label getLabelControl() {
        return this.title;
    }

    public void setEnabled(boolean enabled) {
        this.title.setEnabled(enabled);
        this.toolBar.setEnabled(enabled);
        this.list.setEnabled(enabled);
    }

    class SelectPathInputDialog
    extends InputDialog {
        private static final String BROWSE = "BuildPropertyCommon.label.browse";
        private int type;

        public SelectPathInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator, int type) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
            this.type = type;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            if (this.type != 0) {
                Button browse = this.createButton(parent, 3, ManagedBuilderUIMessages.getResourceString(BROWSE), false);
                browse.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ SelectPathInputDialog this$1;
                    {
                        this.this$1 = selectPathInputDialog;
                    }

                    public void widgetSelected(SelectionEvent ev) {
                        switch (SelectPathInputDialog.access$0(this.this$1)) {
                            case 2: {
                                String result;
                                DirectoryDialog dialog = new DirectoryDialog(SelectPathInputDialog.access$1(this.this$1), 4096);
                                String currentName = SelectPathInputDialog.access$2(this.this$1).getText();
                                if (currentName != null && currentName.trim().length() != 0) {
                                    dialog.setFilterPath(currentName);
                                }
                                if ((result = dialog.open()) == null) break;
                                SelectPathInputDialog.access$2(this.this$1).setText(result);
                                break;
                            }
                            case 1: {
                                String result;
                                FileDialog browseDialog = new FileDialog(SelectPathInputDialog.access$1(this.this$1));
                                String currentName = SelectPathInputDialog.access$2(this.this$1).getText();
                                if (currentName != null && currentName.trim().length() != 0) {
                                    browseDialog.setFilterPath(currentName);
                                }
                                if ((result = browseDialog.open()) == null) break;
                                SelectPathInputDialog.access$2(this.this$1).setText(result);
                            }
                        }
                    }
                });
            }
        }

        static /* synthetic */ int access$0(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.type;
        }

        static /* synthetic */ Shell access$1(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.getParentShell();
        }

        static /* synthetic */ Text access$2(SelectPathInputDialog selectPathInputDialog) {
            return selectPathInputDialog.getText();
        }
    }
}

