/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuildOptionBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractBuildPropertyPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolSettingsPreferenceStore;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.help.WorkbenchHelp;

public class ResourceBuildPropertyPage
extends AbstractBuildPropertyPage
implements IWorkbenchPropertyPage,
IPreferencePageContainer,
ICOptionContainer {
    private static final String PREFIX = "ResourceBuildPropertyPage";
    private static final String LABEL = "ResourceBuildPropertyPage.label";
    private static final String NAME_LABEL = "ResourceBuildPropertyPage.label.NameText";
    private static final String CONFIG_LABEL = "ResourceBuildPropertyPage.label.Configuration";
    private static final String ALL_CONFS = "ResourceBuildPropertyPage.selection.configuration.all";
    private static final String ACTIVE_RESOURCE_LABEL = "ResourceBuildPropertyPage.label.ActiveResource";
    private static final String RESOURCE_SETTINGS_LABEL = "ResourceBuildPropertyPage.label.ResourceSettings";
    private static final String TREE_LABEL = "ResourceBuildPropertyPage.label.ToolTree";
    private static final String OPTIONS_LABEL = "ResourceBuildPropertyPage.label.ToolOptions";
    private static final String NOTMBSFILE_LABEL = "ResourceBuildPropertyPage.label.NotMBSFile";
    private static final String EXCLUDE_CHECKBOX = "ResourceBuildPropertyPage.label.ExcludeCheckBox";
    private static final String TIP = "ResourceBuildPropertyPage.tip";
    private static final String RESOURCE_PLAT_TIP = "ResourceBuildPropertyPage.tip.ResourcePlatform";
    private static final String CONF_TIP = "ResourceBuildPropertyPage.tip.config";
    private static final String EXCLUDE_TIP = "ResourceBuildPropertyPage.tip.excludecheck";
    private static final String MANAGE_TITLE = "ResourceBuildPropertyPage.manage.title";
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{20, 30};
    private static final String ID_SEPARATOR = ".";
    private static final String MSG_UNSUPPORTED_PROJ = "ResourceBuildPropertyPage.unsupported.proj";
    private static final String MSG_UNSUPPORTED_CONFIG = "ResourceBuildPropertyPage.unsupported.config";
    private static final String MSG_CONFIG_NOTSELECTED = "ResourceBuildPropertyPage.config.notselected";
    private static final String MSG_RC_NON_BUILD = "ResourceBuildPropertyPage.rc.non.build";
    private static final String MSG_RC_GENERATED = "ResourceBuildPropertyPage.rc.generated";
    private static final boolean DEFAULT_EXCLUDE_VALUE = false;
    private Combo configSelector;
    private Button excludedCheckBox;
    private boolean noContentOnPage = false;
    private IConfiguration[] configurations;
    private IConfiguration selectedConfiguration;
    private IConfiguration clonedConfiguration;
    private IResourceConfiguration clonedResourceConfig;
    private Point lastShellSize;
    protected ManagedBuildOptionBlock fOptionBlock;
    protected boolean displayedConfig = false;

    public void setContainer(IPreferencePageContainer preferencePageContainer) {
        super.setContainer(preferencePageContainer);
        if (this.fOptionBlock == null) {
            this.fOptionBlock = new ManagedBuildOptionBlock(this);
        }
    }

    protected Control createContents(Composite parent) {
        boolean openMBSProject;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 1;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        try {
            openMBSProject = this.getProject().hasNature(ManagedCProjectNature.MNG_NATURE_ID);
        }
        catch (CoreException coreException) {
            openMBSProject = false;
        }
        if (openMBSProject) {
            this.contentForMBSFile(composite);
        } else {
            this.noContent(composite, ManagedBuilderUIMessages.getResourceString(NOTMBSFILE_LABEL));
        }
        return composite;
    }

    protected void contentForMBSFile(Composite composite) {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        String error = null;
        if (info.getVersion() == null) {
            error = ManagedBuilderUIMessages.getResourceString("ResourceBuildPropertyPage.error.version_low");
        } else {
            IFile file = (IFile)this.getElement();
            if (this.isGeneratedResource(file)) {
                error = ManagedBuilderUIMessages.getResourceString(MSG_RC_GENERATED);
            } else if (file.isDerived()) {
                error = ManagedBuilderUIMessages.getResourceString(MSG_RC_NON_BUILD);
            }
        }
        if (error != null) {
            this.noContent(composite, error);
            return;
        }
        Group configGroup = ControlFactory.createGroup((Composite)composite, (String)ManagedBuilderUIMessages.getResourceString(ACTIVE_RESOURCE_LABEL), (int)1);
        GridData gd = new GridData(256);
        gd.grabExcessHorizontalSpace = true;
        configGroup.setLayoutData((Object)gd);
        FormLayout form = new FormLayout();
        form.marginHeight = 5;
        form.marginWidth = 5;
        configGroup.setLayout((Layout)form);
        this.excludedCheckBox = ControlFactory.createCheckBox((Composite)configGroup, (String)ManagedBuilderUIMessages.getResourceString(EXCLUDE_CHECKBOX));
        this.excludedCheckBox.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResourceBuildPropertyPage.this.handleIsExcluded();
            }
        });
        this.excludedCheckBox.setToolTipText(ManagedBuilderUIMessages.getResourceString(EXCLUDE_TIP));
        FormData fd = new FormData();
        fd.left = new FormAttachment((Control)this.excludedCheckBox, 0, 0x1000000);
        this.excludedCheckBox.setLayoutData((Object)fd);
        Label configLabel = ControlFactory.createLabel((Composite)configGroup, (String)ManagedBuilderUIMessages.getResourceString(CONFIG_LABEL));
        this.configSelector = new Combo((Composite)configGroup, 12);
        this.configSelector.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ResourceBuildPropertyPage.this.handleConfigSelection();
            }
        });
        this.configSelector.setToolTipText(ManagedBuilderUIMessages.getResourceString(CONF_TIP));
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.excludedCheckBox, 15, -1);
        configLabel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.excludedCheckBox, 15, -1);
        fd.left = new FormAttachment((Control)configLabel, 5, -1);
        fd.right = new FormAttachment(80, -20);
        this.configSelector.setLayoutData((Object)fd);
        Group tabGroup = ControlFactory.createGroup((Composite)composite, (String)ManagedBuilderUIMessages.getResourceString(RESOURCE_SETTINGS_LABEL), (int)1);
        gd = new GridData(1808);
        tabGroup.setLayoutData((Object)gd);
        this.populateConfigurations();
        this.fOptionBlock.createContents((Composite)tabGroup, this.getElement());
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.cdt.ui.man_prop_build");
    }

    protected void noContent(Composite composite, String message) {
        Label label = new Label(composite, 16384);
        label.setText(message);
        label.setFont(composite.getFont());
        this.noContentOnPage = true;
        this.noDefaultAndApplyButton();
    }

    private void handleIsExcluded() {
        boolean isSelected = this.excludedCheckBox.getSelection();
        this.setExcluded(isSelected);
    }

    private String[] getConfigurationNames() {
        String[] names = new String[this.configurations.length];
        int index = 0;
        while (index < this.configurations.length) {
            names[index] = this.configurations[index].getName();
            ++index;
        }
        return names;
    }

    protected Point getLastShellSize() {
        Shell shell;
        if (this.lastShellSize == null && (shell = this.getShell()) != null) {
            this.lastShellSize = shell.getSize();
        }
        return this.lastShellSize;
    }

    public IProject getProject() {
        IAdaptable element = this.getElement();
        if (element != null && element instanceof IFile) {
            IFile file = (IFile)element;
            return file.getProject();
        }
        return null;
    }

    public IConfiguration getSelectedConfiguration() {
        return this.selectedConfiguration;
    }

    private void handleConfigSelection() {
        if (this.configSelector.getItemCount() == 0) {
            return;
        }
        int selectionIndex = this.configSelector.getSelectionIndex();
        if (selectionIndex == -1) {
            return;
        }
        String configName = this.configSelector.getItem(selectionIndex);
        if (configName.equals(ManagedBuilderUIMessages.getResourceString(ALL_CONFS))) {
            return;
        }
        IConfiguration newConfig = this.configurations[selectionIndex];
        if (newConfig != this.selectedConfiguration) {
            Shell shell;
            boolean shouldApply;
            if (this.selectedConfiguration != null && this.fOptionBlock.isDirty() && (shouldApply = MessageDialog.openQuestion((Shell)(shell = ManagedBuilderUIPlugin.getDefault().getShell()), (String)ManagedBuilderUIMessages.getResourceString("BuildPropertyPage.changes.save.title"), (String)ManagedBuilderUIMessages.getFormattedString("BuildPropertyPage.changes.save.question", new String[]{this.selectedConfiguration.getName(), newConfig.getName()})))) {
                if (this.performOk()) {
                    this.fOptionBlock.setDirty(false);
                } else {
                    MessageDialog.openWarning((Shell)shell, (String)ManagedBuilderUIMessages.getResourceString("BuildPropertyPage.changes.save.title"), (String)ManagedBuilderUIMessages.getResourceString("BuildPropertyPage.changes.save.error"));
                }
            }
            this.selectedConfiguration = newConfig;
            ManagedBuildManager.setSelectedConfiguration((IProject)this.getProject(), (IConfiguration)this.selectedConfiguration);
            this.clonedConfiguration = this.getClonedConfig(this.selectedConfiguration);
            this.clonedResourceConfig = this.getCurrentResourceConfig(this.clonedConfiguration, true);
            this.fOptionBlock.updateValues();
            this.excludedCheckBox.setSelection(this.isExcluded());
        }
    }

    private void doUpdateMessage() {
        if (this.selectedConfiguration != null) {
            if (this.selectedConfiguration.isSupported()) {
                this.setMessage(null, 0);
            } else {
                IProjectType projType;
                IManagedProject mngProj = this.selectedConfiguration.getManagedProject();
                IProjectType iProjectType = projType = mngProj != null ? mngProj.getProjectType() : null;
                if (projType != null && !projType.isSupported()) {
                    this.setMessage(ManagedBuilderUIMessages.getResourceString(MSG_UNSUPPORTED_PROJ), 2);
                } else {
                    this.setMessage(ManagedBuilderUIMessages.getResourceString(MSG_UNSUPPORTED_CONFIG), 2);
                }
            }
        } else {
            this.setMessage(ManagedBuilderUIMessages.getResourceString(MSG_CONFIG_NOTSELECTED), 2);
        }
        this.getContainer().updateMessage();
    }

    public boolean isGeneratedResource(IFile file) {
        IConfiguration cfg = this.getSelectedConfiguration();
        IProject project = this.getProject();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (cfg == null) {
            cfg = info.getDefaultConfiguration();
        }
        if (cfg != null && info != null) {
            IManagedBuilderMakefileGenerator makeGen = ManagedBuildManager.getBuildfileGenerator((IConfiguration)cfg);
            makeGen.initialize(project, info, null);
            return makeGen.isGeneratedResource((IResource)file);
        }
        return false;
    }

    public boolean isBuildResource(IFile file, IConfiguration cfg) {
        IResourceConfiguration rcCfg = cfg.getResourceConfiguration(file.getFullPath().toString());
        if (rcCfg != null) {
            ITool[] tools = rcCfg.getTools();
            if (tools == null || tools.length == 0) {
                return false;
            }
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                if (!tool.getCustomBuildStep() || tool.isExtensionElement()) {
                    return true;
                }
                ++i;
            }
        } else {
            String ext = file.getFileExtension();
            ITool[] tools = cfg.getFilteredTools();
            int index = 0;
            while (index < tools.length) {
                ITool tool = tools[index];
                if (tool.buildsFileType(ext)) {
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    public boolean isBuildResource(IFile file) {
        IConfiguration[] cfgs;
        IManagedProject managedProject;
        IProject project = file.getProject();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null && (managedProject = info.getManagedProject()) != null && (cfgs = managedProject.getConfigurations()) != null && cfgs.length > 0) {
            int i = 0;
            while (i < cfgs.length) {
                if (this.isBuildResource(file, cfgs[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void performDefaults() {
        this.fOptionBlock.performDefaults();
        this.excludedCheckBox.setSelection(this.getCurrentResourceConfigClone().isExcluded());
        super.performDefaults();
    }

    public boolean performOk() {
        boolean retStatus = true;
        if (this.noContentOnPage) {
            return true;
        }
        if (!this.displayedConfig) {
            return true;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                if (ResourceBuildPropertyPage.this.containsDefaults()) {
                    ResourceBuildPropertyPage.this.removeCurrentResourceConfig();
                    return;
                }
                ResourceBuildPropertyPage.this.fOptionBlock.performApply(monitor);
                ResourceBuildPropertyPage.this.getCurrentResourceConfig(true).setExclude(ResourceBuildPropertyPage.this.getCurrentResourceConfigClone().isExcluded());
            }
        };
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            Throwable e1 = e.getTargetException();
            ManagedBuilderUIPlugin.errorDialog(this.getShell(), ManagedBuilderUIMessages.getResourceString("ManagedProjectPropertyPage.internalError"), e1.toString(), e1);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)this.getProject(), (IConfiguration)this.getSelectedConfiguration());
        if (this.getCurrentResourceConfigClone().isDirty()) {
            this.selectedConfiguration.setRebuildState(true);
            this.getCurrentResourceConfigClone().setDirty(false);
        }
        retStatus = ManagedBuildManager.saveBuildInfo((IProject)this.getProject(), (boolean)false);
        IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (bi != null & bi instanceof ManagedBuildInfo) {
            ((ManagedBuildInfo)bi).initializePathEntries();
        }
        EnvironmentVariableProvider.fUserSupplier.checkInexistentConfigurations(this.clonedConfiguration.getManagedProject());
        return retStatus;
    }

    public boolean containsDefaults() {
        if (this.getCurrentResourceConfigClone().isExcluded()) {
            return false;
        }
        return this.fOptionBlock.containsDefaults();
    }

    public boolean performCancel() {
        if (this.noContentOnPage) {
            return true;
        }
        EnvironmentVariableProvider.fUserSupplier.checkInexistentConfigurations(this.clonedConfiguration.getManagedProject());
        return true;
    }

    private void populateConfigurations() {
        ManagedBuildManager.setSelectedConfiguration((IProject)this.getProject(), (IConfiguration)this.selectedConfiguration);
        if (this.configSelector == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        this.configurations = info.getManagedProject().getConfigurations();
        if (this.configurations.length == 0) {
            return;
        }
        this.configSelector.removeAll();
        this.configSelector.setItems(this.getConfigurationNames());
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        int index = this.configSelector.indexOf(defaultConfig.getName());
        this.configSelector.select(index == -1 ? 0 : index);
        this.handleConfigSelection();
    }

    public IResourceConfiguration getCurrentResourceConfigClone() {
        return this.clonedResourceConfig;
    }

    public IResourceConfiguration getCurrentResourceConfig(boolean create) {
        return this.getCurrentResourceConfig(this.selectedConfiguration, create);
    }

    private IResourceConfiguration getCurrentResourceConfig(IConfiguration cfg, boolean create) {
        IResourceConfiguration rcCfg = cfg.getResourceConfiguration(((IFile)this.getElement()).getFullPath().toString());
        if (rcCfg == null && create) {
            rcCfg = cfg.createResourceConfiguration((IFile)this.getElement());
        }
        return rcCfg;
    }

    public boolean removeCurrentResourceConfig() {
        IResourceConfiguration rcCfg = this.getCurrentResourceConfig(false);
        if (rcCfg != null) {
            this.selectedConfiguration.removeResourceConfiguration(rcCfg);
            return true;
        }
        return false;
    }

    public void updateButtons() {
    }

    public void updateMessage() {
    }

    public void updateTitle() {
    }

    public void updateContainer() {
        this.fOptionBlock.update();
        this.setValid(this.fOptionBlock.isValid());
        this.setErrorMessage(this.fOptionBlock.getErrorMessage());
    }

    public boolean isValid() {
        this.updateContainer();
        return super.isValid();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fOptionBlock.setVisible(visible);
        if (visible) {
            this.fOptionBlock.updateValues();
            this.displayedConfig = true;
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fOptionBlock.getPreferenceStore();
    }

    public BuildToolSettingsPreferenceStore getToolSettingsPreferenceStore() {
        return this.fOptionBlock.getToolSettingsPreferenceStore();
    }

    public Preferences getPreferences() {
        return null;
    }

    public void enableConfigSelection(boolean enable) {
        this.configSelector.setEnabled(enable);
    }

    public boolean isExcluded() {
        return this.getCurrentResourceConfigClone().isExcluded();
    }

    public void setExcluded(boolean isExcluded) {
        this.getCurrentResourceConfigClone().setExclude(isExcluded);
        this.fOptionBlock.updateValues();
    }
}

