/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.refactoring;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionPrototypeScope;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.c.ICScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.SavedCodeReaderFactory;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.refactoring.ASTNameVisitor;
import org.eclipse.cdt.internal.refactoring.ASTSpecificNameVisitor;
import org.eclipse.cdt.internal.refactoring.CRefactoringArgument;
import org.eclipse.cdt.internal.refactoring.CRefactoringMatchStore;
import org.eclipse.cdt.internal.refactoring.Messages;
import org.eclipse.cdt.refactoring.CRefactoringMatch;
import org.eclipse.cdt.refactoring.CRefactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;

public class ASTManager {
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int UNKNOWN = -1;
    private CRefactory fRefactory;
    private Map fTranslationUnits = new HashMap();
    private HashSet fProblemUnits = new HashSet();
    private CRefactoringArgument fArgument;
    private IBinding[] fValidBindings;
    private String fRenameTo;
    private HashMap fKnownBindings;
    private HashSet fConflictingBinding;

    public static String nth_of_m(int n, int m) {
        StringBuffer nofm = new StringBuffer();
        ASTManager.append_nth_of_m(n, m, nofm);
        return nofm.toString();
    }

    static void append_nth_of_m(int n, int m, StringBuffer buf) {
        buf.append(n);
        switch (n) {
            case 1: {
                buf.append("st");
                break;
            }
            case 2: {
                buf.append("nd");
                break;
            }
            case 3: {
                buf.append("rd");
                break;
            }
            default: {
                buf.append("th");
            }
        }
        buf.append(" of ");
        buf.append(m);
    }

    public static IASTFileLocation getLocationInTranslationUnit(IASTNode node) {
        return node.getFileLocation();
    }

    public static IASTName getSimpleName(IASTName name) {
        IASTName[] names;
        if (name instanceof ICPPASTQualifiedName && (names = ((ICPPASTQualifiedName)name).getNames()).length > 0) {
            name = names[names.length - 1];
        }
        return name;
    }

    public static int isSameBinding(IBinding b1, IBinding b2) throws DOMException {
        if (b1 == null || b2 == null) {
            return -1;
        }
        if (b1.equals(b2)) {
            return 1;
        }
        String n1 = b1.getName();
        String n2 = b2.getName();
        if (n1 == null || n2 == null) {
            return -1;
        }
        if (!n1.equals(n2)) {
            return 0;
        }
        if (b1 instanceof ICompositeType) {
            IScope s2;
            if (!(b2 instanceof ICompositeType)) {
                return 0;
            }
            ICompositeType c1 = (ICompositeType)b1;
            ICompositeType c2 = (ICompositeType)b2;
            if (c1.getKey() != c2.getKey()) {
                return 0;
            }
            IScope s1 = c1.getCompositeScope();
            if (s1 != null) {
                s1 = s1.getParent();
            }
            if ((s2 = c2.getCompositeScope()) != null) {
                s2 = s2.getParent();
            }
            return ASTManager.isSameScope(s1, s2, false);
        }
        if (b1 instanceof IFunction) {
            int r2;
            int r1;
            if (!(b2 instanceof IFunction)) {
                return 0;
            }
            boolean isStatic = false;
            boolean checkSig = true;
            IFunction c1 = (IFunction)b1;
            IFunction c2 = (IFunction)b2;
            if (b1 instanceof ICPPMethod) {
                if (!(b2 instanceof ICPPMethod)) {
                    return 0;
                }
            } else {
                if (b2 instanceof ICPPMethod) {
                    return 0;
                }
                boolean bl = isStatic = c1.isStatic() || c2.isStatic();
                if (!(b1 instanceof ICPPFunction) && !(b2 instanceof ICPPFunction)) {
                    checkSig = false;
                }
            }
            if ((r1 = ASTManager.isSameScope(b1.getScope(), b2.getScope(), isStatic)) == 0) {
                return 0;
            }
            int n = r2 = checkSig ? ASTManager.hasSameSignature(c1, c2) : 1;
            if (r2 == 0) {
                return 0;
            }
            if (r1 != r2) {
                return -1;
            }
            return r1;
        }
        if (b1 instanceof IVariable) {
            int result;
            boolean fileStatic = false;
            if (!(b2 instanceof IVariable)) {
                return 0;
            }
            IVariable c1 = (IVariable)b1;
            IVariable c2 = (IVariable)b2;
            if (b1 instanceof IField) {
                if (!(b2 instanceof IField)) {
                    return 0;
                }
            } else if (b1 instanceof IParameter) {
                if (!(b2 instanceof IParameter)) {
                    return 0;
                }
            } else {
                if (b2 instanceof IField || b2 instanceof IParameter) {
                    return 0;
                }
                fileStatic = c1.isStatic() || c2.isStatic();
            }
            return (result = ASTManager.isSameScope(c1.getScope(), c2.getScope(), fileStatic)) == -1 ? 1 : result;
        }
        if (b1 instanceof IEnumerator) {
            if (!(b2 instanceof IEnumerator)) {
                return 0;
            }
            return ASTManager.isSameScope(b1.getScope(), b2.getScope(), false);
        }
        if (b1 instanceof ITypedef) {
            if (!(b2 instanceof ITypedef)) {
                return 0;
            }
            return ASTManager.isSameScope(b1.getScope(), b2.getScope(), false);
        }
        if (b1 instanceof IMacroBinding) {
            if (!(b2 instanceof IMacroBinding)) {
                return 0;
            }
            return 1;
        }
        if (b1 instanceof IEnumeration) {
            if (!(b2 instanceof IEnumeration)) {
                return 0;
            }
            return ASTManager.isSameScope(b1.getScope(), b2.getScope(), false);
        }
        int scopeCmp = ASTManager.isSameScope(b1.getScope(), b2.getScope(), false);
        if (scopeCmp != 1) {
            return scopeCmp;
        }
        if (b1.getClass().equals(b2.getClass())) {
            return 1;
        }
        return -1;
    }

    public static int isSameScope(IScope s1, IScope s2, boolean fileStatic) throws DOMException {
        IASTNode node2;
        if (s1 == s2) {
            return 1;
        }
        IASTNode node1 = s1 == null ? null : s1.getPhysicalNode();
        IASTNode iASTNode = node2 = s2 == null ? null : s2.getPhysicalNode();
        if (s1 == null) {
            if (!fileStatic && node2 instanceof IASTTranslationUnit) {
                return 1;
            }
            return -1;
        }
        if (s2 == null) {
            if (!fileStatic && node1 instanceof IASTTranslationUnit) {
                return 1;
            }
            return -1;
        }
        if (s1.equals(s2)) {
            return 1;
        }
        if (node1 instanceof IASTTranslationUnit && node2 instanceof IASTTranslationUnit) {
            return ASTManager.hasSameLocation(node1, node2, fileStatic);
        }
        String name1 = ASTManager.getName(s1);
        String name2 = ASTManager.getName(s2);
        if (s1 instanceof ICPPBlockScope) {
            if (s2 instanceof ICPPBlockScope) {
                return ASTManager.hasSameLocation(node1, node2, fileStatic);
            }
            return 0;
        }
        if (s1 instanceof ICPPNamespaceScope) {
            if (s2 instanceof ICPPNamespaceScope) {
                ICPPNamespaceScope n1 = (ICPPNamespaceScope)s1;
                ICPPNamespaceScope n2 = (ICPPNamespaceScope)s2;
                int r1 = ASTManager.hasSameLocation(node1, node2, fileStatic);
                if (r1 == 1) {
                    return r1;
                }
                if (!name1.equals(name2)) {
                    return 0;
                }
                return ASTManager.isSameScope(n1.getParent(), n2.getParent(), fileStatic);
            }
            return 0;
        }
        if (!name1.equals(name2)) {
            return 0;
        }
        if (s1 instanceof ICPPClassScope || s1 instanceof ICCompositeTypeScope) {
            if (s2 instanceof ICPPClassScope || s2 instanceof ICCompositeTypeScope) {
                return ASTManager.isSameScope(s1.getParent(), s2.getParent(), fileStatic);
            }
            return 0;
        }
        if (s1 instanceof ICPPFunctionScope) {
            if (s2 instanceof ICPPFunctionScope) {
                return ASTManager.hasSameLocation(node1, node2, true);
            }
            return 0;
        }
        if (s1 instanceof ICFunctionScope || s1 instanceof ICFunctionPrototypeScope || s1 instanceof ICScope) {
            if (s2 instanceof ICFunctionScope || s2 instanceof ICFunctionPrototypeScope || s2 instanceof ICScope) {
                return ASTManager.hasSameLocation(node1, node2, true);
            }
            return 0;
        }
        return ASTManager.isSameScope(s1.getParent(), s2.getParent(), fileStatic);
    }

    public static String getName(IScope s1) {
        String name = null;
        try {
            name = ASTManager.getNameOrNull(s1.getPhysicalNode());
        }
        catch (DOMException dOMException) {}
        return name == null ? s1.toString() : name;
    }

    public static int hasSameSignature(IFunction b1, IFunction b2) throws DOMException {
        int r1 = ASTManager.isSameParameterList(b1.getParameters(), b2.getParameters());
        if (r1 == 0) {
            return 0;
        }
        if (b1 instanceof ICPPMethod) {
            if (b2 instanceof ICPPMethod) {
                return r1;
            }
            return 0;
        }
        return r1;
    }

    public static int hasSameSignature(IFunctionType b1, IFunctionType b2) throws DOMException {
        return ASTManager.isSameParameterList(b1.getParameterTypes(), b2.getParameterTypes());
    }

    private static int isSameParameterList(IType[] p1, IType[] p2) throws DOMException {
        if (p1 == p2) {
            return 1;
        }
        if (p1 == null || p2 == null) {
            return -1;
        }
        if (p1.length != p2.length) {
            return 0;
        }
        int retval = 1;
        int i = 0;
        while (i < p2.length) {
            switch (ASTManager.isSameType(p1[i], p2[i])) {
                case 0: {
                    return 0;
                }
                case -1: {
                    retval = -1;
                }
            }
            ++i;
        }
        return retval;
    }

    private static int isSameParameterList(IParameter[] p1, IParameter[] p2) throws DOMException {
        if (p1 == p2) {
            return 1;
        }
        if (p1 == null || p2 == null) {
            return -1;
        }
        if (p1.length != p2.length) {
            return 0;
        }
        int retval = 1;
        int i = 0;
        while (i < p2.length) {
            switch (ASTManager.isSameType(p1[i].getType(), p2[i].getType())) {
                case 0: {
                    return 0;
                }
                case -1: {
                    retval = -1;
                }
            }
            ++i;
        }
        return retval;
    }

    private static int isSameType(IType t1, IType t2) throws DOMException {
        if (t1 != null && t2 != null && t1.isSameType(t2)) {
            return 1;
        }
        if ((t1 = ASTManager.getRealType(t1)) == (t2 = ASTManager.getRealType(t2))) {
            return 1;
        }
        if (t1 == null || t2 == null || t1 instanceof IProblemBinding || t2 instanceof IProblemBinding) {
            return -1;
        }
        if (t1 instanceof IArrayType) {
            if (t2 instanceof IArrayType) {
                IArrayType a1 = (IArrayType)t1;
                IArrayType a2 = (IArrayType)t2;
                return ASTManager.isSameType(a1.getType(), a2.getType());
            }
            return 0;
        }
        if (t1 instanceof IBasicType) {
            if (t2 instanceof IBasicType) {
                IBasicType a1 = (IBasicType)t1;
                IBasicType a2 = (IBasicType)t2;
                if (ASTManager.getBasicType(a1.getType()) != ASTManager.getBasicType(a2.getType())) {
                    return 0;
                }
                if (ASTManager.getSigned(a1) != ASTManager.getSigned(a2) || a1.isUnsigned() != a2.isUnsigned()) {
                    return 0;
                }
                if (a1.isLong() != a2.isLong() || a1.isShort() != a2.isShort()) {
                    return 0;
                }
                return 1;
            }
            return 0;
        }
        if (t1 instanceof ICompositeType) {
            if (t2 instanceof ICompositeType) {
                ICompositeType a1 = (ICompositeType)t1;
                ICompositeType a2 = (ICompositeType)t2;
                if (a1.getKey() != a2.getKey()) {
                    return 0;
                }
                return ASTManager.isSameScope(a1.getCompositeScope(), a2.getCompositeScope(), false);
            }
            return 0;
        }
        if (t1 instanceof ICPPReferenceType) {
            if (t2 instanceof ICPPReferenceType) {
                ICPPReferenceType a1 = (ICPPReferenceType)t1;
                ICPPReferenceType a2 = (ICPPReferenceType)t2;
                return ASTManager.isSameType(a1.getType(), a2.getType());
            }
            return 0;
        }
        if (t1 instanceof ICPPTemplateTypeParameter) {
            if (t2 instanceof ICPPTemplateTypeParameter) {
                return 1;
            }
            return 0;
        }
        if (t1 instanceof IEnumeration) {
            if (t2 instanceof IEnumeration) {
                IEnumeration a1 = (IEnumeration)t1;
                IEnumeration a2 = (IEnumeration)t2;
                return ASTManager.isSameScope(a1.getScope(), a2.getScope(), false);
            }
            return 0;
        }
        if (t1 instanceof IFunctionType) {
            if (t2 instanceof IFunctionType) {
                IFunctionType a1 = (IFunctionType)t1;
                IFunctionType a2 = (IFunctionType)t2;
                return ASTManager.hasSameSignature(a1, a2);
            }
            return 0;
        }
        if (t1 instanceof IPointerType) {
            if (t2 instanceof IPointerType) {
                IPointerType a1 = (IPointerType)t1;
                IPointerType a2 = (IPointerType)t2;
                if (a1.isConst() != a2.isConst() || a1.isVolatile() != a2.isVolatile()) {
                    return 0;
                }
                return ASTManager.isSameType(a1.getType(), a2.getType());
            }
            return 0;
        }
        if (t1 instanceof IQualifierType) {
            if (t2 instanceof IQualifierType) {
                IQualifierType a1 = (IQualifierType)t1;
                IQualifierType a2 = (IQualifierType)t2;
                if (a1.isConst() != a2.isConst() || a1.isVolatile() != a2.isVolatile()) {
                    return 0;
                }
                return ASTManager.isSameType(a1.getType(), a2.getType());
            }
            return 0;
        }
        return -1;
    }

    private static boolean getSigned(IBasicType a2) throws DOMException {
        if (a2.isSigned()) {
            return true;
        }
        if (a2.isUnsigned()) {
            return false;
        }
        switch (a2.getType()) {
            case 0: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private static int getBasicType(int bc) {
        if (bc == 0) {
            bc = 3;
        }
        return bc;
    }

    private static IType getRealType(IType t) {
        while (t instanceof ITypedef) {
            try {
                t = ((ITypedef)t).getType();
            }
            catch (DOMException dOMException) {}
        }
        return t;
    }

    private static String getNameOrNull(IASTNode node) {
        if (node instanceof IASTDeclarator) {
            return ASTManager.getSimpleName(((IASTDeclarator)node).getName()).toString();
        }
        if (node instanceof IASTNamedTypeSpecifier) {
            return ASTManager.getSimpleName(((IASTNamedTypeSpecifier)node).getName()).toString();
        }
        if (node instanceof IASTCompositeTypeSpecifier) {
            return ASTManager.getSimpleName(((IASTCompositeTypeSpecifier)node).getName()).toString();
        }
        if (node instanceof IASTTranslationUnit) {
            return ((IASTTranslationUnit)node).getFilePath();
        }
        return null;
    }

    private static int hasSameLocation(IASTNode node1, IASTNode node2, boolean fileStatic) throws DOMException {
        if (node1 == null || node2 == null) {
            return -1;
        }
        if (!fileStatic && node1 instanceof IASTTranslationUnit && node2 instanceof IASTTranslationUnit) {
            return 1;
        }
        IASTFileLocation l1 = node1.getNodeLocations()[0].asFileLocation();
        IASTFileLocation l2 = node2.getNodeLocations()[0].asFileLocation();
        if (l1 == null || l2 == null) {
            return -1;
        }
        if (!l1.getFileName().equals(l2.getFileName())) {
            return 0;
        }
        if (l1.getNodeOffset() != l2.getNodeOffset()) {
            return 0;
        }
        if (l1.getNodeLength() != l2.getNodeLength()) {
            return 0;
        }
        return 1;
    }

    public static int backrelateNameToMacroCallArgument(IASTName name, IASTMacroExpansion me) {
        int expansionCount = 0;
        IASTMacroExpansion mloc = me;
        IASTNodeLocation[] locs = null;
        boolean done = false;
        while (!done) {
            IASTPreprocessorMacroDefinition mdef = mloc.getMacroDefinition();
            if (!(mdef instanceof IASTPreprocessorFunctionStyleMacroDefinition)) {
                return -1;
            }
            ++expansionCount;
            locs = mloc.getExpansionLocations();
            if (locs == null || locs.length != 1) {
                return -1;
            }
            IASTNodeLocation aloc = locs[0];
            if (aloc instanceof IASTFileLocation) {
                done = true;
                continue;
            }
            if (!(aloc instanceof IASTMacroExpansion)) continue;
            mloc = (IASTMacroExpansion)aloc;
        }
        IASTMacroExpansion[] macroExpansions = new IASTMacroExpansion[expansionCount];
        macroExpansions[expansionCount - 1] = me;
        int i = expansionCount - 2;
        while (i >= 0) {
            macroExpansions[i] = (IASTMacroExpansion)macroExpansions[i + 1].getExpansionLocations()[0];
            --i;
        }
        String orig = name.getTranslationUnit().getUnpreprocessedSignature(locs);
        Pattern p = Pattern.compile("\\b" + name.toString() + "\\b");
        Matcher m = p.matcher(orig);
        if (!m.find()) {
            return -1;
        }
        int start = m.start();
        if (m.find(m.end())) {
            return -1;
        }
        return locs[0].getNodeOffset() + start;
    }

    private static IScope getContainingScope(IASTName name) {
        IASTTranslationUnit tu = name.getTranslationUnit();
        if (tu == null) {
            return null;
        }
        if (tu instanceof ICPPASTTranslationUnit) {
            return CPPVisitor.getContainingScope((IASTName)name);
        }
        return CVisitor.getContainingScope((IASTNode)name);
    }

    public static int isVirtualMethod(ICPPMethod method) throws DOMException {
        ICPPASTDeclSpecifier cppSpec;
        IASTDeclaration decl = null;
        if (method instanceof CPPMethod) {
            decl = ((CPPMethod)method).getPrimaryDeclaration();
        } else if (decl instanceof CPPImplicitMethod) {
            decl = ((CPPImplicitMethod)method).getPrimaryDeclaration();
        }
        IASTDeclSpecifier spec = null;
        if (decl instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition def = (IASTFunctionDefinition)decl;
            spec = def.getDeclSpecifier();
        } else if (decl instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration sdecl = (IASTSimpleDeclaration)decl;
            spec = sdecl.getDeclSpecifier();
        }
        if (spec instanceof ICPPASTDeclSpecifier && (cppSpec = (ICPPASTDeclSpecifier)spec).isVirtual()) {
            return 1;
        }
        IScope scope = method.getScope();
        if (scope instanceof ICPPClassScope) {
            ICPPClassScope classScope = (ICPPClassScope)scope;
            ICPPClassType classType = classScope.getClassType();
            ICPPBase[] bases = classType.getBases();
            int i = 0;
            while (i < bases.length) {
                IScope baseScope;
                ICPPClassType baseType;
                ICPPBase base = bases[i];
                if (base.getBaseClass() instanceof ICPPClassType && (baseType = (ICPPClassType)base.getBaseClass()) != null && (baseScope = baseType.getCompositeScope()) != null) {
                    IBinding[] alternates = baseScope.find(method.getName());
                    int j = 0;
                    while (j < alternates.length) {
                        CPPMethod alternateMethod;
                        IBinding binding = alternates[j];
                        if (binding instanceof CPPMethod && ASTManager.hasSameSignature((IFunction)method, (IFunction)(alternateMethod = (CPPMethod)binding)) != 0 && ASTManager.isVirtualMethod((ICPPMethod)alternateMethod) == 1) {
                            return 1;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isLocalVariable(IVariable v, IScope scope) {
        if (!(v instanceof IParameter)) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            if (scope instanceof ICPPFunctionScope || scope instanceof ICPPBlockScope || scope instanceof ICFunctionScope) {
                return true;
            }
            try {
                scope = scope.getParent();
                continue;
            }
            catch (DOMException v0) {
                scope = null;
            }
lbl10:
            // 3 sources

            ** while (scope != null)
        }
lbl11:
        // 1 sources

        return false;
    }

    public static boolean isLocalVariable(IVariable v) {
        try {
            return ASTManager.isLocalVariable(v, v.getScope());
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    public static IBinding[] findInScope(IScope scope, String name, boolean removeGlobalsWhenClassScope) throws DOMException {
        IBinding[] result = null;
        result = scope.find(name);
        if (result == null || result.length == 0) {
            return result;
        }
        if (removeGlobalsWhenClassScope && (scope instanceof ICPPClassScope || scope instanceof ICCompositeTypeScope)) {
            int count = 0;
            int i = 0;
            while (i < result.length) {
                IBinding binding = result[i];
                IScope bscope = binding.getScope();
                if (!(bscope instanceof ICPPClassScope) && !(bscope instanceof ICCompositeTypeScope)) {
                    result[i] = null;
                } else {
                    ++count;
                }
                ++i;
            }
            if (count < result.length) {
                IBinding[] copy = new IBinding[count];
                int i2 = 0;
                int j = 0;
                while (j < result.length) {
                    IBinding b = result[j];
                    if (b != null) {
                        copy[i2++] = b;
                    }
                    ++j;
                }
                result = copy;
            }
        }
        if (scope instanceof ICPPBlockScope) {
            int i = 0;
            while (i < result.length) {
                ICPPConstructor[] cons;
                ICPPClassType classType;
                IBinding binding = result[i];
                if (binding instanceof ICPPClassType && (classType = (ICPPClassType)binding).getKey() == 3 && (cons = classType.getConstructors()).length > 0 && !(cons[0] instanceof IProblemBinding)) {
                    result[i] = cons[0];
                }
                ++i;
            }
        }
        return result;
    }

    public ASTManager(CRefactory refactoringManager, CRefactoringArgument arg) {
        this.fRefactory = refactoringManager;
        this.fArgument = arg;
    }

    void analyzeArgument(IProgressMonitor pm, RefactoringStatus status) {
        IASTName node;
        if (this.fArgument == null) {
            return;
        }
        if (this.fArgument.getArgumentKind() != 0) {
            return;
        }
        if (this.fArgument.getSourceFile() == null) {
            return;
        }
        SavedCodeReaderFactory.getInstance().getCodeReaderCache().flush();
        pm.beginTask(Messages.getString("ASTManager.task.analyze"), 2);
        IASTTranslationUnit tu = this.getTranslationUnit(this.fArgument.getSourceFile(), true, status);
        pm.worked(1);
        if (tu != null && (node = this.findNameAtLocation(tu, tu.getFilePath(), this.fArgument.getOffset())) instanceof IASTName) {
            IASTName name = node;
            this.fArgument.setName(name);
            IBinding binding = name.resolveBinding();
            if (binding != null) {
                IScope scope = null;
                try {
                    scope = binding.getScope();
                }
                catch (DOMException e) {
                    this.handleDOMException(tu, e, status);
                }
                this.fArgument.setBinding(name.getTranslationUnit(), binding, scope);
            }
        }
        pm.worked(1);
        pm.done();
    }

    private IASTName findNameAtLocation(IASTTranslationUnit tu, String fileName, int offset) {
        final IASTName[] result = new IASTName[1];
        ASTNameVisitor nv = new ASTNameVisitor(fileName, offset){

            protected int visitName(IASTName name) {
                result[0] = name;
                return 2;
            }
        };
        tu.accept((ASTVisitor)nv);
        if (result[0] == null) {
            IASTPreprocessorMacroDefinition[] m = tu.getMacroDefinitions();
            int i = 0;
            while (i < m.length && result[0] == null) {
                IASTPreprocessorMacroDefinition mdef = m[i];
                IASTName name = mdef.getName();
                nv.visit(name);
                if (result[0] == null) {
                    IASTName[] refs = tu.getReferences(name.resolveBinding());
                    int j = 0;
                    while (j < refs.length && result[0] == null) {
                        nv.visit(refs[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return result[0];
    }

    private IASTTranslationUnit getTranslationUnit(IFile sourceFile, boolean cacheit, RefactoringStatus status) {
        IASTTranslationUnit tu = (IASTTranslationUnit)this.fTranslationUnits.get(sourceFile);
        if (tu == null && (tu = this.fRefactory.getTranslationUnit(sourceFile, status)) != null && cacheit) {
            this.fTranslationUnits.put(sourceFile, tu);
        }
        return tu;
    }

    public void analyzeTextMatches(ArrayList matches, IProgressMonitor monitor, RefactoringStatus status) {
        long now;
        CRefactoringMatchStore store = new CRefactoringMatchStore();
        Iterator iter = matches.iterator();
        while (iter.hasNext()) {
            CRefactoringMatch match = (CRefactoringMatch)iter.next();
            store.addMatch(match);
        }
        int count = store.getFileCount();
        String taskName = Messages.getString("ASTManager.task.generateAst");
        monitor.beginTask(taskName, 2 * count);
        monitor.setTaskName(taskName);
        List files = store.getFileList();
        int cc = 0;
        long update = now = System.currentTimeMillis();
        Iterator iter2 = files.iterator();
        while (iter2.hasNext()) {
            ++cc;
            IFile file = (IFile)iter2.next();
            if (store.contains(file)) {
                now = System.currentTimeMillis();
                if (now > update) {
                    String nofm = ASTManager.nth_of_m(cc, count);
                    String taskname = MessageFormat.format(Messages.getString("ASTManager.subtask.analyzing"), nofm);
                    monitor.subTask(taskname);
                    update = now + 1000L;
                }
                boolean doParse = false;
                Collection fm = store.getMatchesForFile(file);
                Iterator iterator = fm.iterator();
                while (!doParse && iterator.hasNext()) {
                    CRefactoringMatch match = (CRefactoringMatch)iterator.next();
                    switch (match.getLocation()) {
                        case 2: 
                        case 4: 
                        case 8: {
                            break;
                        }
                        default: {
                            doParse = true;
                        }
                    }
                }
                if (doParse) {
                    IASTTranslationUnit tu = this.getTranslationUnit(file, false, status);
                    monitor.worked(1);
                    this.analyzeTextMatchesOfTranslationUnit(tu, store, status);
                    if (status.hasFatalError()) {
                        return;
                    }
                    monitor.worked(1);
                } else {
                    monitor.worked(2);
                }
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            monitor.worked(2);
        }
        monitor.done();
    }

    private void analyzeTextMatchesOfTranslationUnit(IASTTranslationUnit tu, CRefactoringMatchStore store, RefactoringStatus status) {
        this.fKnownBindings = new HashMap();
        this.fConflictingBinding = new HashSet();
        HashSet paths = new HashSet();
        boolean renamesMacro = this.fArgument.getArgumentKind() == 11;
        this.analyzeMacroMatches(tu, store, paths, status);
        if (status.hasFatalError()) {
            return;
        }
        if (renamesMacro) {
            this.findConflictingBindingsWithNewName(tu, store, paths, status);
            if (status.hasFatalError()) {
                return;
            }
        }
        this.analyzeLanguageMatches(tu, store, paths, status);
        if (status.hasFatalError()) {
            return;
        }
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            IPath path = (IPath)iter.next();
            if (path == null) continue;
            store.removePath(path);
        }
        this.handleConflictingBindings(tu, status);
        this.fKnownBindings = null;
        this.fConflictingBinding = null;
    }

    private void analyzeLanguageMatches(IASTTranslationUnit tu, final CRefactoringMatchStore store, final Set paths, final RefactoringStatus status) {
        ASTSpecificNameVisitor nv = new ASTSpecificNameVisitor(this.fArgument.getName()){

            protected int visitName(IASTName name, boolean isDestructor) {
                IPath path = ASTManager.this.analyzeAstMatch(name, store, isDestructor, status);
                paths.add(path);
                return 3;
            }
        };
        tu.accept((ASTVisitor)nv);
    }

    private void analyzeMacroMatches(IASTTranslationUnit tu, CRefactoringMatchStore store, Set pathsVisited, RefactoringStatus status) {
        String lookfor = this.fArgument.getName();
        IASTPreprocessorMacroDefinition[] mdefs = tu.getMacroDefinitions();
        int i = 0;
        while (i < mdefs.length) {
            int j;
            IASTPreprocessorMacroDefinition mdef = mdefs[i];
            IASTName macroName = mdef.getName();
            String macroNameStr = macroName.toString();
            if (this.fRenameTo.equals(macroNameStr)) {
                status.addFatalError(MessageFormat.format(Messages.getString("ASTManager.error.macro.name.conflict"), this.fRenameTo));
                return;
            }
            if (lookfor.equals(macroNameStr)) {
                IPath path = this.analyzeAstMatch(macroName, store, false, status);
                pathsVisited.add(path);
                IBinding macroBinding = macroName.resolveBinding();
                if (macroBinding != null) {
                    IASTName[] refs = tu.getReferences(macroBinding);
                    j = 0;
                    while (j < refs.length) {
                        path = this.analyzeAstMatch(refs[j], store, false, status);
                        pathsVisited.add(path);
                        ++j;
                    }
                }
            }
            if (mdef instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
                boolean nameIsPar = false;
                IASTPreprocessorFunctionStyleMacroDefinition fm = (IASTPreprocessorFunctionStyleMacroDefinition)mdef;
                IASTFunctionStyleMacroParameter[] pars = fm.getParameters();
                if (pars != null) {
                    j = 0;
                    while (!nameIsPar && j < pars.length) {
                        IASTFunctionStyleMacroParameter par = pars[j];
                        String name = par.getParameter();
                        if (lookfor.equals(name)) {
                            nameIsPar = true;
                        }
                        ++j;
                    }
                    if (nameIsPar) {
                        IASTFileLocation floc = mdef.getNodeLocations()[0].asFileLocation();
                        int offset = floc.getNodeOffset();
                        int end = offset + floc.getNodeLength();
                        Collection matches = store.findMatchesInRange(new Path(floc.getFileName()), offset, end);
                        Iterator iter = matches.iterator();
                        while (iter.hasNext()) {
                            CRefactoringMatch match = (CRefactoringMatch)iter.next();
                            match.setASTInformation(3);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void findConflictingBindingsWithNewName(IASTTranslationUnit tu, CRefactoringMatchStore store, final Set paths, final RefactoringStatus status) {
        ASTSpecificNameVisitor nv = new ASTSpecificNameVisitor(this.fRenameTo){

            protected int visitName(IASTName name, boolean isDestructor) {
                IPath path = ASTManager.this.addConflictingBindingForName(status, name);
                paths.add(path);
                return 3;
            }
        };
        tu.accept((ASTVisitor)nv);
    }

    protected IPath addConflictingBindingForName(RefactoringStatus status, IASTName name) {
        IASTNodeLocation loc;
        IASTFileLocation floc;
        IASTNodeLocation[] locations = name.getNodeLocations();
        Path path = null;
        if (locations != null && locations.length == 1 && (floc = (loc = locations[0]).asFileLocation()) != null && (path = new Path(floc.getFileName())) != null) {
            IBinding binding = name.resolveBinding();
            if (binding instanceof IProblemBinding) {
                this.handleProblemBinding(name.getTranslationUnit(), (IProblemBinding)binding, status);
            } else if (binding != null) {
                this.fConflictingBinding.add(binding);
            }
        }
        return path;
    }

    protected IPath analyzeAstMatch(IASTName name, CRefactoringMatchStore store, boolean isDestructor, RefactoringStatus status) {
        IASTNodeLocation loc;
        IASTFileLocation floc;
        Path path = null;
        CRefactoringMatch match = null;
        IASTNodeLocation[] locations = name.getNodeLocations();
        if (locations != null && locations.length == 1 && (floc = (loc = locations[0]).asFileLocation()) != null) {
            path = new Path(floc.getFileName());
            if (loc instanceof IASTMacroExpansion) {
                IASTMacroExpansion me = (IASTMacroExpansion)loc;
                int offset = ASTManager.backrelateNameToMacroCallArgument(name, me);
                match = store.findMatch((IPath)path, offset + (isDestructor ? 1 : 0));
            } else {
                match = store.findMatch((IPath)path, floc.getNodeOffset() + (isDestructor ? 1 : 0));
            }
        }
        if (match != null) {
            this.analyzeAstTextMatchPair(match, name, status);
        }
        return path;
    }

    private void analyzeAstTextMatchPair(CRefactoringMatch match, IASTName name, RefactoringStatus status) {
        IBinding binding = name.resolveBinding();
        int cmp = 0;
        Integer cmpObj = (Integer)this.fKnownBindings.get(binding);
        if (cmpObj != null) {
            cmp = cmpObj;
        } else if (binding instanceof IProblemBinding) {
            cmp = -1;
            this.handleProblemBinding(name.getTranslationUnit(), (IProblemBinding)binding, status);
        } else {
            int i = 0;
            while (i < this.fValidBindings.length) {
                IBinding renameBinding = this.fValidBindings[i];
                try {
                    int cmp0 = ASTManager.isSameBinding(binding, renameBinding);
                    if (cmp0 != 0) {
                        cmp = cmp0;
                    }
                    if (cmp0 == 1) {
                        break;
                    }
                }
                catch (DOMException e) {
                    this.handleDOMException(name.getTranslationUnit(), e, status);
                    cmp = -1;
                }
                ++i;
            }
            this.fKnownBindings.put(binding, new Integer(cmp));
        }
        switch (cmp) {
            case 1: {
                IScope scope;
                match.setASTInformation(1);
                if (this.fRenameTo == null || (scope = ASTManager.getContainingScope(name)) == null) break;
                IBinding[] conflicting = null;
                try {
                    conflicting = ASTManager.findInScope(scope, this.fRenameTo, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (conflicting == null || conflicting.length <= 0) break;
                this.fConflictingBinding.addAll(Arrays.asList(conflicting));
                break;
            }
            case 0: {
                match.setASTInformation(3);
            }
        }
    }

    public void handleDOMException(IASTTranslationUnit tu, DOMException e, RefactoringStatus status) {
        this.handleProblemBinding(tu, e.getProblem(), status);
    }

    public void handleProblemBinding(IASTTranslationUnit tu, IProblemBinding pb, RefactoringStatus status) {
        String fpath;
        if (tu != null && this.fProblemUnits.add(fpath = tu.getFilePath())) {
            String msg = pb.getMessage();
            msg = msg != null && msg.length() > 0 ? MessageFormat.format(Messages.getString("ASTManager.warning.parsingError.detailed"), msg) : Messages.getString("ASTManager.warning.parsingError");
            int line = pb.getLineNumber();
            msg = line >= 1 ? MessageFormat.format(Messages.getString("ASTManager.warning.parsingError.withFileAndLine"), msg, fpath, new Integer(line)) : MessageFormat.format(Messages.getString("ASTManager.warning.parsingError.withFile"), msg, fpath);
            status.addWarning(msg);
        }
    }

    protected void handleConflictingBindings(IASTTranslationUnit tu, RefactoringStatus status) {
        if (this.fConflictingBinding.isEmpty()) {
            return;
        }
        int argKind = this.fArgument.getArgumentKind();
        boolean isVarParEnumerator = false;
        boolean isLocalVarPar = false;
        boolean isFunction = false;
        boolean isContainer = false;
        boolean isMacro = false;
        switch (argKind) {
            case 1: 
            case 2: {
                isLocalVarPar = true;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: {
                isVarParEnumerator = true;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                isFunction = true;
                break;
            }
            case 10: 
            case 14: 
            case 15: {
                isContainer = true;
                break;
            }
            case 11: {
                isMacro = true;
                break;
            }
        }
        Collection[] cflc = new Collection[]{new HashSet(), new ArrayList(), new ArrayList()};
        String[] errs = null;
        if (isMacro) {
            errs = new String[]{Messages.getString("CRenameLocalProcessor.error.conflict")};
            cflc[0] = this.fConflictingBinding;
        } else {
            errs = new String[]{Messages.getString("CRenameLocalProcessor.error.shadow"), Messages.getString("CRenameLocalProcessor.error.redeclare"), Messages.getString("CRenameLocalProcessor.error.isShadowed"), Messages.getString("CRenameLocalProcessor.error.overloads")};
            this.classifyConflictingBindings(tu, (Set)cflc[0], cflc[1], cflc[2], status);
        }
        int i = 0;
        while (i < 3) {
            Collection coll = cflc[i];
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                boolean warn = false;
                String msg = errs[i];
                IBinding conflict = (IBinding)iter.next();
                String what = null;
                if (conflict instanceof IEnumerator) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        what = Messages.getString("CRenameLocalProcessor.enumerator");
                    }
                } else if (conflict instanceof ICPPField) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        what = Messages.getString("CRenameLocalProcessor.field");
                    }
                } else if (conflict instanceof IParameter) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        if (i == 1 && argKind == 1) {
                            msg = errs[0];
                        }
                        what = Messages.getString("CRenameLocalProcessor.parameter");
                    }
                } else if (conflict instanceof IVariable) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        IVariable conflictingVar = (IVariable)conflict;
                        what = Messages.getString("CRenameLocalProcessor.globalVariable");
                        if (ASTManager.isLocalVariable(conflictingVar)) {
                            if (i == 1 && argKind == 2) {
                                msg = errs[2];
                            }
                            what = Messages.getString("CRenameLocalProcessor.localVariable");
                        } else {
                            try {
                                if (conflictingVar.isStatic()) {
                                    what = Messages.getString("CRenameProcessorDelegate.fileStaticVariable");
                                }
                            }
                            catch (DOMException dOMException) {}
                        }
                    }
                } else if (conflict instanceof ICPPConstructor) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        what = Messages.getString("CRenameLocalProcessor.constructor");
                    }
                } else if (conflict instanceof ICPPMethod) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        IBinding r;
                        if (i == 1 && (r = this.fArgument.getBinding()) instanceof ICPPMethod) {
                            try {
                                if (ASTManager.hasSameSignature((IFunction)((ICPPMethod)r), (IFunction)((ICPPMethod)conflict)) == 0) {
                                    msg = errs[3];
                                    warn = true;
                                }
                            }
                            catch (DOMException dOMException) {}
                        }
                        what = Messages.getString("CRenameLocalProcessor.method");
                    }
                } else if (conflict instanceof IFunction) {
                    if (isVarParEnumerator || isFunction || isMacro) {
                        IASTName[] refs;
                        boolean ignore = false;
                        if (isLocalVarPar && ((refs = this.fArgument.getTranslationUnit().getReferences(conflict)) == null || refs.length == 0)) {
                            ignore = true;
                        }
                        if (!ignore) {
                            IBinding r;
                            IFunction conflictingFunction = (IFunction)conflict;
                            if (i == 1 && conflict instanceof ICPPFunction && (r = this.fArgument.getBinding()) instanceof ICPPFunction) {
                                try {
                                    if (ASTManager.hasSameSignature((IFunction)((ICPPFunction)r), conflictingFunction) == 0) {
                                        msg = errs[3];
                                        warn = true;
                                    }
                                }
                                catch (DOMException dOMException) {}
                            }
                            boolean isStatic = false;
                            try {
                                isStatic = conflictingFunction.isStatic();
                            }
                            catch (DOMException dOMException) {}
                            what = isStatic ? Messages.getString("CRenameProcessorDelegate.fileStaticFunction") : Messages.getString("CRenameProcessorDelegate.globalFunction");
                        }
                    }
                } else if (conflict instanceof ICompositeType || conflict instanceof IEnumeration || conflict instanceof ITypedef) {
                    if (isContainer || isMacro) {
                        what = Messages.getString("CRenameProcessorDelegate.type");
                    }
                } else if (conflict instanceof ICPPNamespace && (isContainer || isMacro)) {
                    what = Messages.getString("CRenameProcessorDelegate.namespace");
                    if (argKind == 15) {
                        warn = true;
                    }
                }
                if (what == null) continue;
                String formatted = MessageFormat.format(Messages.getString("CRenameLocalProcessor.error.nameErrorWhat"), conflict.getName(), msg, what);
                RefactoringStatusEntry[] entries = status.getEntries();
                int j = 0;
                while (formatted != null && j < entries.length) {
                    RefactoringStatusEntry entry = entries[j];
                    if (formatted.equals(entry.getMessage())) {
                        formatted = null;
                    }
                    ++j;
                }
                if (formatted == null) continue;
                if (warn) {
                    status.addWarning(formatted);
                    continue;
                }
                status.addError(formatted);
            }
            ++i;
        }
    }

    protected void classifyConflictingBindings(IASTTranslationUnit tu, Set shadows, Collection redecl, Collection barriers, RefactoringStatus status) {
        String name = this.fArgument.getName();
        IBinding[] newBindingsAboverOrEqual = null;
        IScope oldBindingsScope = null;
        Iterator iter = this.fKnownBindings.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IBinding oldBinding = (IBinding)entry.getKey();
            Integer value = (Integer)entry.getValue();
            if (value == 1 && oldBinding.getName().equals(name)) {
                try {
                    oldBindingsScope = oldBinding.getScope();
                    if (oldBindingsScope != null) {
                        newBindingsAboverOrEqual = ASTManager.findInScope(oldBindingsScope, this.fRenameTo, false);
                    }
                }
                catch (DOMException e) {
                    this.handleDOMException(tu, e, status);
                }
            }
            if (newBindingsAboverOrEqual != null && newBindingsAboverOrEqual.length > 0) break;
        }
        if (newBindingsAboverOrEqual == null) {
            newBindingsAboverOrEqual = new IBinding[]{};
        }
        iter = this.fConflictingBinding.iterator();
        while (iter.hasNext()) {
            IBinding conflictingBinding = (IBinding)iter.next();
            if (conflictingBinding == null) continue;
            boolean isAboveOrEqual = false;
            int i = 0;
            while (!isAboveOrEqual && i < newBindingsAboverOrEqual.length) {
                IBinding aboveBinding = newBindingsAboverOrEqual[i];
                try {
                    if (ASTManager.isSameBinding(aboveBinding, conflictingBinding) == 1) {
                        isAboveOrEqual = true;
                    }
                }
                catch (DOMException e) {
                    this.handleDOMException(tu, e, status);
                }
                ++i;
            }
            if (isAboveOrEqual) continue;
            barriers.add(conflictingBinding);
        }
        int i = 0;
        while (i < newBindingsAboverOrEqual.length) {
            IBinding aboveBinding = newBindingsAboverOrEqual[i];
            try {
                IScope aboveScope = aboveBinding.getScope();
                if (ASTManager.isSameScope(aboveScope, oldBindingsScope, false) == 1) {
                    redecl.add(aboveBinding);
                } else {
                    shadows.add(aboveBinding);
                }
            }
            catch (DOMException e) {
                this.handleDOMException(tu, e, status);
            }
            ++i;
        }
    }

    public void setValidBindings(IBinding[] validBindings) {
        this.fValidBindings = validBindings;
    }

    public void setRenameTo(String renameTo) {
        this.fRenameTo = renameTo;
    }
}

