/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.refactoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.refactoring.Messages;
import org.eclipse.cdt.internal.refactoring.scanner.Scanner;
import org.eclipse.cdt.internal.refactoring.scanner.Token;
import org.eclipse.cdt.refactoring.CRefactoringMatch;
import org.eclipse.cdt.refactoring.ICRefactoringSearch;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class TextSearchWrapper
implements ICRefactoringSearch {
    static final Comparator COMPARE_FIRST_INTEGER = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((int[])o1)[0] - ((int[])o2)[0];
        }
    };

    private TextSearchScope createSearchScope(IFile file, int scope, String workingSetName, String[] patterns) {
        switch (scope) {
            case 2: {
                return this.defineSearchScope((IResource)file.getWorkspace().getRoot(), patterns);
            }
            case 4: {
                return this.defineSearchScope((IResource)file.getProject(), patterns);
            }
            case 1: {
                return this.defineSearchScope((IResource)file, patterns);
            }
            case 5: {
                TextSearchScope result = this.defineWorkingSetAsSearchScope(workingSetName, patterns);
                if (result == null) {
                    result = this.defineSearchScope((IResource)file.getWorkspace().getRoot(), patterns);
                }
                return result;
            }
        }
        return this.defineRelatedProjectsAsSearchScope(file.getProject(), patterns);
    }

    private TextSearchScope defineRelatedProjectsAsSearchScope(IProject project, String[] patterns) {
        HashSet<IProject> projects = new HashSet<IProject>();
        LinkedList<IProject> workThrough = new LinkedList<IProject>();
        workThrough.add(project);
        while (!workThrough.isEmpty()) {
            IProject prj = (IProject)workThrough.removeLast();
            if (!projects.add(prj)) continue;
            try {
                workThrough.addAll(Arrays.asList(prj.getReferencedProjects()));
                workThrough.addAll(Arrays.asList(prj.getReferencingProjects()));
            }
            catch (CoreException coreException) {}
        }
        IResource[] resources = projects.toArray(new IResource[projects.size()]);
        return this.defineSearchScope(resources, patterns);
    }

    private TextSearchScope defineWorkingSetAsSearchScope(String wsName, String[] patterns) {
        if (wsName == null) {
            return null;
        }
        IWorkingSetManager wsManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet ws = wsManager.getWorkingSet(wsName);
        if (ws == null) {
            return null;
        }
        SearchScope result = SearchScope.newSearchScope(ws);
        this.applyFilePatterns(result, patterns);
        return result;
    }

    private void applyFilePatterns(SearchScope scope, String[] patterns) {
        int i = 0;
        while (i < patterns.length) {
            String pattern = patterns[i];
            scope.addFileNamePattern(pattern);
            ++i;
        }
    }

    private TextSearchScope defineSearchScope(IResource resource, String[] patterns) {
        SearchScope result = SearchScope.newSearchScope(new IResource[]{resource}, false);
        this.applyFilePatterns(result, patterns);
        return result;
    }

    private TextSearchScope defineSearchScope(IResource[] resources, String[] patterns) {
        SearchScope result = SearchScope.newSearchScope(resources, true);
        this.applyFilePatterns(result, patterns);
        return result;
    }

    public IStatus searchWord(int scope, IFile resource, String workingSet, String[] patterns, String word, IProgressMonitor monitor, final List target) {
        int startPos = target.size();
        TextSearchEngine engine = TextSearchEngine.create();
        StringBuffer searchPattern = new StringBuffer(word.length() + 8);
        searchPattern.append("\\b");
        searchPattern.append("\\Q");
        searchPattern.append(word);
        searchPattern.append("\\E");
        searchPattern.append("\\b");
        Pattern pattern = Pattern.compile(searchPattern.toString());
        TextSearchScope searchscope = this.createSearchScope(resource, scope, workingSet, patterns);
        TextSearchRequestor requestor = new TextSearchRequestor(){

            public boolean acceptPatternMatch(TextSearchMatchAccess access) {
                IFile file = access.getFile();
                ICElement elem = CoreModel.getDefault().create(file);
                if (elem instanceof ITranslationUnit) {
                    target.add(new CRefactoringMatch(file, access.getMatchOffset(), access.getMatchLength(), 0));
                }
                return true;
            }
        };
        IStatus result = engine.search(searchscope, requestor, pattern, (IProgressMonitor)new SubProgressMonitor(monitor, 95));
        this.categorizeMatches(target.subList(startPos, target.size()), (IProgressMonitor)new SubProgressMonitor(monitor, 5));
        return result;
    }

    public void categorizeMatches(List matches, IProgressMonitor monitor) {
        monitor.beginTask(Messages.getString("TextSearch.monitor.categorizeMatches"), matches.size());
        IFile file = null;
        ArrayList locations = null;
        Iterator iter = matches.iterator();
        while (iter.hasNext()) {
            CRefactoringMatch match = (CRefactoringMatch)iter.next();
            IFile tfile = match.getFile();
            if (file == null || !file.equals((Object)tfile)) {
                file = tfile;
                locations = new ArrayList();
                this.computeLocations(file, locations);
            }
            match.setLocation(this.findLocation(match, locations));
            monitor.worked(1);
        }
    }

    private int findLocation(CRefactoringMatch match, ArrayList states) {
        int pos = Collections.binarySearch(states, new int[]{match.getOffset()}, COMPARE_FIRST_INTEGER);
        if (pos < 0 && (pos = -pos - 2) < 0) {
            pos = 0;
        }
        int endOffset = match.getOffset() + match.getLength();
        int location = 0;
        while (pos < states.size()) {
            int[] info = (int[])states.get(pos);
            if (info[0] >= endOffset) break;
            location |= info[1];
            ++pos;
        }
        return location;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void computeLocations(IFile file, ArrayList locations) {
        BufferedReader reader;
        Scanner scanner = new Scanner();
        try {
            reader = new BufferedReader(new InputStreamReader(file.getContents(), file.getCharset()));
        }
        catch (CoreException coreException) {
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
        try {
            Token token;
            scanner.initialize(reader, null);
            scanner.setReuseToken(true);
            int lastState = 0;
            while ((token = scanner.nextToken()) != null) {
                int state = 128;
                switch (token.getType()) {
                    case 1001: 
                    case 1002: {
                        state = 2;
                        break;
                    }
                    case 129: 
                    case 131: 
                    case 132: {
                        state = 4;
                        break;
                    }
                    case 1003: {
                        state = 32;
                        break;
                    }
                    case 1005: {
                        state = 16;
                        break;
                    }
                    case 1004: {
                        state = 8;
                        break;
                    }
                }
                if (state == lastState) continue;
                locations.add(new int[]{token.getOffset(), state});
                lastState = state;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                ((Reader)reader).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        ((Reader)reader).close();
    }

    private static class SearchScope
    extends TextSearchScope {
        private IResource[] fRootResources;
        private ArrayList fFileMatcher = new ArrayList();
        static /* synthetic */ Class class$0;

        public static SearchScope newSearchScope(IWorkingSet ws) {
            IAdaptable[] adaptables = ws.getElements();
            ArrayList<IResource> resources = new ArrayList<IResource>();
            int i = 0;
            while (i < adaptables.length) {
                IResource r;
                IAdaptable adaptable = adaptables[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((r = (IResource)adaptable.getAdapter((Class)clazz)) != null) {
                    resources.add(r);
                }
                ++i;
            }
            return SearchScope.newSearchScope(resources.toArray(new IResource[resources.size()]), false);
        }

        public static SearchScope newSearchScope(IResource[] resources, boolean copy) {
            return new SearchScope(resources, copy);
        }

        SearchScope(IResource[] resources, boolean copy) {
            this.fRootResources = copy ? (IResource[])resources.clone() : resources;
        }

        public IResource[] getRoots() {
            return this.fRootResources;
        }

        public boolean contains(IResourceProxy proxy) {
            if (proxy.isDerived()) {
                return false;
            }
            if (proxy.getType() == 1) {
                return this.containsFile(proxy.getName());
            }
            return true;
        }

        private boolean containsFile(String name) {
            Iterator iter = this.fFileMatcher.iterator();
            while (iter.hasNext()) {
                Matcher matcher = (Matcher)iter.next();
                matcher.reset(name);
                if (!matcher.matches()) continue;
                return true;
            }
            return false;
        }

        public void addFileNamePattern(String filePattern) {
            Pattern p = Pattern.compile(this.filePatternToRegex(filePattern));
            this.fFileMatcher.add(p.matcher(""));
        }

        private String filePatternToRegex(String filePattern) {
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < filePattern.length()) {
                char c = filePattern.charAt(i);
                switch (c) {
                    case '$': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        result.append('\\');
                        result.append(c);
                        break;
                    }
                    case '?': {
                        result.append('.');
                        break;
                    }
                    case '*': {
                        result.append(".*");
                        break;
                    }
                    default: {
                        result.append(c);
                    }
                }
                ++i;
            }
            return result.toString();
        }
    }
}

