/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.refactoring.actions;

import org.eclipse.cdt.refactoring.IPositionConsumer;
import org.eclipse.cdt.refactoring.actions.CRenameAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;

public class CRefactoringActionGroup
extends ActionGroup
implements IPositionConsumer {
    public static final String MENU_ID = "org.eclipse.cdt.ui.refactoring.menu";
    public static final String GROUP_REORG = "reorgGroup";
    public static final String GROUP_TYPE = "typeGroup";
    public static final String GROUP_CODING = "codingGroup";
    private static final String GROUP_UNDO = "undoRedoGroup";
    private String fGroupName = "group.reorganize";
    private CRenameAction fRenameAction;

    public CRefactoringActionGroup(IWorkbenchWindow ww, String groupName) {
        if (groupName != null && groupName.length() > 0) {
            this.fGroupName = groupName;
        }
        this.fRenameAction = new CRenameAction();
    }

    public void init(IWorkbenchPartSite site) {
        this.fRenameAction.setWorkbenchPart(site.getPart());
    }

    public void setEditor(ITextEditor textEditor) {
        this.fRenameAction.setEditor((IEditorPart)textEditor);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        MenuManager refactorSubmenu = new MenuManager("Refactor", MENU_ID);
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_REORG));
        refactorSubmenu.add((IAction)this.fRenameAction);
        refactorSubmenu.add((IContributionItem)new Separator(GROUP_UNDO));
        menu.appendToGroup(this.fGroupName, (IContributionItem)refactorSubmenu);
    }

    public void updateActionBars() {
    }

    public void setPosition(IFile file, int startPos, String text) {
        this.fRenameAction.setPosition(file, startPos, text);
    }
}

