/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.refactoring.actions;

import org.eclipse.cdt.internal.refactoring.Messages;
import org.eclipse.cdt.refactoring.CRefactory;
import org.eclipse.cdt.refactoring.ICRefactoringArgument;
import org.eclipse.cdt.refactoring.IPositionConsumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class CRenameAction
extends Action
implements IPositionConsumer {
    private ITextEditor fEditor;
    private IFile fFile;
    private IWorkbenchPart fWorkbenchPart;
    private int fOffset;
    private String fText;

    public CRenameAction() {
        super(Messages.getString("CRenameRefactoringAction.label"));
        this.setActionDefinitionId("org.eclipse.cdt.ui.edit.text.c.rename.element");
    }

    public void setEditor(IEditorPart editor) {
        this.fEditor = null;
        this.fWorkbenchPart = null;
        if (editor instanceof ITextEditor) {
            this.fEditor = (ITextEditor)editor;
        }
        this.setEnabled(this.fEditor != null);
    }

    public void setWorkbenchPart(IWorkbenchPart part) {
        this.fEditor = null;
        this.fWorkbenchPart = part;
    }

    public void run() {
        ICRefactoringArgument arg;
        if (this.fEditor != null) {
            ICRefactoringArgument arg2;
            ISelection s;
            ISelectionProvider provider = this.fEditor.getSelectionProvider();
            if (provider != null && (s = provider.getSelection()) instanceof ITextSelection && (arg2 = CRefactory.createArgument(this.fEditor, (ITextSelection)s)) != null) {
                CRefactory.getInstance().rename(this.fEditor.getSite().getShell(), arg2);
            }
        } else if (this.fWorkbenchPart != null && (arg = CRefactory.createArgument(this.fFile, this.fOffset, this.fText)) != null) {
            CRefactory.getInstance().rename(this.fWorkbenchPart.getSite().getShell(), arg);
        }
    }

    public void setPosition(IFile file, int startPos, String text) {
        this.fFile = file;
        this.fOffset = startPos;
        this.fText = text;
        if (this.fFile != null && this.fText != null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

