/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.cdt.internal.corext.refactoring.IProcessorBasedRefactoring;
import org.eclipse.cdt.internal.corext.refactoring.IRefactoringProcessor;
import org.eclipse.cdt.internal.corext.refactoring.IRenameProcessor;
import org.eclipse.cdt.internal.corext.refactoring.IRenameRefactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.corext.refactoring.rename.RenameElementProcessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class RenameRefactoring
extends Refactoring
implements IProcessorBasedRefactoring,
IRenameRefactoring {
    private Object fElement;
    private IRenameProcessor fProcessor;

    public RenameRefactoring(Object element) throws CoreException {
        Assert.isNotNull(element);
        this.fElement = element;
        this.fProcessor = new RenameElementProcessor();
        this.fProcessor.initialize(new Object[]{this.fElement});
    }

    public boolean isAvailable() {
        return this.fProcessor != null;
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isInstance(this.fProcessor)) {
            return this.fProcessor;
        }
        return super.getAdapter(clazz);
    }

    public IRefactoringProcessor getProcessor() {
        return this.fProcessor;
    }

    public int getStyle() {
        return this.fProcessor.getStyle();
    }

    public String getNewName() {
        return this.fProcessor.getNewElementName();
    }

    public void setNewName(String newName) {
        this.fProcessor.setNewElementName(newName);
    }

    public String getCurrentName() {
        return this.fProcessor.getCurrentElementName();
    }

    public RefactoringStatus checkNewName(String newName) throws CModelException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            result.merge(this.fProcessor.checkNewElementName(newName));
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
        return result;
    }

    public String getName() {
        return this.fProcessor.getProcessorName();
    }

    public RefactoringStatus checkActivation(IProgressMonitor pm) throws CModelException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            result.merge(this.fProcessor.checkActivation());
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
        return result;
    }

    public RefactoringStatus checkInput(IProgressMonitor pm) throws CModelException {
        RefactoringStatus result = new RefactoringStatus();
        try {
            pm.beginTask("", 2);
            result.merge(this.fProcessor.checkInput((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            if (result.hasFatalError()) {
                return result;
            }
        }
        catch (CModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
        return result;
    }

    public IChange createChange(IProgressMonitor pm) throws CModelException {
        pm.beginTask("", 1);
        CompositeChange result = new CompositeChange();
        try {
            result.add(this.fProcessor.createChange((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        }
        catch (CModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
        return result;
    }

    public String toString() {
        if (this.isAvailable()) {
            return this.getName();
        }
        return "No refactoring available to process: " + this.fElement;
    }
}

