/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TranslationUnitChange;
import org.eclipse.core.runtime.CoreException;

public class TextChangeManager {
    private Map fMap = new HashMap(10);
    private final boolean fKeepExecutedTextEdits;

    public TextChangeManager() {
        this(false);
    }

    public TextChangeManager(boolean keepExecutedTextEdits) {
        this.fKeepExecutedTextEdits = keepExecutedTextEdits;
    }

    public void manage(ITranslationUnit cu, TextChange change) {
        this.fMap.put(cu, change);
    }

    public TextChange get(ITranslationUnit cu) throws CoreException {
        TextChange result = (TextChange)this.fMap.get(cu);
        if (result == null) {
            result = new TranslationUnitChange(cu.getElementName(), cu);
            result.setKeepExecutedTextEdits(this.fKeepExecutedTextEdits);
            this.fMap.put(cu, result);
        }
        return result;
    }

    public TextChange remove(ITranslationUnit unit) {
        return (TextChange)this.fMap.remove(unit);
    }

    public TextChange[] getAllChanges() {
        return this.fMap.values().toArray(new TextChange[this.fMap.values().size()]);
    }

    public ITranslationUnit[] getAllTranslationUnits() {
        return this.fMap.keySet().toArray(new ITranslationUnit[this.fMap.keySet().size()]);
    }

    public void clear() {
        this.fMap.clear();
    }

    public boolean containsChangesIn(ITranslationUnit cu) {
        return this.fMap.containsKey(cu);
    }
}

