/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.base;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class Change
implements IChange {
    private boolean fIsActive = true;
    static /* synthetic */ Class class$0;

    public RefactoringStatus aboutToPerform(ChangeContext context, IProgressMonitor pm) {
        pm.beginTask("", 1);
        RefactoringStatus result = new RefactoringStatus();
        IResource resource = Change.getResource(this.getModifiedLanguageElement());
        if (resource != null) {
            pm.subTask(RefactoringCoreMessages.getFormattedString("Change.checking_for", resource.getName()));
            Change.checkIfModifiable(resource, result, context);
        }
        pm.worked(1);
        return result;
    }

    public void performed() {
    }

    public void setActive(boolean active) {
        this.fIsActive = active;
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    protected void handleException(ChangeContext context, Exception exception) throws ChangeAbortException {
        if (exception instanceof ChangeAbortException) {
            throw (ChangeAbortException)exception;
        }
        if (exception instanceof OperationCanceledException) {
            throw (OperationCanceledException)exception;
        }
        context.getExceptionHandler().handle(context, this, exception);
    }

    protected static void checkIfModifiable(Object element, RefactoringStatus status, ChangeContext context) {
        IResource resource = Change.getResource(element);
        if (resource != null) {
            Change.checkIfModifiable(resource, status, context);
        }
    }

    protected static void checkIfModifiable(IResource resource, RefactoringStatus status, ChangeContext context) {
        if (resource.isReadOnly()) {
            status.addFatalError(RefactoringCoreMessages.getFormattedString("Change.is_read_only", resource.getFullPath().toString()));
        }
        if (resource instanceof IFile) {
            context.checkUnsavedFile(status, (IFile)resource);
        }
    }

    private static IResource getResource(Object element) {
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof ITranslationUnit) {
            return CModelUtil.toOriginal((ITranslationUnit)element).getResource();
        }
        if (element instanceof ICElement) {
            return ((ICElement)element).getUnderlyingResource();
        }
        if (element instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }
}

