/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.text.CHelpBookDescriptor;
import org.eclipse.cdt.internal.ui.text.CHelpSettings;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CHelpProviderManager {
    private static final String C_HELP_SETTINGS_FILE_NAME = "cHelpSettings.xml";
    private static final String ELEMENT_ROOT = "cHelpSettings";
    private static CHelpSettings fDefaultHelpSettings = null;
    private static File fSettingsFile = null;
    private static CHelpProviderManager fInstance = null;
    private static IProject fCurrentProject = null;
    private static CHelpSettings fCurrentSettings = null;

    private CHelpProviderManager() {
    }

    private static File getSettingsFile() {
        if (fSettingsFile == null) {
            fSettingsFile = CUIPlugin.getDefault().getStateLocation().append(C_HELP_SETTINGS_FILE_NAME).toFile();
        }
        return fSettingsFile;
    }

    private static CHelpSettings getDefaultHelpSettings() {
        if (fDefaultHelpSettings == null) {
            fDefaultHelpSettings = new CHelpSettings(null);
        }
        return fDefaultHelpSettings;
    }

    private static CHelpSettings getPersistedHelpSettings(IProject project) {
        return CHelpProviderManager.createHelpSettings(project);
    }

    private static CHelpSettings createHelpSettings(IProject project) {
        project.getName();
        File file = CHelpProviderManager.getSettingsFile();
        CHelpSettings settings = null;
        Element rootElement = null;
        if (file.isFile()) {
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(file);
                NodeList nodes = doc.getElementsByTagName(ELEMENT_ROOT);
                if (nodes.getLength() > 0) {
                    rootElement = (Element)nodes.item(0);
                }
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {}
        }
        settings = new CHelpSettings(project, rootElement);
        return settings;
    }

    private static CHelpSettings getHelpSettings(IProject project) {
        if (project == null) {
            return CHelpProviderManager.getDefaultHelpSettings();
        }
        CHelpSettings settings = null;
        if (fCurrentProject != null && fCurrentSettings != null && project == fCurrentProject) {
            settings = fCurrentSettings;
        } else {
            fCurrentProject = project;
            settings = fCurrentSettings = CHelpProviderManager.getPersistedHelpSettings(project);
        }
        return settings;
    }

    private static CHelpSettings getHelpSettings(ICHelpInvocationContext context) {
        IProject project = CHelpProviderManager.getProjectFromContext(context);
        return CHelpProviderManager.getHelpSettings(project);
    }

    private static IProject getProjectFromContext(ICHelpInvocationContext context) {
        ITranslationUnit unit;
        IProject project = context.getProject();
        if (project == null && (unit = context.getTranslationUnit()) != null) {
            project = unit.getCProject().getProject();
        }
        return project;
    }

    public static CHelpProviderManager getDefault() {
        if (fInstance == null) {
            fInstance = new CHelpProviderManager();
        }
        return fInstance;
    }

    public IFunctionSummary getFunctionInfo(ICHelpInvocationContext context, String name) {
        CHelpSettings settings = CHelpProviderManager.getHelpSettings(context);
        return settings.getFunctionInfo(context, name);
    }

    public IFunctionSummary[] getMatchingFunctions(ICHelpInvocationContext context, String frag) {
        CHelpSettings settings = CHelpProviderManager.getHelpSettings(context);
        return settings.getMatchingFunctions(context, frag);
    }

    public ICHelpResourceDescriptor[] getHelpResources(ICHelpInvocationContext context, String name) {
        CHelpSettings settings = CHelpProviderManager.getHelpSettings(context);
        return settings.getHelpResources(context, name);
    }

    public CHelpBookDescriptor[] getCHelpBookDescriptors(ICHelpInvocationContext context) {
        return CHelpProviderManager.getHelpSettings(context).getCHelpBookDescriptors();
    }

    public void serialize(ICHelpInvocationContext context) {
        CHelpSettings settings = CHelpProviderManager.getHelpSettings(context);
        File file = CHelpProviderManager.getSettingsFile();
        try {
            Document doc;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Element rootElement = null;
            if (file.exists()) {
                doc = builder.parse(file);
                NodeList nodes = doc.getElementsByTagName(ELEMENT_ROOT);
                if (nodes.getLength() > 0) {
                    rootElement = (Element)nodes.item(0);
                }
            } else {
                doc = builder.newDocument();
            }
            if (rootElement == null) {
                rootElement = doc.createElement(ELEMENT_ROOT);
                doc.appendChild(rootElement);
            }
            settings.serialize(doc, rootElement);
            FileWriter writer = new FileWriter(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            writer.close();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
        }
        catch (IOException iOException) {}
    }
}

