/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.LinkedList;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class GoToNextPreviousMemberAction
extends TextEditorAction {
    private boolean fGotoNext;

    public GoToNextPreviousMemberAction(ResourceBundle bundle, String prefix, ITextEditor editor, boolean gotoNext) {
        super(bundle, prefix, editor);
        this.fGotoNext = gotoNext;
    }

    public GoToNextPreviousMemberAction(ResourceBundle bundle, String prefix, ITextEditor editor, int style, boolean gotoNext) {
        super(bundle, prefix, editor, style);
        this.fGotoNext = gotoNext;
    }

    public void run() {
        CEditor editor = (CEditor)this.getTextEditor();
        ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
        IEditorInput editorInput = editor.getEditorInput();
        WorkingCopy workingCopy = (WorkingCopy)CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
        try {
            ICElement[] elements = workingCopy.getChildren();
            Integer[] elementOffsets = GoToNextPreviousMemberAction.createSourceIndexes(elements);
            ICElement selectedElement = workingCopy.getElementAtOffset(selection.getOffset());
            if (selectedElement != null && selectedElement instanceof ISourceReference) {
                int offset = ((ISourceReference)selectedElement).getSourceRange().getStartPos();
                int offsetToSelect = this.fGotoNext ? GoToNextPreviousMemberAction.getNextOffset(elementOffsets, offset) : GoToNextPreviousMemberAction.getPreviousOffset(elementOffsets, offset);
                editor.selectAndReveal(offsetToSelect, 0);
            } else if (selectedElement == null) {
                int offset = selection.getOffset();
                int offsetToSelect = this.fGotoNext ? GoToNextPreviousMemberAction.getNextOffset(elementOffsets, offset) : GoToNextPreviousMemberAction.getPreviousOffset(elementOffsets, offset);
                editor.selectAndReveal(offsetToSelect, 0);
            }
        }
        catch (CModelException e) {
            CUIPlugin.getDefault().log(e);
        }
    }

    private static int getNextOffset(Integer[] offsets, int actualOffset) {
        if (offsets.length > 0 && actualOffset < offsets[0]) {
            return offsets[0];
        }
        int i = 0;
        while (i < offsets.length - 1) {
            if (offsets[i] == actualOffset) {
                return offsets[i + 1];
            }
            if (actualOffset > offsets[i] && actualOffset < offsets[i + 1]) {
                return offsets[i + 1];
            }
            ++i;
        }
        return actualOffset;
    }

    private static int getPreviousOffset(Integer[] offsets, int actualOffset) {
        if (offsets.length > 0 && actualOffset > offsets[offsets.length - 1]) {
            return offsets[offsets.length - 1];
        }
        int i = 1;
        while (i < offsets.length) {
            if (offsets[i] == actualOffset) {
                return offsets[i - 1];
            }
            if (actualOffset > offsets[i - 1] && actualOffset < offsets[i]) {
                return offsets[i - 1];
            }
            ++i;
        }
        return actualOffset;
    }

    private static Integer[] createSourceIndexes(ICElement[] elements) throws CModelException {
        LinkedList<Integer> indexesList = new LinkedList<Integer>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof ISourceReference) {
                indexesList.add(new Integer(((ISourceReference)elements[i]).getSourceRange().getStartPos()));
            }
            ++i;
        }
        Integer[] indexes = new Integer[indexesList.size()];
        indexesList.toArray(indexes);
        return indexes;
    }
}

