/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.cbrowsing;

import java.util.Collection;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeCacheChangedListener;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.BaseCElementContentProvider;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.CBrowsingPart;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class CBrowsingContentProvider
extends BaseCElementContentProvider
implements ITreeContentProvider,
IElementChangedListener,
ITypeCacheChangedListener {
    public static final Object CONTENT_CANCELLED = new Object();
    public static final Object CONTENT_ERROR = new Object();
    public static final Object CONTENT_EMPTY = new Object();
    protected static final Object[] ERROR_NO_CHILDREN = new Object[]{CONTENT_ERROR};
    protected static final Object[] ERROR_CANCELLED = new Object[]{CONTENT_CANCELLED};
    protected static final Object[] EMPTY_CHILDREN = NO_CHILDREN;
    protected static final Object[] INVALID_INPUT = NO_CHILDREN;
    protected StructuredViewer fViewer;
    protected Object fInput = null;
    protected IProject fProject = null;
    protected CBrowsingPart fBrowsingPart;
    protected int fReadsInDisplayThread;

    public CBrowsingContentProvider(CBrowsingPart browsingPart) {
        this.fBrowsingPart = browsingPart;
        this.fViewer = this.fBrowsingPart.getViewer();
        AllTypesCache.addTypeCacheChangedListener((ITypeCacheChangedListener)this);
        CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this);
    }

    public synchronized void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof Collection) {
            Collection col = (Collection)newInput;
            newInput = !col.isEmpty() ? col.iterator().next() : null;
        }
        this.fInput = newInput;
        this.fProject = this.getProject(newInput);
    }

    public void dispose() {
        AllTypesCache.removeTypeCacheChangedListener((ITypeCacheChangedListener)this);
        CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
    }

    public void typeCacheChanged(IProject project) {
        if (this.fInput != null && (this.fProject == null || !this.fProject.isAccessible() || this.fProject.equals((Object)project))) {
            Object input = null;
            if (project != null && project.isAccessible()) {
                input = this.getNewInput(project);
            }
            this.postAdjustInputAndSetSelection(input);
        }
    }

    private IProject getProject(Object input) {
        ICProject cProj;
        if (input instanceof ICElement && (cProj = ((ICElement)input).getCProject()) != null) {
            return cProj.getProject();
        }
        if (input instanceof ITypeInfo) {
            return ((ITypeInfo)input).getEnclosingProject();
        }
        return null;
    }

    private Object getNewInput(IProject project) {
        ICProject cproject;
        if (this.fInput == null || this.fInput instanceof ICModel) {
            return this.fInput;
        }
        if (this.fInput instanceof ICProject) {
            ICProject cproject2 = CoreModel.getDefault().create(project);
            if (!cproject2.equals(this.fInput)) {
                return cproject2;
            }
            return this.fInput;
        }
        if (this.fInput instanceof ISourceRoot) {
            cproject = CoreModel.getDefault().create(project);
            ISourceRoot cSourceRoot = (ISourceRoot)this.fInput;
            if (!cSourceRoot.getCProject().equals(cproject)) {
                return cSourceRoot;
            }
            try {
                ISourceRoot[] roots = cproject.getSourceRoots();
                int i = 0;
                while (i < roots.length) {
                    ISourceRoot root = roots[i];
                    if (!(root.getResource() instanceof IProject) && root.equals(cSourceRoot)) {
                        return root;
                    }
                    ++i;
                }
            }
            catch (CModelException e) {
                e.printStackTrace();
            }
        }
        if (this.fInput instanceof ICElement) {
            cproject = CoreModel.getDefault().create(project);
            ICElement celem = (ICElement)this.fInput;
            if (!celem.getCProject().equals(cproject)) {
                return celem;
            }
            ICElement[] iCElementArray = new ICElement[2];
            iCElementArray[0] = celem;
            final ICElement[] searchInfo = iCElementArray;
            try {
                cproject.accept(new ICElementVisitor(){

                    public boolean visit(ICElement element) throws CoreException {
                        if (searchInfo[1] != null) {
                            return false;
                        }
                        if (element.equals(searchInfo[0])) {
                            searchInfo[1] = element;
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException coreException) {}
            if (searchInfo[1] != null) {
                return searchInfo[1];
            }
            return null;
        }
        if (this.fInput instanceof ITypeInfo) {
            ITypeInfo info = (ITypeInfo)this.fInput;
            if (info.exists()) {
                return info;
            }
            IProject infoProj = info.getEnclosingProject();
            if (infoProj == null) {
                return null;
            }
            if (!infoProj.equals((Object)project)) {
                return info;
            }
            ITypeInfo globalNS = AllTypesCache.getGlobalNamespace((IProject)project);
            if (info.equals(globalNS)) {
                return globalNS;
            }
            if ((info = AllTypesCache.getType((IProject)project, (int)info.getCElementType(), (IQualifiedTypeName)info.getQualifiedTypeName())) != null) {
                return info;
            }
            return null;
        }
        return null;
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (CModelException e) {
            CUIPlugin.getDefault().log(e.getStatus());
        }
    }

    protected boolean isPathEntryChange(ICElementDelta delta) {
        int flags = delta.getFlags();
        return delta.getKind() == 4 && ((flags & 0x800000) != 0 || (flags & 0x1000) != 0 || (flags & 0x100) != 0 || (flags & 0x2000) != 0 || (flags & 0x40000) != 0 || (flags & 0x200) != 0 || (flags & 0x800) != 0);
    }

    protected void processDelta(ICElementDelta delta) throws CModelException {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        ICElement element = delta.getElement();
        if (element instanceof ITranslationUnit && ((ITranslationUnit)element).isWorkingCopy()) {
            return;
        }
        if ((flags & 0x80) != 0 || (flags & 0x40) != 0) {
            this.postRefresh(element);
        }
        if (kind == 2) {
            this.postRemove(element);
        }
        if (kind == 1) {
            Object parent = this.internalGetParent(element);
            this.postAdd(parent, element);
        }
        if (kind == 4 && (element instanceof ITranslationUnit || element instanceof IBinary || element instanceof IArchive)) {
            this.postRefresh(element);
            return;
        }
        if (this.isPathEntryChange(delta)) {
            this.postRefresh(element.getCProject());
        }
        ICElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private void postAdjustInputAndSetSelection(final Object input) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ctrl.setRedraw(false);
                    CBrowsingContentProvider.this.fBrowsingPart.adjustInputAndPreserveSelection(input);
                    ctrl.setRedraw(true);
                }
            }
        });
    }

    private void postRefresh(final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    if (element instanceof IWorkingCopy) {
                        if (CBrowsingContentProvider.this.fViewer.testFindItem(element) != null) {
                            CBrowsingContentProvider.this.fViewer.refresh(element);
                        } else {
                            CBrowsingContentProvider.this.fViewer.refresh((Object)((IWorkingCopy)element).getOriginalElement());
                        }
                    } else {
                        CBrowsingContentProvider.this.fViewer.refresh(element);
                    }
                }
            }
        });
    }

    private void postAdd(final Object parent, Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    if (parent instanceof IWorkingCopy) {
                        if (CBrowsingContentProvider.this.fViewer.testFindItem(parent) != null) {
                            CBrowsingContentProvider.this.fViewer.refresh(parent);
                        } else {
                            CBrowsingContentProvider.this.fViewer.refresh((Object)((IWorkingCopy)parent).getOriginalElement());
                        }
                    } else {
                        CBrowsingContentProvider.this.fViewer.refresh(parent);
                    }
                }
            }
        });
    }

    private void postRemove(final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = CBrowsingContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    Object parent = CBrowsingContentProvider.this.internalGetParent(element);
                    if (parent instanceof IWorkingCopy) {
                        if (CBrowsingContentProvider.this.fViewer.testFindItem(parent) != null) {
                            CBrowsingContentProvider.this.fViewer.refresh(parent);
                        } else {
                            CBrowsingContentProvider.this.fViewer.refresh((Object)((IWorkingCopy)parent).getOriginalElement());
                        }
                    } else {
                        CBrowsingContentProvider.this.fViewer.refresh(parent);
                    }
                }
            }
        });
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            ctrl.getDisplay().asyncExec(r);
        }
    }

    protected void startReadInDisplayThread() {
        if (this.isDisplayThread()) {
            ++this.fReadsInDisplayThread;
        }
    }

    protected void finishedReadInDisplayThread() {
        if (this.isDisplayThread()) {
            --this.fReadsInDisplayThread;
        }
    }

    private boolean isDisplayThread() {
        Control ctrl = this.fViewer.getControl();
        if (ctrl == null) {
            return false;
        }
        Display currentDisplay = Display.getCurrent();
        return currentDisplay != null && currentDisplay.equals(ctrl.getDisplay());
    }
}

