/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.browser.typehierarchy.ITypeHierarchy;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.internal.ui.viewsupport.StandardCElementLabelProvider;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class HierarchyLabelProvider
extends StandardCElementLabelProvider {
    private Color fGrayedColor;
    private Color fSpecialColor;
    private ViewerFilter fFilter;
    private TypeHierarchyLifeCycle fHierarchy;

    public HierarchyLabelProvider(TypeHierarchyLifeCycle lifeCycle) {
        this.fHierarchy = lifeCycle;
        this.fFilter = null;
    }

    public ViewerFilter getFilter() {
        return this.fFilter;
    }

    public void setFilter(ViewerFilter filter) {
        this.fFilter = filter;
    }

    protected boolean isDifferentScope(ICElement type) {
        if (this.fFilter != null && !this.fFilter.select(null, null, (Object)type)) {
            return true;
        }
        ICElement input = this.fHierarchy.getInputElement();
        if (input == null || TypeUtil.isClassOrStruct((ICElement)input)) {
            return false;
        }
        ICElement parent = type.getAncestor(input.getElementType());
        return !(input.getElementType() == 12 ? parent == null || parent.getElementName().equals(input.getElementName()) : input.equals(parent));
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof ICElement) {
            Object desc = this.getTypeImageDescriptor((ICElement)element);
            if (desc != null) {
                if (element.equals(this.fHierarchy.getInputElement())) {
                    desc = new FocusDescriptor((ImageDescriptor)desc);
                }
                result = CUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
            }
        } else {
            result = this.fImageLabelProvider.getImageLabel(element, this.getImageFlags());
        }
        return result;
    }

    private ImageDescriptor getTypeImageDescriptor(ICElement type) {
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return new CElementImageDescriptor(CPluginImages.DESC_OBJS_CLASS, 0, CElementImageProvider.BIG_SIZE);
        }
        ImageDescriptor desc = this.isDifferentScope(type) ? CElementImageProvider.getClassImageDescriptor() : this.fImageLabelProvider.getBaseImageDescriptor(type, 0);
        int adornmentFlags = 0;
        if (type instanceof IMethodDeclaration) {
            IMethodDeclaration method = (IMethodDeclaration)type;
            try {
                if (method.isStatic()) {
                    adornmentFlags |= 8;
                }
            }
            catch (CModelException cModelException) {}
        }
        boolean cfr_ignored_0 = type instanceof IStructure;
        return new CElementImageDescriptor(desc, adornmentFlags, CElementImageProvider.BIG_SIZE);
    }

    public Color getForeground(Object element) {
        if (element instanceof IMethod) {
            if (this.fSpecialColor == null) {
                this.fSpecialColor = Display.getCurrent().getSystemColor(10);
            }
            return this.fSpecialColor;
        }
        if (element instanceof ICElement && this.isDifferentScope((ICElement)element)) {
            if (this.fGrayedColor == null) {
                this.fGrayedColor = Display.getCurrent().getSystemColor(16);
            }
            return this.fGrayedColor;
        }
        return null;
    }

    private static class FocusDescriptor
    extends CompositeImageDescriptor {
        private ImageDescriptor fBase;
        static /* synthetic */ Class class$0;

        public FocusDescriptor(ImageDescriptor base) {
            this.fBase = base;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.getImageData(this.fBase), 0, 0);
            this.drawImage(this.getImageData(CPluginImages.DESC_OVR_FOCUS), 0, 0);
        }

        private ImageData getImageData(ImageDescriptor descriptor) {
            ImageData data = descriptor.getImageData();
            if (data == null) {
                data = DEFAULT_IMAGE_DATA;
                CUIPlugin.getDefault().logErrorMessage("Image data not available: " + descriptor.toString());
            }
            return data;
        }

        protected Point getSize() {
            return CElementImageProvider.BIG_SIZE;
        }

        public int hashCode() {
            return this.fBase.hashCode();
        }

        public boolean equals(Object object) {
            if (object != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.internal.ui.browser.typehierarchy.HierarchyLabelProvider$FocusDescriptor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(object.getClass()) && ((FocusDescriptor)((Object)object)).fBase.equals(this.fBase)) {
                    return true;
                }
            }
            return false;
        }
    }
}

