/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyMessages;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class HistoryListAction
extends Action {
    private TypeHierarchyViewPart fView;

    public HistoryListAction(TypeHierarchyViewPart view) {
        this.fView = view;
        this.setText(TypeHierarchyMessages.getString("HistoryListAction.label"));
        CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "history_list.gif");
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.history_list_action");
    }

    public void run() {
        ICElement[] historyEntries = this.fView.getHistoryEntries();
        HistoryListDialog dialog = new HistoryListDialog(CUIPlugin.getActiveWorkbenchShell(), historyEntries);
        if (dialog.open() == 0) {
            this.fView.setHistoryEntries(dialog.getRemaining());
            this.fView.setInputElement(dialog.getResult());
        }
    }

    private class HistoryListDialog
    extends StatusDialog {
        private ListDialogField fHistoryList;
        private IStatus fHistoryStatus;
        private ICElement fResult;

        HistoryListDialog(Shell shell, ICElement[] elements) {
            super(shell);
            this.setTitle(TypeHierarchyMessages.getString("HistoryListDialog.title"));
            String[] buttonLabels = new String[]{TypeHierarchyMessages.getString("HistoryListDialog.remove.button")};
            IListAdapter adapter = new IListAdapter(this){
                final /* synthetic */ HistoryListDialog this$1;
                {
                    this.this$1 = historyListDialog;
                }

                public void customButtonPressed(ListDialogField field, int index) {
                    this.this$1.doCustomButtonPressed();
                }

                public void selectionChanged(ListDialogField field) {
                    this.this$1.doSelectionChanged();
                }

                public void doubleClicked(ListDialogField field) {
                    this.this$1.doDoubleClicked();
                }
            };
            CElementLabelProvider labelProvider = new CElementLabelProvider(1024);
            this.fHistoryList = new ListDialogField(adapter, buttonLabels, (IBaseLabelProvider)labelProvider);
            this.fHistoryList.setLabelText(TypeHierarchyMessages.getString("HistoryListDialog.label"));
            this.fHistoryList.setElements(Arrays.asList(elements));
            StructuredSelection sel = elements.length > 0 ? new StructuredSelection((Object)elements[0]) : new StructuredSelection();
            this.fHistoryList.selectElements((ISelection)sel);
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            inner.setLayoutData((Object)new GridData(1808));
            LayoutUtil.doDefaultLayout(inner, new DialogField[]{this.fHistoryList}, true, 0, 0);
            LayoutUtil.setHeigthHint(this.fHistoryList.getListControl(null), this.convertHeightInCharsToPixels(12));
            LayoutUtil.setHorizontalGrabbing(this.fHistoryList.getListControl(null));
            HistoryListDialog.applyDialogFont((Control)composite);
            return composite;
        }

        void doCustomButtonPressed() {
            this.fHistoryList.removeElements(this.fHistoryList.getSelectedElements());
        }

        void doDoubleClicked() {
            if (this.fHistoryStatus.isOK()) {
                this.okPressed();
            }
        }

        void doSelectionChanged() {
            StatusInfo status = new StatusInfo();
            List selected = this.fHistoryList.getSelectedElements();
            if (selected.size() != 1) {
                status.setError("");
                this.fResult = null;
            } else {
                this.fResult = (ICElement)selected.get(0);
            }
            this.fHistoryList.enableButton(0, this.fHistoryList.getSize() > selected.size() && selected.size() != 0);
            this.fHistoryStatus = status;
            this.updateStatus(status);
        }

        public ICElement getResult() {
            return this.fResult;
        }

        public ICElement[] getRemaining() {
            List elems = this.fHistoryList.getElements();
            return elems.toArray(new ICElement[elems.size()]);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.cdt.ui.history_list_dialog_context");
        }

        public void create() {
            this.setShellStyle(this.getShellStyle() | 0x10);
            super.create();
        }
    }
}

