/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.browser.typehierarchy.ITypeHierarchy;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.MethodsViewer;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.cdt.internal.ui.viewsupport.StandardCElementLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class MethodsLabelProvider
extends StandardCElementLabelProvider {
    private Color fResolvedBackground;
    private boolean fShowDefiningType;
    private TypeHierarchyLifeCycle fHierarchy;
    private MethodsViewer fMethodsViewer;

    public MethodsLabelProvider(TypeHierarchyLifeCycle lifeCycle, MethodsViewer methodsViewer) {
        this.fHierarchy = lifeCycle;
        this.fShowDefiningType = false;
        this.fMethodsViewer = methodsViewer;
        this.fResolvedBackground = null;
    }

    public void setShowDefiningType(boolean showDefiningType) {
        this.fShowDefiningType = showDefiningType;
    }

    public boolean isShowDefiningType() {
        return this.fShowDefiningType;
    }

    private ICElement getDefiningType(Object element) throws CModelException {
        if (!(element instanceof ICElement)) {
            return null;
        }
        ICElement elem = (ICElement)element;
        int kind = elem.getElementType();
        if (kind != 71 && kind != 72) {
            return null;
        }
        ICElement declaringType = TypeUtil.getDeclaringClass((ICElement)elem);
        if (kind != 71) {
            return declaringType;
        }
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return declaringType;
        }
        IMethodDeclaration method = (IMethodDeclaration)element;
        if (method.getVisibility() == ASTAccessVisibility.PRIVATE || method.isStatic() || method.isConstructor() || method.isDestructor()) {
            return declaringType;
        }
        IMethodDeclaration res = TypeUtil.findMethodDeclarationInHierarchy((ITypeHierarchy)hierarchy, (ICElement)declaringType, (String)method.getElementName(), (String[])method.getParameterTypes(), (boolean)false, (boolean)false);
        if (res == null || method.equals(res)) {
            return declaringType;
        }
        return TypeUtil.getDeclaringClass((ICElement)res);
    }

    public String getText(Object element) {
        ICElement parent;
        String text = super.getText(element);
        if ((this.getTextFlags() & 0x40) != 0 && element instanceof ICElement && (parent = ((ICElement)element).getParent()) != null) {
            StringBuffer name = new StringBuffer();
            name.append(text);
            name.append(CElementLabels.CONCAT_STRING);
            name.append(TypeUtil.getFullyQualifiedName((ICElement)parent).toString());
            text = name.toString();
        }
        if (this.fShowDefiningType) {
            try {
                ICElement type = this.getDefiningType(element);
                if (type != null) {
                    StringBuffer buf = new StringBuffer(super.getText(type));
                    buf.append(CElementLabels.CONCAT_STRING);
                    buf.append(text);
                    return buf.toString();
                }
            }
            catch (CModelException cModelException) {}
        }
        return text;
    }

    public Color getForeground(Object element) {
        IMethod curr;
        ICElement declaringType;
        if (this.fMethodsViewer.isShowInheritedMethods() && element instanceof IMethod && (declaringType = TypeUtil.getDeclaringClass((ICElement)(curr = (IMethod)element))).equals(this.fMethodsViewer.getInput())) {
            if (this.fResolvedBackground == null) {
                Display display = Display.getCurrent();
                this.fResolvedBackground = display.getSystemColor(10);
            }
            return this.fResolvedBackground;
        }
        return null;
    }
}

