/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.IQualifiedTypeName;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.actions.ActionUtil;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.OpenTypeHierarchyUtil;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTypeHierarchyAction
extends SelectionDispatchAction {
    private CEditor fEditor;

    public OpenTypeHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("OpenTypeHierarchyAction.label"));
        this.setToolTipText(ActionMessages.getString("OpenTypeHierarchyAction.tooltip"));
        this.setDescription(ActionMessages.getString("OpenTypeHierarchyAction.description"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.open_type_hierarchy_action");
    }

    public OpenTypeHierarchyAction(CEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object input = selection.getFirstElement();
        if (input instanceof ICElement) {
            ICElement elem = (ICElement)input;
            return TypeUtil.isClassOrStruct((ICElement)elem);
        }
        return false;
    }

    public void run(ITextSelection selection) {
        ICElement input = SelectionConverter.getInput((ITextEditor)this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        ICElement[] elements = SelectionConverter.codeResolveOrInputHandled(this.fEditor, this.getShell(), OpenTypeHierarchyAction.getDialogTitle());
        if (elements == null) {
            return;
        }
        ArrayList<ICElement> candidates = new ArrayList<ICElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            ICElement elem = elements[i];
            if (elem instanceof ITranslationUnit) {
                ICElement[] realElems = this.findTypeDeclarations(selection.getText(), (ITranslationUnit)elem, selection.getOffset(), selection.getLength(), (IProgressMonitor)new NullProgressMonitor());
                if (realElems != null) {
                    int j = 0;
                    while (j < realElems.length) {
                        ICElement[] resolvedElements = OpenTypeHierarchyUtil.getCandidates(realElems[j]);
                        if (resolvedElements != null) {
                            candidates.addAll(Arrays.asList(resolvedElements));
                        }
                        ++j;
                    }
                }
            } else {
                ICElement[] resolvedElements = OpenTypeHierarchyUtil.getCandidates(elem);
                if (resolvedElements != null) {
                    candidates.addAll(Arrays.asList(resolvedElements));
                }
            }
            ++i;
        }
        this.run(candidates.toArray(new ICElement[candidates.size()]));
    }

    private ICElement[] findTypeDeclarations(String name, ITranslationUnit unit, int offset, int length, IProgressMonitor monitor) {
        TypeSearchScope wsScope = new TypeSearchScope(true);
        if (!AllTypesCache.isCacheUpToDate((ITypeSearchScope)wsScope)) {
            AllTypesCache.updateCache((ITypeSearchScope)wsScope, (IProgressMonitor)monitor);
        }
        TypeSearchScope projectScope = new TypeSearchScope();
        projectScope.add((ICElement)unit.getCProject());
        int[] kinds = new int[]{65, 67};
        ITypeInfo[] types = AllTypesCache.getTypes((ITypeSearchScope)projectScope, (IQualifiedTypeName)new QualifiedTypeName(name), (int[])kinds, (boolean)true);
        if (types != null) {
            ArrayList<ICElement> elements = new ArrayList<ICElement>(types.length);
            int i = 0;
            while (i < types.length) {
                ICElement e = AllTypesCache.getElementForType((ITypeInfo)types[i], (boolean)true, (boolean)true, (IProgressMonitor)monitor);
                if (e != null && !elements.contains(e)) {
                    elements.add(e);
                }
                ++i;
            }
            if (!elements.isEmpty()) {
                return elements.toArray(new ICElement[elements.size()]);
            }
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof ICElement)) {
            IStatus status = OpenTypeHierarchyAction.createStatus(ActionMessages.getString("OpenTypeHierarchyAction.messages.no_c_element"));
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.getString("OpenTypeHierarchyAction.messages.title"), (IStatus)status);
            return;
        }
        ICElement element = (ICElement)input;
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        ArrayList result = new ArrayList(1);
        IStatus status = OpenTypeHierarchyAction.compileCandidates(result, element);
        if (status.isOK()) {
            this.run(result.toArray(new ICElement[result.size()]));
        } else {
            ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)ActionMessages.getString("OpenTypeHierarchyAction.messages.title"), (IStatus)status);
        }
    }

    public void run(ICElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        OpenTypeHierarchyUtil.open(elements, this.getSite().getWorkbenchWindow());
    }

    private static String getDialogTitle() {
        return ActionMessages.getString("OpenTypeHierarchyAction.dialog.title");
    }

    private static IStatus compileCandidates(List result, ICElement elem) {
        Status ok = new Status(0, CUIPlugin.getPluginId(), 0, "", null);
        switch (elem.getElementType()) {
            case 11: 
            case 65: 
            case 67: {
                result.add(elem);
                return ok;
            }
        }
        return OpenTypeHierarchyAction.createStatus(ActionMessages.getString("OpenTypeHierarchyAction.messages.no_valid_c_element"));
    }

    private static IStatus createStatus(String message) {
        return new Status(1, CUIPlugin.getPluginId(), 10001, message, null);
    }
}

