/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.typehierarchy.ITypeHierarchy;
import org.eclipse.cdt.core.browser.typehierarchy.ITypeHierarchyChangedListener;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.ITypeHierarchyLifeCycleListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class TypeHierarchyLifeCycle
implements ITypeHierarchyChangedListener,
IElementChangedListener {
    private boolean fHierarchyRefreshNeeded;
    private ITypeHierarchy fHierarchy = null;
    private ICElement fInputElement = null;
    private List fChangeListeners = new ArrayList(2);

    public TypeHierarchyLifeCycle() {
        this(true);
    }

    public TypeHierarchyLifeCycle(boolean isSuperTypesOnly) {
    }

    public ITypeHierarchy getHierarchy() {
        return this.fHierarchy;
    }

    public ICElement getInputElement() {
        return this.fInputElement;
    }

    public void freeHierarchy() {
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
            this.fHierarchy = null;
            this.fInputElement = null;
        }
    }

    public void removeChangedListener(ITypeHierarchyLifeCycleListener listener) {
        this.fChangeListeners.remove(listener);
    }

    public void addChangedListener(ITypeHierarchyLifeCycleListener listener) {
        if (!this.fChangeListeners.contains(listener)) {
            this.fChangeListeners.add(listener);
        }
    }

    private void fireChange(ICElement[] changedTypes) {
        int i = this.fChangeListeners.size() - 1;
        while (i >= 0) {
            ITypeHierarchyLifeCycleListener curr = (ITypeHierarchyLifeCycleListener)this.fChangeListeners.get(i);
            curr.typeHierarchyChanged(this, changedTypes);
            --i;
        }
    }

    public void ensureRefreshedTypeHierarchy(final ICElement element, IRunnableContext context) throws InvocationTargetException, InterruptedException {
        boolean hierachyCreationNeeded;
        if (element == null || !element.exists()) {
            this.freeHierarchy();
            return;
        }
        boolean bl = hierachyCreationNeeded = this.fHierarchy == null || !element.equals(this.fInputElement);
        if (hierachyCreationNeeded || this.fHierarchyRefreshNeeded) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                    try {
                        TypeHierarchyLifeCycle.this.doHierarchyRefresh(element, pm);
                    }
                    catch (CModelException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
            };
            this.fHierarchyRefreshNeeded = true;
            context.run(true, true, op);
            this.fHierarchyRefreshNeeded = false;
        }
    }

    private ITypeHierarchy createTypeHierarchy(ICElement element, IProgressMonitor pm) throws CModelException {
        if (element.getElementType() == 65 || element.getElementType() == 67) {
            return AllTypesCache.createTypeHierarchy((ICElement)element, (IProgressMonitor)pm);
        }
        return null;
    }

    public synchronized void doHierarchyRefresh(ICElement element, IProgressMonitor pm) throws CModelException {
        boolean hierachyCreationNeeded;
        boolean bl = hierachyCreationNeeded = this.fHierarchy == null || !element.equals(this.fInputElement);
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
        }
        if (hierachyCreationNeeded) {
            this.fHierarchy = this.createTypeHierarchy(element, pm);
            if (pm != null && pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fInputElement = element;
        } else if (this.fHierarchy != null) {
            this.fHierarchy.refresh(pm);
        }
        if (this.fHierarchy != null) {
            this.fHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        }
        CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this);
        this.fHierarchyRefreshNeeded = false;
    }

    public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
        this.fHierarchyRefreshNeeded = true;
        this.fireChange(null);
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.fChangeListeners.isEmpty()) {
            return;
        }
        if (this.fHierarchyRefreshNeeded) {
            return;
        }
        ArrayList changedTypes = new ArrayList();
        this.processDelta(event.getDelta(), changedTypes);
        if (changedTypes.size() > 0) {
            this.fireChange(changedTypes.toArray(new ICElement[changedTypes.size()]));
        }
    }

    private void processDelta(ICElementDelta delta, ArrayList changedTypes) {
        ICElement element = delta.getElement();
        switch (element.getElementType()) {
            case 65: 
            case 67: {
                this.processTypeDelta(element, changedTypes);
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 10: 
            case 11: {
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 60: {
                ITranslationUnit cu = (ITranslationUnit)element;
                if (delta.getKind() == 4 && this.isPossibleStructuralChange(delta.getFlags())) {
                    if (!cu.exists()) break;
                    ICElement[] types = TypeHierarchyLifeCycle.getAllTypesForTranslationUnit(cu);
                    int i = 0;
                    while (i < types.length) {
                        this.processTypeDelta(types[i], changedTypes);
                        ++i;
                    }
                    break;
                }
                this.processChildrenDelta(delta, changedTypes);
            }
        }
    }

    private boolean isPossibleStructuralChange(int flags) {
        return (flags & 0x400001) == 1;
    }

    private void processTypeDelta(ICElement type, ArrayList changedTypes) {
        if (this.getHierarchy().contains(type)) {
            changedTypes.add(type);
        }
    }

    private void processChildrenDelta(ICElementDelta delta, ArrayList changedTypes) {
        ICElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processDelta(children[i], changedTypes);
            ++i;
        }
    }

    private static ICElement[] getAllTypesForTranslationUnit(ITranslationUnit unit) {
        return null;
    }
}

