/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.codemanipulation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IUsing;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class AddIncludesOperation
implements IWorkspaceRunnable {
    private ITranslationUnit fTranslationUnit;
    private IRequiredInclude[] fIncludes;
    private String[] fUsings;
    private boolean fDoSave;
    private String newLine = System.getProperty("line.separator", "\n");

    public AddIncludesOperation(ITranslationUnit tu, IRequiredInclude[] includes, boolean save) {
        this(tu, includes, null, save);
    }

    public AddIncludesOperation(ITranslationUnit tu, IRequiredInclude[] includes, String[] using, boolean save) {
        this.fIncludes = includes;
        this.fUsings = using;
        this.fTranslationUnit = tu;
        this.fDoSave = save;
    }

    public void executeInludes(IProgressMonitor monitor) throws CoreException {
        if (this.fIncludes == null || this.fIncludes.length == 0) {
            return;
        }
        if (this.fTranslationUnit != null) {
            ArrayList<IRequiredInclude> toAdd = new ArrayList<IRequiredInclude>();
            monitor.beginTask(CEditorMessages.getString("AddIncludesOperation.description"), 2);
            List elements = this.fTranslationUnit.getChildrenOfType(75);
            int i = 0;
            while (i < this.fIncludes.length) {
                String name = this.fIncludes[i].getIncludeName();
                boolean found = false;
                int j = 0;
                while (j < elements.size()) {
                    IInclude include = (IInclude)elements.get(j);
                    if (name.equals(include.getElementName())) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    toAdd.add(this.fIncludes[i]);
                }
                ++i;
            }
            if (toAdd.size() > 0) {
                int pos;
                StringBuffer insert = new StringBuffer("");
                int j = 0;
                while (j < toAdd.size()) {
                    IRequiredInclude req = (IRequiredInclude)toAdd.get(j);
                    if (req.isStandard()) {
                        insert.append("#include <" + req.getIncludeName() + ">\n");
                    } else {
                        insert.append("#include \"" + req.getIncludeName() + "\"\n");
                    }
                    ++j;
                }
                if (elements.size() > 0) {
                    IInclude lastInclude = (IInclude)elements.get(elements.size() - 1);
                    ISourceRange range = lastInclude.getSourceRange();
                    pos = range.getStartPos() + range.getLength();
                } else {
                    pos = 0;
                }
                monitor.worked(1);
                this.replace(pos, insert.toString());
                monitor.worked(1);
            }
        }
    }

    public void executeUsings(IProgressMonitor monitor) throws CoreException {
        if (this.fUsings == null || this.fUsings.length == 0) {
            return;
        }
        if (this.fTranslationUnit != null) {
            ArrayList<String> toAdd = new ArrayList<String>();
            monitor.beginTask(CEditorMessages.getString("AddIncludesOperation.description"), 2);
            List elements = this.fTranslationUnit.getChildrenOfType(62);
            int i = 0;
            while (i < this.fUsings.length) {
                String name = this.fUsings[i];
                boolean found = false;
                int j = 0;
                while (j < elements.size()) {
                    IUsing using = (IUsing)elements.get(j);
                    if (name.equals(using.getElementName())) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    toAdd.add(this.fUsings[i]);
                }
                ++i;
            }
            if (toAdd.size() > 0) {
                int pos;
                ISourceRange range;
                StringBuffer insert = new StringBuffer("");
                int j = 0;
                while (j < toAdd.size()) {
                    String using = (String)toAdd.get(j);
                    insert.append("using namespace " + using + ";").append(this.newLine);
                    ++j;
                }
                List includes = this.fTranslationUnit.getChildrenOfType(75);
                if (includes.size() > 0) {
                    IInclude lastInclude = (IInclude)includes.get(includes.size() - 1);
                    range = lastInclude.getSourceRange();
                    pos = range.getStartPos() + range.getLength();
                } else if (elements.size() > 0) {
                    IUsing lastUsing = (IUsing)includes.get(includes.size() - 1);
                    range = lastUsing.getSourceRange();
                    pos = range.getStartPos() + range.getLength();
                } else {
                    pos = 0;
                }
                monitor.worked(1);
                this.replace(pos, insert.toString());
                monitor.worked(1);
            }
        }
    }

    void replace(int pos, String s) {
        try {
            IBuffer buffer = this.fTranslationUnit.getBuffer();
            if (pos > 0) {
                while (buffer.getChar(pos) != '\n') {
                    ++pos;
                }
                if (buffer.getChar(pos) == '\r') {
                    ++pos;
                }
                ++pos;
            }
            buffer.replace(pos, 0, s);
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            this.executeUsings(monitor);
            this.executeInludes(monitor);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        monitor.done();
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

