/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementGroup;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class CPElementFilter
extends ViewerFilter {
    protected List fExcludes;
    protected int[] fKind;
    protected boolean fExportedOnly;
    protected boolean fShowInherited;

    public CPElementFilter(Object[] excludedElements, int[] kind, boolean exportedOnly, boolean showInherited) {
        if (excludedElements != null) {
            this.fExcludes = Arrays.asList(excludedElements);
        }
        this.fKind = kind;
        this.fExportedOnly = exportedOnly;
        this.fShowInherited = showInherited;
    }

    public CPElementFilter(int[] kind, boolean exportedOnly, boolean showInherited) {
        this(null, kind, exportedOnly, showInherited);
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof CPElement) {
            int i = 0;
            while (i < this.fKind.length) {
                if (!(((CPElement)element).getEntryKind() != this.fKind[i] || this.fExcludes != null && this.fExcludes.contains(element))) {
                    if (this.fExportedOnly) {
                        if (!this.fShowInherited) {
                            return ((CPElement)element).getInherited() == null && ((CPElement)element).isExported();
                        }
                        return ((CPElement)element).isExported();
                    }
                    if (!this.fShowInherited) {
                        return ((CPElement)element).getInherited() == null;
                    }
                    return true;
                }
                ++i;
            }
        } else if (element instanceof IPathEntry) {
            int i = 0;
            while (i < this.fKind.length) {
                if (!(((IPathEntry)element).getEntryKind() != this.fKind[i] || this.fExcludes != null && this.fExcludes.contains(element))) {
                    if (this.fExportedOnly) {
                        return ((IPathEntry)element).isExported();
                    }
                    return true;
                }
                ++i;
            }
        } else if (element instanceof CPElementGroup) {
            int i = 0;
            while (i < this.fKind.length) {
                if (((CPElementGroup)element).getEntryKind() == this.fKind[i]) {
                    return true;
                }
                ++i;
            }
        } else {
            return true;
        }
        return false;
    }
}

