/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementGroup;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementLabelProvider;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementSorter;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathBasePage;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathContainerWizard;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CPathContainerEntryPage
extends CPathBasePage {
    private ListDialogField fCPathList;
    private ICProject fCurrCProject;
    private TreeListDialogField fContainersList;
    private final int IDX_ADD = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    private final int IDX_EXPORT = 5;

    public CPathContainerEntryPage(ListDialogField cPathList) {
        super(CPathEntryMessages.getString("ContainerEntryPage.title"));
        this.fCPathList = cPathList;
        String[] stringArray = new String[6];
        stringArray[0] = CPathEntryMessages.getString("ContainerEntryPage.add.button");
        stringArray[2] = CPathEntryMessages.getString("ContainerEntryPage.edit.button");
        stringArray[3] = CPathEntryMessages.getString("ContainerEntryPage.remove.button");
        stringArray[5] = CPathEntryMessages.getString("ContainerEntryPage.export.button");
        String[] buttonLabels = stringArray;
        ContainersAdapter adapter = new ContainersAdapter();
        this.fContainersList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPElementLabelProvider());
        this.fContainersList.setDialogFieldListener(adapter);
        this.fContainersList.setLabelText(CPathEntryMessages.getString("ContainerEntryPage.libraries.label"));
        this.fContainersList.enableButton(3, false);
        this.fContainersList.enableButton(2, false);
        this.fContainersList.enableButton(5, false);
        this.fContainersList.setTreeExpansionLevel(2);
        this.fContainersList.setViewerSorter(new CPElementSorter());
    }

    public void init(ICProject jproject) {
        this.fCurrCProject = jproject;
        this.updateLibrariesList();
    }

    private void updateLibrariesList() {
        List cpelements = this.fCPathList.getElements();
        ArrayList<CPElement> libelements = new ArrayList<CPElement>(cpelements.size());
        int nElements = cpelements.size();
        int i = 0;
        while (i < nElements) {
            CPElement cpe = (CPElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind())) {
                libelements.add(cpe);
            }
            ++i;
        }
        this.fContainersList.setElements(libelements);
    }

    public void createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fContainersList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fContainersList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fContainersList.setButtonsMinWidth(buttonBarWidth);
        this.fContainersList.getTreeViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof CPElementGroup) {
                    return ((CPElementGroup)element).getChildren().length != 0;
                }
                return true;
            }
        });
        this.setControl((Control)composite);
        CUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cdt.ui.std_prop_containers");
    }

    void containerPageCustomButtonPressed(DialogField field, int index) {
        Object[] containers = null;
        switch (index) {
            case 0: {
                containers = this.openContainerSelectionDialog(null);
                break;
            }
            case 2: {
                this.editEntry();
                return;
            }
            case 3: {
                this.removeEntry();
                return;
            }
            case 5: {
                this.exportEntry();
                return;
            }
        }
        if (containers != null) {
            int nElementsChosen = containers.length;
            List cplist = this.fContainersList.getElements();
            ArrayList<CPElement> elementsToAdd = new ArrayList<CPElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPElement curr = containers[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                }
                ++i;
            }
            this.fContainersList.addElements(elementsToAdd);
            if (index == 0) {
                this.fContainersList.refresh();
            }
            this.fContainersList.postSetSelection((ISelection)new StructuredSelection(containers));
        }
    }

    protected void containerPageDoubleClicked(TreeListDialogField field) {
        List selection = this.fContainersList.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void containerPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fContainersList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof CPElement) {
                CPElement curr = (CPElement)elem;
                if (curr.getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void removeEntry() {
        List selElements = this.fContainersList.getSelectedElements();
        this.fContainersList.removeElements(selElements);
    }

    private boolean canExport(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof CPElement) {
                CPElement curr = (CPElement)elem;
                if (curr.getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void exportEntry() {
        List selElements = this.fContainersList.getSelectedElements();
        if (selElements.size() == 0) {
            return;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof CPElement) {
                ((CPElement)elem).setExported(!((CPElement)elem).isExported());
            }
            ++i;
        }
        this.fContainersList.refresh();
    }

    private void editEntry() {
        List selElements = this.fContainersList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fContainersList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPElement)elem);
        } else if (elem instanceof CPElementAttribute) {
            this.editAttributeEntry((CPElementAttribute)elem);
        }
    }

    private void editAttributeEntry(CPElementAttribute elem) {
    }

    private void editElementEntry(CPElement elem) {
        CPElement[] res = null;
        res = this.openContainerSelectionDialog(elem);
        if (res != null && res.length > 0) {
            CPElement curr = res[0];
            curr.setExported(elem.isExported());
            this.fContainersList.replaceElement(elem, curr);
        }
    }

    void containerPageSelectionChanged(DialogField field) {
        List selElements = this.fContainersList.getSelectedElements();
        this.fContainersList.enableButton(2, this.canEdit(selElements));
        this.fContainersList.enableButton(3, this.canRemove(selElements));
        this.fContainersList.enableButton(5, this.canExport(selElements));
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPElement) {
            CPElement curr = (CPElement)elem;
            return !(curr.getResource() instanceof IFolder) && curr.getParentContainer() == null;
        }
        return elem instanceof CPElementAttribute;
    }

    void containerPageDialogFieldChanged(DialogField field) {
        if (this.fCurrCProject != null) {
            this.updateCPathList();
        }
    }

    private void updateCPathList() {
        int nEntries;
        List projelements = this.fContainersList.getElements();
        List cpelements = this.fCPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int i = nEntries - 1;
        while (i >= 0) {
            CPElement cpe = (CPElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                lastRemovePos = i;
            }
            --i;
        }
        cpelements.addAll(lastRemovePos, projelements);
        if (lastRemovePos != nEntries || !projelements.isEmpty()) {
            this.fCPathList.setElements(cpelements);
        }
    }

    private CPElement[] openContainerSelectionDialog(CPElement existing) {
        IContainerEntry[] created;
        String title;
        IContainerEntry elem = null;
        if (existing == null) {
            title = CPathEntryMessages.getString("ContainerEntryPage.ContainerDialog.new.title");
        } else {
            title = CPathEntryMessages.getString("ContainerEntryPage.ContainerDialog.edit.title");
            elem = (IContainerEntry)existing.getPathEntry();
        }
        CPathContainerWizard wizard = new CPathContainerWizard(elem, (ICElement)this.fCurrCProject, this.getRawClasspath());
        wizard.setWindowTitle(title);
        if (CPathContainerWizard.openWizard(this.getShell(), wizard) == 0 && (created = wizard.getContainers()) != null) {
            CPElement[] res = new CPElement[created.length];
            int i = 0;
            while (i < res.length) {
                res[i] = new CPElement(this.fCurrCProject, 32, created[i].getPath(), null);
                ++i;
            }
            return res;
        }
        return null;
    }

    private IPathEntry[] getRawClasspath() {
        IPathEntry[] currEntries = new IPathEntry[this.fCPathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            CPElement curr = (CPElement)this.fCPathList.getElement(i);
            currEntries[i] = curr.getPathEntry();
            ++i;
        }
        return currEntries;
    }

    public boolean isEntryKind(int kind) {
        return kind == 32;
    }

    public List getSelection() {
        return this.fContainersList.getSelectedElements();
    }

    public void setSelection(List selElements) {
        this.fContainersList.selectElements((ISelection)new StructuredSelection(selElements));
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
    }

    public void performDefaults() {
    }

    private class ContainersAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        ContainersAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            CPathContainerEntryPage.this.containerPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            CPathContainerEntryPage.this.containerPageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            CPathContainerEntryPage.this.containerPageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            CPathContainerEntryPage.this.containerPageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPElement) {
                return ((CPElement)element).getChildren();
            }
            if (element instanceof CPElementGroup) {
                return ((CPElementGroup)element).getChildren();
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPElementAttribute) {
                return ((CPElementAttribute)element).getParent();
            }
            if (element instanceof CPElementGroup) {
                return ((CPElementGroup)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPElementGroup) {
                return true;
            }
            if (element instanceof CPElement) {
                return ((CPElement)element).getChildren().length != 0;
            }
            return false;
        }

        public void dialogFieldChanged(DialogField field) {
            CPathContainerEntryPage.this.containerPageDialogFieldChanged(field);
        }
    }
}

