/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dnd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.dnd.TransferDragSourceListener;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceTransferDragAdapter
implements TransferDragSourceListener {
    private final ISelectionProvider provider;
    static /* synthetic */ Class class$0;

    public ResourceTransferDragAdapter(ISelectionProvider provider) {
        this.provider = provider;
        Assert.isNotNull((Object)provider);
    }

    public Transfer getTransfer() {
        return ResourceTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent event) {
        event.doit = this.getSelectedResources().length > 0;
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.getSelectedResources();
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.doit && event.detail == 2) {
            IResource[] resources = this.getSelectedResources();
            if (resources.length == 0) {
                return;
            }
            DragSource dragSource = (DragSource)event.widget;
            Control control = dragSource.getControl();
            Shell shell = control.getShell();
            String title = CUIMessages.getString("Drag.move.problem.title");
            String message = CUIMessages.getString("Drag.move.problem.message");
            ReadOnlyStateChecker checker = new ReadOnlyStateChecker(shell, title, message);
            resources = checker.checkReadOnlyResources(resources);
            int i = 0;
            while (i < resources.length) {
                try {
                    resources[i].delete(3, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    private IResource[] getSelectedResources() {
        ArrayList<IResource> resources = Collections.EMPTY_LIST;
        ISelection selection = this.provider.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            resources = new ArrayList<IResource>(structured.size());
            Iterator iterator = structured.iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                IResource resource = null;
                if (element instanceof IResource) {
                    resource = (IResource)element;
                } else if (element instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)element;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    resource = (IResource)adaptable.getAdapter((Class)clazz);
                }
                if (resource == null) continue;
                resources.add(resource);
            }
        }
        IResource[] result = new IResource[resources.size()];
        resources.toArray(result);
        return result;
    }
}

