/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.ui.CFileElementWorkingCopy;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.CMarkerAnnotation;
import org.eclipse.cdt.internal.ui.editor.CStorageDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.ICAnnotation;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.editor.TranslationUnitAnnotationModelEvent;
import org.eclipse.cdt.internal.ui.text.IProblemRequestorExtension;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class CDocumentProvider
extends TextFileDocumentProvider {
    private static final String HANDLE_TEMPORARY_PROBLEMS = "handleTemporaryProblems";
    private boolean fIsAboutToSave = false;
    private IPropertyChangeListener fPropertyListener;
    private GlobalAnnotationModelListener fGlobalAnnotationModelListener;

    public CDocumentProvider() {
        this.setParentDocumentProvider((IDocumentProvider)new TextFileDocumentProvider((IDocumentProvider)new CStorageDocumentProvider()));
        this.fGlobalAnnotationModelListener = new GlobalAnnotationModelListener();
        this.fPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (CDocumentProvider.HANDLE_TEMPORARY_PROBLEMS.equals(event.getProperty())) {
                    CDocumentProvider.this.enableHandlingTemporaryProblems();
                }
            }
        };
        CUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
    }

    protected ITranslationUnit createTranslationUnit(IFile file) {
        ICElement element = CoreModel.getDefault().create(file);
        if (element instanceof ITranslationUnit) {
            return (ITranslationUnit)element;
        }
        return null;
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new TranslationUnitInfo();
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new TranslationUnitAnnotationModel((IResource)file);
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        Object input;
        ITranslationUnit original = null;
        if (element instanceof IFileEditorInput) {
            input = (IFileEditorInput)element;
            original = this.createTranslationUnit(input.getFile());
        } else if (element instanceof ITranslationUnitEditorInput) {
            input = (ITranslationUnitEditorInput)element;
            original = input.getTranslationUnit();
        }
        if (original == null) {
            return null;
        }
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (!(info instanceof TranslationUnitInfo)) {
            return null;
        }
        TranslationUnitInfo tuInfo = (TranslationUnitInfo)info;
        this.setUpSynchronization(tuInfo);
        IProblemRequestor requestor = tuInfo.fModel instanceof IProblemRequestor ? (IProblemRequestor)tuInfo.fModel : null;
        CFileElementWorkingCopy copy = null;
        if (element instanceof IFileEditorInput) {
            IBufferFactory factory = CUIPlugin.getDefault().getBufferFactory();
            copy = original.getSharedWorkingCopy(this.getProgressMonitor(), factory, requestor);
        } else if (element instanceof ITranslationUnitEditorInput) {
            copy = new CFileElementWorkingCopy(original);
        }
        tuInfo.fCopy = copy;
        if (tuInfo.fModel instanceof TranslationUnitAnnotationModel) {
            TranslationUnitAnnotationModel model = (TranslationUnitAnnotationModel)tuInfo.fModel;
            model.setTranslationUnit((ITranslationUnit)tuInfo.fCopy);
        }
        if (tuInfo.fModel != null) {
            tuInfo.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
        }
        if (requestor instanceof IProblemRequestorExtension) {
            IProblemRequestorExtension extension = (IProblemRequestorExtension)requestor;
            extension.setIsActive(this.isHandlingTemporaryProblems());
        }
        return tuInfo;
    }

    private void setUpSynchronization(TranslationUnitInfo cuInfo) {
        IDocument document = cuInfo.fTextFileBuffer.getDocument();
        IAnnotationModel model = cuInfo.fModel;
        if (document instanceof ISynchronizable && model instanceof ISynchronizable) {
            Object lock = ((ISynchronizable)document).getLockObject();
            ((ISynchronizable)model).setLockObject(lock);
        }
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        if (info instanceof TranslationUnitInfo) {
            TranslationUnitInfo tuInfo = (TranslationUnitInfo)info;
            tuInfo.fCopy.destroy();
            if (tuInfo.fModel != null) {
                tuInfo.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
            }
        }
        super.disposeFileInfo(element, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commitWorkingCopy(IProgressMonitor monitor, Object element, TranslationUnitInfo info, boolean overwrite) throws CoreException {
        IWorkingCopy iWorkingCopy = info.fCopy;
        synchronized (iWorkingCopy) {
            info.fCopy.reconcile();
        }
        IDocument document = info.fTextFileBuffer.getDocument();
        IResource resource = info.fCopy.getResource();
        if (resource instanceof IFile && !resource.exists()) {
            this.createFileFromDocument(monitor, (IFile)resource, document);
            return;
        }
        try {
            try {
                this.fIsAboutToSave = true;
                this.commitFileBuffer(monitor, info, overwrite);
            }
            catch (CoreException x) {
                this.fireElementStateChangeFailed(element);
                throw x;
            }
            catch (RuntimeException x) {
                this.fireElementStateChangeFailed(element);
                throw x;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.fIsAboutToSave = false;
            throw throwable;
        }
        {
            Object var8_11 = null;
            this.fIsAboutToSave = false;
            return;
        }
    }

    protected TextFileDocumentProvider.DocumentProviderOperation createSaveOperation(final Object element, IDocument document, final boolean overwrite) throws CoreException {
        final TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof TranslationUnitInfo) {
            return new TextFileDocumentProvider.DocumentProviderOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    CDocumentProvider.this.commitWorkingCopy(monitor, element, (TranslationUnitInfo)info, overwrite);
                }

                public ISchedulingRule getSchedulingRule() {
                    if (info.fElement instanceof IFileEditorInput) {
                        IFile file = ((IFileEditorInput)info.fElement).getFile();
                        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
                        if (file == null || !file.exists()) {
                            return ruleFactory.createRule((IResource)file);
                        }
                        return ruleFactory.modifyRule((IResource)file);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected boolean isHandlingTemporaryProblems() {
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(HANDLE_TEMPORARY_PROBLEMS);
    }

    protected void enableHandlingTemporaryProblems() {
        boolean enable = this.isHandlingTemporaryProblems();
        Iterator iter = this.getFileInfosIterator();
        while (iter.hasNext()) {
            TextFileDocumentProvider.FileInfo info = (TextFileDocumentProvider.FileInfo)iter.next();
            if (!(info.fModel instanceof IProblemRequestorExtension)) continue;
            IProblemRequestorExtension extension = (IProblemRequestorExtension)info.fModel;
            extension.setIsActive(enable);
        }
    }

    public void addGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.addListener(listener);
    }

    public void removeGlobalAnnotationModelListener(IAnnotationModelListener listener) {
        this.fGlobalAnnotationModelListener.removeListener(listener);
    }

    public IWorkingCopy getWorkingCopy(Object element) {
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(element);
        if (fileInfo instanceof TranslationUnitInfo) {
            TranslationUnitInfo info = (TranslationUnitInfo)fileInfo;
            return info.fCopy;
        }
        return null;
    }

    public void shutdown() {
        Iterator e = this.getConnectedElementsIterator();
        while (e.hasNext()) {
            this.disconnect(e.next());
        }
    }

    public IResource getUnderlyingResource(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return input.getFile();
        }
        return null;
    }

    public void saveDocumentContent(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (!this.fIsAboutToSave) {
            return;
        }
        super.saveDocument(monitor, element, document, overwrite);
    }

    public ILineTracker createLineTracker(Object element) {
        return new DefaultLineTracker();
    }

    protected static class TranslationUnitInfo
    extends TextFileDocumentProvider.FileInfo {
        public IWorkingCopy fCopy;

        protected TranslationUnitInfo() {
        }
    }

    protected static class ProblemAnnotation
    extends Annotation
    implements ICAnnotation,
    IAnnotationPresentation {
        private static final String SPELLING_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.spelling";
        private static final int INFO_LAYER;
        private static final int WARNING_LAYER;
        private static final int ERROR_LAYER;
        private static Image fgQuickFixImage;
        private static Image fgQuickFixErrorImage;
        private static boolean fgQuickFixImagesInitialized;
        private ITranslationUnit fTranslationUnit;
        private List fOverlaids;
        private IProblem fProblem;
        private Image fImage;
        private boolean fQuickFixImagesInitialized = false;
        private int fLayer = 0;

        static {
            AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
            INFO_LAYER = ProblemAnnotation.computeLayer("org.eclipse.cdt.ui.info", lookup);
            WARNING_LAYER = ProblemAnnotation.computeLayer("org.eclipse.cdt.ui.warning", lookup);
            ERROR_LAYER = ProblemAnnotation.computeLayer("org.eclipse.cdt.ui.error", lookup);
            fgQuickFixImagesInitialized = false;
        }

        private static int computeLayer(String annotationType, AnnotationPreferenceLookup lookup) {
            Annotation annotation = new Annotation(annotationType, false, null);
            AnnotationPreference preference = lookup.getAnnotationPreference(annotation);
            if (preference != null) {
                return preference.getPresentationLayer() + 1;
            }
            return 1;
        }

        public ProblemAnnotation(IProblem problem, ITranslationUnit cu) {
            this.fProblem = problem;
            this.fTranslationUnit = cu;
            if (this.fProblem.isWarning()) {
                this.setType("org.eclipse.cdt.ui.warning");
                this.fLayer = WARNING_LAYER;
            } else if (this.fProblem.isError()) {
                this.setType("org.eclipse.cdt.ui.error");
                this.fLayer = ERROR_LAYER;
            } else {
                this.setType("org.eclipse.cdt.ui.info");
                this.fLayer = INFO_LAYER;
            }
        }

        public int getLayer() {
            return this.fLayer;
        }

        private void initializeImages() {
            if (!this.fQuickFixImagesInitialized) {
                if (this.isProblem() && this.indicateQuixFixableProblems()) {
                    if (!fgQuickFixImagesInitialized) {
                        fgQuickFixImage = CPluginImages.get("org.eclipse.cdt.ui.quickfix_warning_obj.gif");
                        fgQuickFixErrorImage = CPluginImages.get("org.eclipse.cdt.ui.quickfix_error_obj.gif");
                        fgQuickFixImagesInitialized = true;
                    }
                    this.fImage = "org.eclipse.cdt.ui.error".equals(this.getType()) ? fgQuickFixErrorImage : fgQuickFixImage;
                }
                this.fQuickFixImagesInitialized = true;
            }
        }

        private boolean indicateQuixFixableProblems() {
            return PreferenceConstants.getPreferenceStore().getBoolean("CEditor.ShowTemporaryProblem");
        }

        public void paint(GC gc, Canvas canvas, Rectangle r) {
            this.initializeImages();
            if (this.fImage != null) {
                ImageUtilities.drawImage((Image)this.fImage, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
            }
        }

        public Image getImage(Display display) {
            this.initializeImages();
            return this.fImage;
        }

        public String getText() {
            return this.fProblem.getMessage();
        }

        public String[] getArguments() {
            String[] stringArray;
            if (this.isProblem()) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.fProblem.getArguments();
            } else {
                stringArray = null;
            }
            return stringArray;
        }

        public int getId() {
            return this.fProblem.getID();
        }

        public boolean isProblem() {
            String type = this.getType();
            return "org.eclipse.cdt.ui.warning".equals(type) || "org.eclipse.cdt.ui.error".equals(type) || SPELLING_ANNOTATION_TYPE.equals(type);
        }

        public boolean hasOverlay() {
            return false;
        }

        public ICAnnotation getOverlay() {
            return null;
        }

        public void addOverlaid(ICAnnotation annotation) {
            if (this.fOverlaids == null) {
                this.fOverlaids = new ArrayList(1);
            }
            this.fOverlaids.add(annotation);
        }

        public void removeOverlaid(ICAnnotation annotation) {
            if (this.fOverlaids != null) {
                this.fOverlaids.remove(annotation);
                if (this.fOverlaids.size() == 0) {
                    this.fOverlaids = null;
                }
            }
        }

        public Iterator getOverlaidIterator() {
            if (this.fOverlaids != null) {
                return this.fOverlaids.iterator();
            }
            return null;
        }

        public ITranslationUnit getTranslationUnit() {
            return this.fTranslationUnit;
        }
    }

    protected static class ReverseMap {
        private List fList = new ArrayList(2);
        private int fAnchor = 0;

        public Object get(Position position) {
            Entry entry;
            int length = this.fList.size();
            int i = this.fAnchor;
            while (i < length) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            i = 0;
            while (i < this.fAnchor) {
                entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            return null;
        }

        private int getIndex(Position position) {
            int length = this.fList.size();
            int i = 0;
            while (i < length) {
                Entry entry = (Entry)this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void put(Position position, Object value) {
            int index = this.getIndex(position);
            if (index == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = value;
                this.fList.add(entry);
            } else {
                Entry entry = (Entry)this.fList.get(index);
                entry.fValue = value;
            }
        }

        public void remove(Position position) {
            int index = this.getIndex(position);
            if (index > -1) {
                this.fList.remove(index);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }

    protected static class TranslationUnitAnnotationModel
    extends ResourceMarkerAnnotationModel
    implements IProblemRequestor,
    IProblemRequestorExtension {
        private ThreadLocal fProblemRequestorState = new ThreadLocal();
        private int fStateCount = 0;
        private ITranslationUnit fTranslationUnit;
        private List fGeneratedAnnotations;
        private IProgressMonitor fProgressMonitor;
        private boolean fIsActive = false;
        private ReverseMap fReverseMap = new ReverseMap();
        private List fPreviouslyOverlaid = null;
        private List fCurrentlyOverlaid = new ArrayList();

        public TranslationUnitAnnotationModel(IResource resource) {
            super(resource);
        }

        public void setTranslationUnit(ITranslationUnit unit) {
            this.fTranslationUnit = unit;
        }

        protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
            String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
            if (markerType != null && markerType.startsWith("org.eclipse.cdt")) {
                return new CMarkerAnnotation(marker, null);
            }
            return super.createMarkerAnnotation(marker);
        }

        protected Position createPositionFromMarker(IMarker marker) {
            int line;
            int end;
            int start = MarkerUtilities.getCharStart((IMarker)marker);
            if (start > (end = MarkerUtilities.getCharEnd((IMarker)marker))) {
                end = start + end;
                start = end - start;
                end -= start;
            }
            if (start == -1 && end == -1 && (line = MarkerUtilities.getLineNumber((IMarker)marker)) > 0 && this.fDocument != null) {
                try {
                    start = this.fDocument.getLineOffset(line - 1);
                    String ld = this.fDocument.getLineDelimiter(line - 1);
                    int lineDelimiterLegnth = ld != null ? ld.length() : 0;
                    end = this.fDocument.getLineLength(line - 1) + start - lineDelimiterLegnth;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (start > -1 && end > -1) {
                return new Position(start, end - start);
            }
            return null;
        }

        protected AnnotationModelEvent createAnnotationModelEvent() {
            return new TranslationUnitAnnotationModelEvent((IAnnotationModel)this, this.getResource());
        }

        protected Position createPositionFromProblem(IProblem problem) {
            int start = problem.getSourceStart();
            if (start < 0) {
                return null;
            }
            int length = problem.getSourceEnd() - problem.getSourceStart() + 1;
            if (length < 0) {
                return null;
            }
            return new Position(start, length);
        }

        public void beginReporting() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state == null) {
                this.internalBeginReporting(false);
            }
        }

        public void beginReportingSequence() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state == null) {
                this.internalBeginReporting(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalBeginReporting(boolean insideReportingSequence) {
            if (this.fTranslationUnit != null && this.fTranslationUnit.getCProject().isOnSourceRoot(this.fTranslationUnit.getResource())) {
                ProblemRequestorState state = new ProblemRequestorState();
                state.fInsideReportingSequence = insideReportingSequence;
                state.fReportedProblems = new ArrayList();
                Object object = this.getLockObject();
                synchronized (object) {
                    this.fProblemRequestorState.set(state);
                    ++this.fStateCount;
                }
            }
        }

        public void acceptProblem(IProblem problem) {
            ProblemRequestorState state;
            if (this.isActive() && (state = (ProblemRequestorState)this.fProblemRequestorState.get()) != null) {
                state.fReportedProblems.add(problem);
            }
        }

        public void endReporting() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state != null && !state.fInsideReportingSequence) {
                this.internalEndReporting(state);
            }
        }

        public void endReportingSequence() {
            ProblemRequestorState state = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (state != null && state.fInsideReportingSequence) {
                this.internalEndReporting(state);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalEndReporting(ProblemRequestorState state) {
            int stateCount = 0;
            Object object = this.getLockObject();
            synchronized (object) {
                --this.fStateCount;
                stateCount = this.fStateCount;
                this.fProblemRequestorState.set(null);
            }
            if (stateCount == 0 && this.isActive()) {
                this.reportProblems(state.fReportedProblems);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportProblems(List reportedProblems) {
            if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                return;
            }
            boolean temporaryProblemsChanged = false;
            Object object = this.getLockObject();
            synchronized (object) {
                boolean isCanceled = false;
                this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
                this.fCurrentlyOverlaid = new ArrayList();
                if (this.fGeneratedAnnotations.size() > 0) {
                    temporaryProblemsChanged = true;
                    this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                    this.fGeneratedAnnotations.clear();
                }
                if (reportedProblems != null && reportedProblems.size() > 0) {
                    Iterator e = reportedProblems.iterator();
                    while (e.hasNext()) {
                        if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                            isCanceled = true;
                            break;
                        }
                        IProblem problem = (IProblem)e.next();
                        Position position = this.createPositionFromProblem(problem);
                        if (position == null) continue;
                        try {
                            ProblemAnnotation annotation = new ProblemAnnotation(problem, this.fTranslationUnit);
                            this.overlayMarkers(position, annotation);
                            this.addAnnotation(annotation, position, false);
                            this.fGeneratedAnnotations.add(annotation);
                            temporaryProblemsChanged = true;
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
                this.removeMarkerOverlays(isCanceled);
                this.fPreviouslyOverlaid = null;
            }
            if (temporaryProblemsChanged) {
                this.fireModelChanged();
            }
        }

        private void removeMarkerOverlays(boolean isCanceled) {
            if (isCanceled) {
                this.fCurrentlyOverlaid.addAll(this.fPreviouslyOverlaid);
            } else if (this.fPreviouslyOverlaid != null) {
                Iterator e = this.fPreviouslyOverlaid.iterator();
                while (e.hasNext()) {
                    CMarkerAnnotation annotation = (CMarkerAnnotation)e.next();
                    annotation.setOverlay(null);
                }
            }
        }

        private void setOverlay(Object value, ProblemAnnotation problemAnnotation) {
            CMarkerAnnotation annotation;
            if (value instanceof CMarkerAnnotation && (annotation = (CMarkerAnnotation)value).isProblem()) {
                annotation.setOverlay(problemAnnotation);
                this.fPreviouslyOverlaid.remove(annotation);
                this.fCurrentlyOverlaid.add(annotation);
            }
        }

        private void overlayMarkers(Position position, ProblemAnnotation problemAnnotation) {
            Object value = this.getAnnotations(position);
            if (value instanceof List) {
                List list = (List)value;
                Iterator e = list.iterator();
                while (e.hasNext()) {
                    this.setOverlay(e.next(), problemAnnotation);
                }
            } else {
                this.setOverlay(value, problemAnnotation);
            }
        }

        private void startCollectingProblems() {
            this.fGeneratedAnnotations = new ArrayList();
        }

        private void stopCollectingProblems() {
            if (this.fGeneratedAnnotations != null) {
                this.removeAnnotations(this.fGeneratedAnnotations, true, true);
            }
            this.fGeneratedAnnotations = null;
        }

        public boolean isActive() {
            return this.fIsActive;
        }

        public void setProgressMonitor(IProgressMonitor monitor) {
            this.fProgressMonitor = monitor;
        }

        public void setIsActive(boolean isActive) {
            if (this.fIsActive != isActive) {
                this.fIsActive = isActive;
                if (this.fIsActive) {
                    this.startCollectingProblems();
                } else {
                    this.stopCollectingProblems();
                }
            }
        }

        private Object getAnnotations(Position position) {
            return this.fReverseMap.get(position);
        }

        protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
            super.addAnnotation(annotation, position, fireModelChanged);
            Object cached = this.fReverseMap.get(position);
            if (cached == null) {
                this.fReverseMap.put(position, annotation);
            } else if (cached instanceof List) {
                List list = (List)cached;
                list.add(annotation);
            } else if (cached instanceof Annotation) {
                ArrayList<Object> list = new ArrayList<Object>(2);
                list.add(cached);
                list.add(annotation);
                this.fReverseMap.put(position, list);
            }
        }

        protected void removeAllAnnotations(boolean fireModelChanged) {
            super.removeAllAnnotations(fireModelChanged);
            this.fReverseMap.clear();
        }

        protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
            Position position = this.getPosition(annotation);
            Object cached = this.fReverseMap.get(position);
            if (cached instanceof List) {
                List list = (List)cached;
                list.remove(annotation);
                if (list.size() == 1) {
                    this.fReverseMap.put(position, list.get(0));
                    list.clear();
                }
            } else if (cached instanceof Annotation) {
                this.fReverseMap.remove(position);
            }
            super.removeAnnotation(annotation, fireModelChanged);
        }

        private static class ProblemRequestorState {
            boolean fInsideReportingSequence = false;
            List fReportedProblems;

            ProblemRequestorState() {
            }
        }
    }

    protected static class GlobalAnnotationModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        private ArrayList fListenerList = new ArrayList();

        public void modelChanged(IAnnotationModel model) {
            Object[] listeners = this.fListenerList.toArray();
            int i = 0;
            while (i < listeners.length) {
                ((IAnnotationModelListener)listeners[i]).modelChanged(model);
                ++i;
            }
        }

        public void modelChanged(AnnotationModelEvent event) {
            Object[] listeners = this.fListenerList.toArray();
            int i = 0;
            while (i < listeners.length) {
                Object curr = listeners[i];
                if (curr instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)curr).modelChanged(event);
                }
                ++i;
            }
        }

        public void addListener(IAnnotationModelListener listener) {
            this.fListenerList.add(listener);
        }

        public void removeListener(IAnnotationModelListener listener) {
            this.fListenerList.remove(listener);
        }
    }
}

