/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.indexview;

import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.dom.PDOM;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMember;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPNamespace;
import org.eclipse.cdt.internal.ui.indexview.DiscardExternalDefsAction;
import org.eclipse.cdt.internal.ui.indexview.FindDeclarationsAction;
import org.eclipse.cdt.internal.ui.indexview.FindReferencesAction;
import org.eclipse.cdt.internal.ui.indexview.IndexAction;
import org.eclipse.cdt.internal.ui.indexview.LinkageCache;
import org.eclipse.cdt.internal.ui.indexview.OpenDefinitionAction;
import org.eclipse.cdt.internal.ui.indexview.RebuildIndexAction;
import org.eclipse.cdt.internal.ui.indexview.ToggleLinkingAction;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class IndexView
extends ViewPart
implements PDOMDatabase.IListener {
    private TreeViewer viewer;
    private ToggleLinkingAction toggleLinkingAction;
    private IndexAction rebuildAction;
    private IndexAction discardExternalDefsAction;
    private IndexAction openDefinitionAction;
    private IndexAction findDeclarationsAction;
    private IndexAction findReferencesAction;
    Filter filter = new Filter();
    public boolean isLinking = false;

    public void toggleExternalDefs() {
        this.filter.showExternalDefs = !this.filter.showExternalDefs;
        this.viewer.refresh();
    }

    public void toggleLinking() {
        boolean bl = this.isLinking = !this.isLinking;
        if (this.isLinking) {
            this.openDefinitionAction.run();
        }
    }

    void handleSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection cfr_ignored_0 = (IStructuredSelection)event.getSelection();
        if (this.isLinking) {
            this.openDefinitionAction.run();
        }
    }

    static PDOMBinding[] trim(PDOMBinding[] binding) {
        int len = 0;
        while (len < binding.length) {
            if (binding[len] == null) {
                PDOMBinding[] newBinding = new PDOMBinding[len];
                System.arraycopy(binding, 0, newBinding, 0, len);
                return newBinding;
            }
            ++len;
        }
        return binding;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new IndexContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new IndexLabelProvider());
        ICModel model = CoreModel.getDefault().getCModel();
        this.viewer.setInput((Object)model);
        try {
            ICProject[] cprojects = model.getCProjects();
            int n = 0;
            int i = 0;
            while (i < cprojects.length) {
                PDOMDatabase pdom = (PDOMDatabase)PDOM.getPDOM((IProject)cprojects[i].getProject());
                if (pdom != null) {
                    ++n;
                    pdom.addListener((PDOMDatabase.IListener)this);
                }
                ++i;
            }
            this.viewer.setChildCount((Object)model, n);
        }
        catch (CModelException e) {
            CUIPlugin.getDefault().log(e);
        }
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            private void hideMenuItems(IMenuManager manager) {
            }

            public void menuAboutToShow(IMenuManager manager) {
                IndexView.this.fillContextMenu(manager);
                this.hideMenuItems(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IndexView.this.handleSelectionChanged(event);
            }
        });
    }

    private void makeActions() {
        this.rebuildAction = new RebuildIndexAction(this.viewer);
        this.discardExternalDefsAction = new DiscardExternalDefsAction(this.viewer, this);
        this.toggleLinkingAction = new ToggleLinkingAction(this);
        this.openDefinitionAction = new OpenDefinitionAction(this.viewer);
        this.findDeclarationsAction = new FindDeclarationsAction(this.viewer);
        this.findReferencesAction = new FindReferencesAction(this.viewer);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IndexView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.rebuildAction.valid()) {
            manager.add((IAction)this.rebuildAction);
        }
        if (this.discardExternalDefsAction.valid()) {
            manager.add((IAction)this.discardExternalDefsAction);
        }
        if (this.openDefinitionAction.valid()) {
            manager.add((IAction)this.openDefinitionAction);
        }
        if (this.findDeclarationsAction.valid()) {
            manager.add((IAction)this.findDeclarationsAction);
        }
        if (this.findReferencesAction.valid()) {
            manager.add((IAction)this.findReferencesAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IndexView.this.openDefinitionAction.run();
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.toggleLinkingAction);
        manager.add((IAction)this.discardExternalDefsAction);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void handleChange(PDOMDatabase pdom) {
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IndexView.this.viewer.refresh();
            }
        });
    }

    private static class Filter {
        public boolean showExternalDefs = false;

        Filter() {
        }

        public boolean accept(PDOMBinding binding) {
            if (this.showExternalDefs) {
                return true;
            }
            return Filter.isLocalToWorkspace(binding);
        }

        private static boolean isLocalToWorkspace(PDOMBinding binding) {
            try {
                PDOMName name = binding.getFirstReference();
                if (name == null) {
                    name = binding.getFirstDeclaration();
                }
                if (name == null) {
                    name = binding.getFirstDefinition();
                }
                if (name == null) {
                    return false;
                }
                IASTFileLocation location = name.getFileLocation();
                Path path = new Path(location.getFileName());
                IFile input = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                return input != null;
            }
            catch (CoreException e) {
                CUIPlugin.getDefault().log(e);
                return false;
            }
        }
    }

    private static class Counter
    implements IBTreeVisitor {
        int count;
        PDOMDatabase pdom;

        public Counter(PDOMDatabase pdom) {
            this.pdom = pdom;
        }

        public int compare(int record) throws CoreException {
            return 1;
        }

        public boolean visit(int record) throws CoreException {
            if (record != 0 && !PDOMBinding.isOrphaned((PDOMDatabase)this.pdom, (int)record)) {
                ++this.count;
            }
            return true;
        }
    }

    private static class Children
    implements IBTreeVisitor {
        final PDOMDatabase pdom;
        final PDOMBinding[] bindings;
        final Filter filter;
        int index;

        public Children(PDOMDatabase pdom, PDOMBinding[] bindings, Filter filter) {
            this.pdom = pdom;
            this.bindings = bindings;
            this.filter = filter;
        }

        public int compare(int record) throws CoreException {
            return 1;
        }

        public boolean visit(int record) throws CoreException {
            if (record == 0 || PDOMBinding.isOrphaned((PDOMDatabase)this.pdom, (int)record)) {
                return true;
            }
            PDOMBinding binding = this.pdom.getBinding(record);
            if (this.filter.accept(binding)) {
                this.bindings[this.index++] = binding;
            }
            return true;
        }
    }

    private class IndexContentProvider
    implements ITreeContentProvider {
        IndexContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ICProject) {
                try {
                    PDOMDatabase pdom = (PDOMDatabase)PDOM.getPDOM((IProject)((ICProject)parentElement).getProject());
                    int n = 0;
                    PDOMLinkage linkage = pdom.getFirstLinkage();
                    while (linkage != null) {
                        ++n;
                        linkage = linkage.getNextLinkage();
                    }
                    Object[] linkages = new PDOMLinkage[n];
                    int i = 0;
                    PDOMLinkage linkage2 = pdom.getFirstLinkage();
                    while (linkage2 != null) {
                        linkages[i++] = linkage2;
                        linkage2 = linkage2.getNextLinkage();
                    }
                    return linkages;
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e);
                }
            } else if (parentElement instanceof PDOMLinkage) {
                try {
                    PDOMLinkage linkage = (PDOMLinkage)parentElement;
                    PDOMDatabase pdom = linkage.getPDOM();
                    Counter counter = new Counter(pdom);
                    linkage.getIndex().visit((IBTreeVisitor)counter);
                    PDOMBinding[] bindings = new PDOMBinding[counter.count];
                    Children children = new Children(pdom, bindings, IndexView.this.filter);
                    linkage.getIndex().visit((IBTreeVisitor)children);
                    return IndexView.trim(bindings);
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e);
                }
            } else if (parentElement instanceof PDOMCPPNamespace) {
                try {
                    PDOMCPPNamespace namespace = (PDOMCPPNamespace)parentElement;
                    PDOMDatabase pdom = namespace.getPDOM();
                    Counter counter = new Counter(pdom);
                    namespace.getIndex().visit((IBTreeVisitor)counter);
                    PDOMBinding[] bindings = new PDOMBinding[counter.count];
                    Children children = new Children(pdom, bindings, IndexView.this.filter);
                    namespace.getIndex().visit((IBTreeVisitor)children);
                    return IndexView.trim(bindings);
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e);
                }
            } else if (parentElement instanceof PDOMMemberOwner) {
                try {
                    PDOMMemberOwner owner = (PDOMMemberOwner)parentElement;
                    int n = 0;
                    PDOMMember member = owner.getFirstMember();
                    while (member != null) {
                        ++n;
                        member = member.getNextMember();
                    }
                    Object[] members = new PDOMMember[n];
                    int i = 0;
                    PDOMMember member2 = owner.getFirstMember();
                    while (member2 != null) {
                        members[i++] = member2;
                        member2 = member2.getNextMember();
                    }
                    return members;
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e);
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ICProject) {
                IPDOM ipdom = PDOM.getPDOM((IProject)((ICProject)element).getProject());
                if (ipdom == null || !(ipdom instanceof PDOMDatabase)) {
                    return false;
                }
                try {
                    PDOMDatabase pdom = (PDOMDatabase)ipdom;
                    return pdom.getFirstLinkage() != null;
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e);
                }
            } else {
                if (element instanceof PDOMLinkage || element instanceof PDOMCPPNamespace) {
                    return true;
                }
                if (element instanceof PDOMMemberOwner) {
                    try {
                        PDOMMemberOwner owner = (PDOMMemberOwner)element;
                        return owner.getFirstMember() != null;
                    }
                    catch (CoreException e) {
                        CUIPlugin.getDefault().log(e);
                    }
                }
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            try {
                if (inputElement instanceof ICModel) {
                    ICModel model = (ICModel)inputElement;
                    return model.getCProjects();
                }
            }
            catch (CModelException cModelException) {}
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class IndexLabelProvider
    extends LabelProvider {
        IndexLabelProvider() {
        }

        public String getText(Object element) {
            if (element == null) {
                return "null :(";
            }
            if (element instanceof PDOMNode) {
                try {
                    return ((PDOMNode)element).getName();
                }
                catch (CoreException e) {
                    return e.getMessage();
                }
            }
            if (element instanceof LinkageCache) {
                try {
                    return ((LinkageCache)element).getName();
                }
                catch (CoreException e) {
                    return e.getMessage();
                }
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IVariable) {
                return CUIPlugin.getImageDescriptorRegistry().get(CElementImageProvider.getVariableImageDescriptor());
            }
            if (element instanceof IFunction) {
                return CUIPlugin.getImageDescriptorRegistry().get(CElementImageProvider.getFunctionImageDescriptor());
            }
            if (element instanceof ICPPClassType) {
                return CUIPlugin.getImageDescriptorRegistry().get(CElementImageProvider.getClassImageDescriptor());
            }
            if (element instanceof ICompositeType) {
                return CUIPlugin.getImageDescriptorRegistry().get(CElementImageProvider.getStructImageDescriptor());
            }
            if (element instanceof ICPPNamespace) {
                return CUIPlugin.getImageDescriptorRegistry().get(CElementImageProvider.getNamespaceImageDescriptor());
            }
            if (element instanceof IBinding) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            }
            if (element instanceof ICProject) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

