/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.indexview;

import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.core.runtime.CoreException;

public class LinkageCache {
    private final PDOMDatabase pdom;
    private final PDOMLinkage linkage;
    private int[] cache;

    public LinkageCache(PDOMDatabase pdom, PDOMLinkage linkage) throws CoreException {
        this.pdom = pdom;
        this.linkage = linkage;
        Counter counter = new Counter(pdom);
        linkage.getIndex().visit((IBTreeVisitor)counter);
        this.cache = new int[counter.count];
        FillCache fillCache = new FillCache(pdom, this.cache);
        linkage.getIndex().visit((IBTreeVisitor)fillCache);
    }

    public int getCount() {
        return this.cache.length;
    }

    public PDOMBinding getItem(int index) throws CoreException {
        return this.pdom.getBinding(this.cache[index]);
    }

    public String getName() throws CoreException {
        return this.linkage.getName();
    }

    private static class Counter
    implements IBTreeVisitor {
        int count;
        PDOMDatabase pdom;

        public Counter(PDOMDatabase pdom) {
            this.pdom = pdom;
        }

        public int compare(int record) throws CoreException {
            return 1;
        }

        public boolean visit(int record) throws CoreException {
            if (record != 0 && !PDOMBinding.isOrphaned((PDOMDatabase)this.pdom, (int)record)) {
                ++this.count;
            }
            return true;
        }
    }

    private static class FillCache
    implements IBTreeVisitor {
        final PDOMDatabase pdom;
        final int[] cache;
        int index;

        public FillCache(PDOMDatabase pdom, int[] cache) {
            this.pdom = pdom;
            this.cache = cache;
        }

        public int compare(int record) throws CoreException {
            return 1;
        }

        public boolean visit(int record) throws CoreException {
            if (record == 0 || PDOMBinding.isOrphaned((PDOMDatabase)this.pdom, (int)record)) {
                return true;
            }
            this.cache[this.index++] = record;
            return true;
        }
    }
}

