/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.indexview;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.ui.indexview.IndexAction;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenDefinitionAction
extends IndexAction {
    public OpenDefinitionAction(TreeViewer viewer) {
        super(viewer, CUIPlugin.getResourceString("IndexView.openDefinition.name"));
    }

    public void run() {
        ISelection selection = this.viewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object[] objs = ((IStructuredSelection)selection).toArray();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof PDOMBinding) {
                try {
                    PDOMBinding binding = (PDOMBinding)objs[i];
                    PDOMName name = binding.getFirstDefinition();
                    if (name == null) {
                        name = binding.getFirstDeclaration();
                    }
                    if (name != null) {
                        IEditorPart editor;
                        IASTFileLocation location = name.getFileLocation();
                        Path path = new Path(location.getFileName());
                        IFile input = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                        if (input == null) {
                            input = new FileStorage((IPath)path);
                        }
                        if ((editor = EditorUtility.openInEditor(input)) != null && editor instanceof ITextEditor) {
                            ((ITextEditor)editor).selectAndReveal(location.getNodeOffset(), location.getNodeLength());
                            return;
                        }
                    }
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e);
                }
            }
            ++i;
        }
    }

    public boolean valid() {
        ISelection selection = this.viewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        Object[] objs = ((IStructuredSelection)selection).toArray();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof PDOMBinding) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

