/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.indexview;

import org.eclipse.cdt.core.dom.PDOM;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.pdom.PDOMUpdator;
import org.eclipse.cdt.internal.ui.indexview.IndexAction;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class RebuildIndexAction
extends IndexAction {
    public RebuildIndexAction(TreeViewer viewer) {
        super(viewer, CUIPlugin.getResourceString("IndexView.rebuildIndex.name"));
    }

    public void run() {
        ISelection selection = this.viewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object[] objs = ((IStructuredSelection)selection).toArray();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof ICProject) {
                ICProject cproject = (ICProject)objs[i];
                try {
                    PDOM.deletePDOM((IProject)cproject.getProject());
                    PDOMUpdator job = new PDOMUpdator(cproject, null);
                    job.schedule();
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e);
                }
            }
            ++i;
        }
    }

    public boolean valid() {
        ISelection selection = this.viewer.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        Object[] objs = ((IStructuredSelection)selection).toArray();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] instanceof ICProject) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

