/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.parser.CodeReaderCache;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.cdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CParserPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected OverlayPreferenceStore fOverlayStore;
    private Text bufferTextControl;

    public CParserPreferencePage() {
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
    }

    private OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "CODE_READER_CACHE"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    protected Control createContents(Composite parent) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        result.setLayout((Layout)layout);
        Group bufferGroup = new Group(result, 0);
        bufferGroup.setLayout((Layout)new GridLayout());
        bufferGroup.setLayoutData((Object)new GridData(768));
        bufferGroup.setText(PreferencesMessages.getString("CBufferPreferences.CodeReaderBuffer.CodeReaderBufferGroup"));
        this.bufferTextControl = (Text)this.addTextField((Composite)bufferGroup, PreferencesMessages.getString("CBufferPreferences.CodeReaderBuffer.Size"), 6, 0);
        this.initialize();
        return result;
    }

    private void initialize() {
        this.bufferTextControl.setText(this.fOverlayStore.getString("CODE_READER_CACHE"));
    }

    public void init(IWorkbench workbench) {
    }

    private Control addTextField(Composite composite, String label, int textLimit, int indentation) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        return textControl;
    }

    public boolean performOk() {
        Preferences prefs = CCorePlugin.getDefault().getPluginPreferences();
        String bufferSize = this.bufferTextControl.getText();
        this.fOverlayStore.setValue("CODE_READER_CACHE", bufferSize);
        prefs.setValue("CODE_READER_CACHE", bufferSize);
        ICodeReaderCache cache = CDOM.getInstance().getCodeReaderFactory(0).getCodeReaderCache();
        if (cache instanceof CodeReaderCache) {
            try {
                int size = Integer.parseInt(bufferSize);
                if (size >= 0) {
                    ((CodeReaderCache)cache).setCacheSize(size);
                } else {
                    ((CodeReaderCache)cache).setCacheSize(64);
                    prefs.setValue("CODE_READER_CACHE", 64);
                    this.fOverlayStore.setValue("CODE_READER_CACHE", 64);
                }
            }
            catch (NumberFormatException numberFormatException) {
                ((CodeReaderCache)cache).setCacheSize(64);
                prefs.setValue("CODE_READER_CACHE", 64);
                this.fOverlayStore.setValue("CODE_READER_CACHE", 64);
            }
        }
        this.fOverlayStore.propagate();
        CCorePlugin.getDefault().savePluginPreferences();
        return true;
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault("CODE_READER_CACHE", CodeReaderCache.DEFAULT_CACHE_SIZE_IN_MB_STRING);
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initialize();
        super.performDefaults();
    }
}

