/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextFileChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TranslationUnitChange;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.PseudoCChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.TextEditChangeElement;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

class ChangeElementLabelProvider
extends LabelProvider {
    private int fCElementFlags;
    private CElementLabelProvider fCElementLabelProvider;
    private Map fDescriptorImageMap = new HashMap();
    private boolean fShowQualification = true;

    public ChangeElementLabelProvider(int CElementFlags) {
        this.fCElementFlags = CElementFlags;
        this.fCElementLabelProvider = new CElementLabelProvider(CElementFlags);
    }

    public void setShowQualification(boolean showQualification) {
        this.fShowQualification = showQualification;
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, null);
        this.fireLabelProviderChanged(event);
    }

    public Image getImage(Object object) {
        if (object instanceof DefaultChangeElement) {
            IChange element = ((DefaultChangeElement)object).getChange();
            return this.doGetImage(element);
        }
        if (object instanceof TextEditChangeElement) {
            TextChange.EditChange element = ((TextEditChangeElement)object).getTextEditChange();
            return this.doGetImage(element);
        }
        if (object instanceof PseudoCChangeElement) {
            PseudoCChangeElement element = (PseudoCChangeElement)object;
            return this.fCElementLabelProvider.getImage(element.getCElement());
        }
        return super.getImage(object);
    }

    public String getText(Object object) {
        if (object instanceof DefaultChangeElement) {
            IChange change = ((DefaultChangeElement)object).getChange();
            if (!this.fShowQualification) {
                return change.getName();
            }
            if (change instanceof TextFileChange) {
                IFile file = ((TextFileChange)change).getFile();
                return RefactoringMessages.getFormattedString("PreviewWizardPage.changeElementLabelProvider.textFormat", new String[]{file.getName(), this.getPath(file)});
            }
            return change.getName();
        }
        if (object instanceof TextEditChangeElement) {
            ChangeElement parent;
            TextEditChangeElement element = (TextEditChangeElement)object;
            String result = element.getTextEditChange().getName();
            if ((this.fCElementFlags & 0x800) != 0 && (parent = this.getParent(element)) != null) {
                result = RefactoringMessages.getFormattedString("PreviewWizardPage.changeElementLabelProvider.textFormatEdit", new String[]{this.getText(parent), result});
            }
            return result;
        }
        if (object instanceof PseudoCChangeElement) {
            PseudoCChangeElement element = (PseudoCChangeElement)object;
            return this.fCElementLabelProvider.getText(element.getCElement());
        }
        return super.getText(object);
    }

    public void dispose() {
        Iterator iter = this.fDescriptorImageMap.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        super.dispose();
    }

    private Image doGetImage(Object element) {
        Image image;
        ImageDescriptor descriptor = null;
        if (descriptor == null) {
            descriptor = element instanceof ICompositeChange ? CPluginImages.DESC_OBJS_COMPOSITE_CHANGE : (element instanceof TextEditChangeElement ? CPluginImages.DESC_OBJS_TEXT_EDIT : (element instanceof TranslationUnitChange ? CPluginImages.DESC_OBJS_CU_CHANGE : (element instanceof TextFileChange ? CPluginImages.DESC_OBJS_FILE_CHANGE : CPluginImages.DESC_OBJS_DEFAULT_CHANGE)));
        }
        if ((image = (Image)this.fDescriptorImageMap.get(descriptor)) == null) {
            image = descriptor.createImage();
            this.fDescriptorImageMap.put(descriptor, image);
        }
        return image;
    }

    private String getPath(IFile file) {
        StringBuffer result = new StringBuffer(file.getProject().getName());
        String projectRelativePath = file.getParent().getProjectRelativePath().toString();
        if (projectRelativePath.length() > 0) {
            result.append('/');
            result.append(projectRelativePath);
        }
        return result.toString();
    }

    private ChangeElement getParent(TextEditChangeElement element) {
        ChangeElement parent = element.getParent();
        while (parent != null && !(parent instanceof PseudoCChangeElement) && !(parent instanceof DefaultChangeElement)) {
            parent = parent.getParent();
        }
        return parent;
    }
}

