/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.IChangeExceptionHandler;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ChangeExceptionHandler
implements IChangeExceptionHandler {
    private Shell fParent;

    public ChangeExceptionHandler(Shell parent) {
        Assert.isNotNull((Object)parent);
        this.fParent = parent;
    }

    public void handle(ChangeContext context, IChange change, Exception e) {
        CUIPlugin.getDefault().log(e);
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)((Object)e)).getStatus() : (e.getMessage() == null ? new Status(4, CUIPlugin.getPluginId(), 4, RefactoringMessages.getString("ChangeExceptionHandler.no_details"), (Throwable)e) : new Status(4, CUIPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e));
        final RefactorErrorDialog dialog = new RefactorErrorDialog(this.fParent, RefactoringMessages.getString("ChangeExceptionHandler.refactoring"), RefactoringMessages.getFormattedString("ChangeExceptionHandler.unexpected_exception", new String[]{change.getName()}), (IStatus)status, 7);
        final int[] result = new int[1];
        Runnable runnable = new Runnable(){

            public void run() {
                result[0] = dialog.open();
            }
        };
        this.fParent.getDisplay().syncExec(runnable);
        switch (result[0]) {
            case 0: {
                context.setTryToUndo();
            }
            case 1: {
                throw new ChangeAbortException(e);
            }
        }
    }

    private static class RefactorErrorDialog
    extends ErrorDialog {
        public RefactorErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
            super(parentShell, dialogTitle, message, status, displayMask);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button ok = this.getButton(0);
            ok.setText(RefactoringMessages.getString("ChangeExceptionHandler.undo"));
            Button abort = this.createButton(parent, 1, RefactoringMessages.getString("ChangeExceptionHandler.abort"), true);
            abort.moveBelow((Control)ok);
            abort.setFocus();
        }

        protected Control createMessageArea(Composite parent) {
            Control result = super.createMessageArea(parent);
            new Label(parent, 0);
            Label label = new Label(parent, 0);
            label.setText(RefactoringMessages.getString("ChangeExceptionHandler.button_explanation"));
            label.setLayoutData((Object)new GridData(768));
            RefactorErrorDialog.applyDialogFont((Control)result);
            return result;
        }
    }
}

