/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatusEntry;
import org.eclipse.cdt.internal.ui.refactoring.ListDialog;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringStatusContentProvider;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringStatusEntryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;

public class RefactoringErrorDialogUtil {
    private RefactoringErrorDialogUtil() {
    }

    public static Object open(String dialogTitle, RefactoringStatus status, Shell parentShell) {
        if (status.getEntries().size() == 1) {
            RefactoringStatusEntry entry = (RefactoringStatusEntry)status.getEntries().get(0);
            String message = status.getFirstMessage(4);
            if (entry.getCode() != 1 && entry.getCode() != 2) {
                MessageDialog.openInformation((Shell)parentShell, (String)dialogTitle, (String)message);
                return null;
            }
            if (MessageDialog.openQuestion((Shell)parentShell, (String)dialogTitle, (String)(message = String.valueOf(message) + RefactoringMessages.getString("RefactoringErrorDialogUtil.okToPerformQuestion")))) {
                return entry.getData();
            }
            return null;
        }
        RefactoringErrorDialogUtil.openListDialog(dialogTitle, status, parentShell);
        return null;
    }

    private static void openListDialog(String dialogTitle, RefactoringStatus status, Shell parentShell) {
        ListDialog dialog = new ListDialog(parentShell);
        dialog.setInput(status);
        dialog.setTitle(dialogTitle);
        dialog.setMessage(RefactoringMessages.getString("RefactoringErrorDialogUtil.cannot_perform"));
        dialog.setContentProvider(new RefactoringStatusContentProvider());
        dialog.setLabelProvider((ILabelProvider)new RefactoringStatusEntryLabelProvider());
        dialog.open();
    }
}

