/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.actions;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.corext.refactoring.RenameRefactoring;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.ITextEditor;

public class RenameRefactoringAction
extends SelectionDispatchAction {
    private CEditor fEditor;

    public RenameRefactoringAction(CEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
    }

    public RenameRefactoringAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("RenameRefactoringAction.text"));
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(selection.size() == 1);
    }

    public void selectionChanged(ITextSelection selection) {
        boolean enable = true;
        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
        IWorkingCopy element = manager.getWorkingCopy(this.fEditor.getEditorInput());
        if (element == null || element instanceof ITranslationUnit) {
            this.setEnabled(false);
            return;
        }
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        if (textSelection == null) {
            this.setEnabled(false);
            return;
        }
        if (element instanceof ISourceReference) {
            try {
                ISourceReference sourceRef = (ISourceReference)element;
                ISourceRange range = sourceRef.getSourceRange();
                if (range.getIdStartPos() != textSelection.getOffset() || range.getIdLength() != textSelection.getLength()) {
                    enable = false;
                }
            }
            catch (CModelException cModelException) {}
        }
        this.setEnabled(enable);
    }

    public void run(ITextSelection selection) {
        try {
            ICElement element = SelectionConverter.getElementAtOffset((ITextEditor)this.fEditor);
            RenameRefactoring refactoring = new RenameRefactoring(element);
            RenameRefactoringAction.run(refactoring, this.getShell());
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), RefactoringMessages.getString("RenameRefactoringAction.label"), RefactoringMessages.getString("RenameRefactoringAction.unexpected_exception"));
        }
    }

    public void run(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        try {
            RenameRefactoring refactoring = new RenameRefactoring(element);
            RenameRefactoringAction.run(refactoring, this.getShell());
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), RefactoringMessages.getString("RenameRefactoringAction.label"), RefactoringMessages.getString("RenameRefactoringAction.unexpected_exception"));
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }

    public static void run(RenameRefactoring refactoring, Shell parent) throws CoreException {
        if (refactoring.isAvailable()) {
            UserInterfaceStarter.run(refactoring, parent);
        } else {
            MessageDialog.openInformation((Shell)parent, (String)RefactoringMessages.getString("RenameRefactoringAction.label"), (String)RefactoringMessages.getString("RenameRefactoringAction.no_refactoring_available"));
        }
    }
}

