/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchResult;
import org.eclipse.cdt.internal.ui.search.NewSearchResultCollector;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class CSearchQuery
implements ISearchQuery,
ICSearchConstants {
    private IWorkspace _workspace;
    private ICSearchScope _scope;
    private String _stringPattern;
    private String _scopeDescription;
    private boolean _caseSensitive;
    private ICSearchConstants.LimitTo _limitTo;
    private List _searchFor;
    private CSearchResult _result;

    public CSearchQuery(IWorkspace workspace, String pattern, boolean caseSensitive, List searchFor, ICSearchConstants.LimitTo limitTo, ICSearchScope scope, String scopeDescription) {
        this(workspace, limitTo, scope, scopeDescription);
        this._stringPattern = pattern;
        this._caseSensitive = caseSensitive;
        this._searchFor = searchFor;
    }

    public CSearchQuery(IWorkspace workspace, ICSearchConstants.LimitTo limitTo, ICSearchScope scope, String scopeDescription) {
        this._workspace = workspace;
        this._limitTo = limitTo;
        this._scope = scope;
        this._scopeDescription = scopeDescription;
    }

    public String getSingularLabel() {
        String desc = null;
        desc = this._stringPattern;
        Object[] args = new String[]{desc, this._scopeDescription};
        if (this._limitTo == DECLARATIONS) {
            return CSearchMessages.getFormattedString("CSearchOperation.singularDeclarationsPostfix", args);
        }
        if (this._limitTo == REFERENCES) {
            return CSearchMessages.getFormattedString("CSearchOperation.singularReferencesPostfix", args);
        }
        return CSearchMessages.getFormattedString("CSearchOperation.singularOccurrencesPostfix", args);
    }

    public String getPluralLabelPattern() {
        String desc = null;
        desc = this._stringPattern;
        Object[] args = new String[]{desc, "{0}", this._scopeDescription};
        if (this._limitTo == DECLARATIONS) {
            return CSearchMessages.getFormattedString("CSearchOperation.pluralDeclarationsPostfix", args);
        }
        if (this._limitTo == REFERENCES) {
            return CSearchMessages.getFormattedString("CSearchOperation.pluralReferencesPostfix", args);
        }
        return CSearchMessages.getFormattedString("CSearchOperation.pluralOccurrencesPostfix", args);
    }

    public ImageDescriptor getImageDescriptor() {
        if (this._limitTo == ICSearchConstants.DECLARATIONS) {
            return CPluginImages.DESC_OBJS_SEARCH_DECL;
        }
        return CPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public IStatus run(IProgressMonitor monitor) {
        CSearchResult textResult = (CSearchResult)this.getSearchResult();
        textResult.removeAll();
        SearchEngine engine = new SearchEngine(CUIPlugin.getSharedWorkingCopies());
        int totalTicks = 1000;
        monitor.beginTask("", totalTicks);
        SubProgressMonitor mainSearchPM = new SubProgressMonitor(monitor, 1000);
        NewSearchResultCollector finalCollector = new NewSearchResultCollector(textResult, (IProgressMonitor)mainSearchPM);
        OrPattern pattern = null;
        if (this._searchFor.size() > 0) {
            if (this._searchFor.size() > 1) {
                OrPattern orPattern = new OrPattern();
                Iterator iter = this._searchFor.iterator();
                while (iter.hasNext()) {
                    ICSearchConstants.SearchFor element = (ICSearchConstants.SearchFor)iter.next();
                    orPattern.addPattern(SearchEngine.createSearchPattern((String)this._stringPattern, (ICSearchConstants.SearchFor)element, (ICSearchConstants.LimitTo)this._limitTo, (boolean)this._caseSensitive));
                }
                pattern = orPattern;
            } else {
                Iterator iter = this._searchFor.iterator();
                pattern = SearchEngine.createSearchPattern((String)this._stringPattern, (ICSearchConstants.SearchFor)((ICSearchConstants.SearchFor)iter.next()), (ICSearchConstants.LimitTo)this._limitTo, (boolean)this._caseSensitive);
            }
            try {
                engine.search(this._workspace, (ICSearchPattern)pattern, this._scope, (ICSearchResultCollector)finalCollector, false);
            }
            catch (InterruptedException interruptedException) {}
        }
        monitor.done();
        return new Status(0, CUIPlugin.getPluginId(), 0, "", null);
    }

    public String getLabel() {
        String label = this._limitTo == REFERENCES ? CSearchMessages.getString("CSearchQuery.searchfor_references") : (this._limitTo == DECLARATIONS ? CSearchMessages.getString("CSearchQuery.searchfor_declarations") : (this._limitTo == DEFINITIONS ? CSearchMessages.getString("CSearchQuery.searchfor_definitions") : (this._limitTo == ALL_OCCURRENCES ? CSearchMessages.getString("CSearchQuery.searchfor_all") : CSearchMessages.getString("CSearchQuery.search_label"))));
        label = String.valueOf(label) + " \"";
        label = String.valueOf(label) + this._stringPattern;
        label = String.valueOf(label) + '\"';
        return label;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this._result == null) {
            this._result = new CSearchResult(this);
        }
        return this._result;
    }
}

