/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.DOMSearchUtil;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.IMatchLocatable;
import org.eclipse.cdt.core.search.OffsetLocatable;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.cdt.internal.ui.search.CSearchResult;
import org.eclipse.cdt.internal.ui.search.NewSearchResultCollector;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class DOMQuery
extends CSearchQuery
implements ISearchQuery {
    private static final String BLANK_STRING = "";
    private CSearchResult _result;
    private IASTName searchName = null;
    private ICSearchConstants.LimitTo limitTo = null;
    private ICSearchScope scope = null;
    private String searchPattern = null;

    public DOMQuery(String displaySearchPattern, IASTName name, ICSearchConstants.LimitTo limitTo, ICSearchScope scope, String searchPattern) {
        super(CUIPlugin.getWorkspace(), displaySearchPattern, false, null, null, null, displaySearchPattern);
        this.searchName = name;
        this.limitTo = limitTo;
        this.scope = scope;
        this.searchPattern = searchPattern;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        Object next;
        Iterator itr;
        CSearchResult textResult = (CSearchResult)this.getSearchResult();
        SubProgressMonitor mainSearchPM = new SubProgressMonitor(monitor, 1000);
        NewSearchResultCollector collector = new NewSearchResultCollector(textResult, (IProgressMonitor)mainSearchPM);
        collector.aboutToStart();
        Set matches = null;
        IASTName[] foundNames = null;
        if (this.searchName != null) {
            if (!this.isLocal()) {
                matches = DOMSearchUtil.getMatchesFromSearchEngine((ICSearchScope)this.scope, (IASTName)this.searchName, (ICSearchConstants.LimitTo)this.limitTo);
            }
            if (matches != null && matches.size() > 0) {
                itr = matches.iterator();
                while (itr.hasNext()) {
                    next = itr.next();
                    if (!(next instanceof IMatch)) continue;
                    try {
                        collector.acceptMatch((IMatch)next);
                    }
                    catch (CoreException coreException) {}
                }
            } else {
                foundNames = DOMSearchUtil.getNamesFromDOM((IASTName)this.searchName, (ICSearchConstants.LimitTo)this.limitTo);
                int i = 0;
                while (i < foundNames.length) {
                    try {
                        String fileName = null;
                        Path path = null;
                        int start = 0;
                        int end = 0;
                        if (foundNames[i].getTranslationUnit() != null) {
                            IASTFileLocation location = foundNames[i].getFileLocation();
                            fileName = location.getFileName();
                            start = location.getNodeOffset();
                            end = location.getNodeOffset() + location.getNodeLength();
                        }
                        path = new Path(fileName);
                        Object fileResource = null;
                        IResource res = ParserUtil.getResourceForFilename((String)fileName);
                        fileResource = res != null ? res : PathUtil.getWorkspaceRelativePath((String)fileName);
                        collector.acceptMatch(this.createMatch(fileResource, start, end, (IASTNode)foundNames[i], (IPath)path));
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
            }
        }
        if (!(this.searchPattern == null || matches != null && matches.size() != 0 || foundNames != null && foundNames.length != 0)) {
            matches = DOMSearchUtil.getMatchesFromSearchEngine((ICSearchScope)this.scope, (String)this.searchPattern, (ICSearchConstants.LimitTo)this.limitTo);
            itr = matches.iterator();
            while (itr.hasNext()) {
                next = itr.next();
                if (!(next instanceof IMatch)) continue;
                try {
                    collector.acceptMatch((IMatch)next);
                }
                catch (CoreException coreException) {}
            }
        }
        mainSearchPM.done();
        collector.done();
        return new Status(0, CUIPlugin.getPluginId(), 0, BLANK_STRING, null);
    }

    private boolean isLocal() {
        IBinding binding = this.searchName.resolveBinding();
        if (binding instanceof ICPPBinding) {
            try {
                if (!((ICPPBinding)binding).isGloballyQualified()) {
                    return true;
                }
            }
            catch (DOMException dOMException) {}
        } else {
            try {
                IScope nameScope = binding.getScope();
                if (nameScope instanceof ICFunctionScope || nameScope.getPhysicalNode() instanceof IASTCompoundStatement) {
                    return true;
                }
            }
            catch (DOMException dOMException) {}
        }
        return false;
    }

    public IMatch createMatch(Object fileResource, int start, int end, IASTNode node, IPath referringElement) {
        BasicSearchMatch result = new BasicSearchMatch();
        if (fileResource instanceof IResource) {
            result.setResource((IResource)fileResource);
        } else if (fileResource instanceof IPath) {
            result.setPath((IPath)fileResource);
        }
        result.setLocatable((IMatchLocatable)new OffsetLocatable(start, end));
        result.setParentName(BLANK_STRING);
        result.setReferringElement(referringElement);
        if (node instanceof IASTName) {
            result.setName(node.toString());
        } else if (node instanceof IASTProblem) {
            result.setName(((IASTProblem)node).getMessage());
        } else {
            result.setName(node.toString());
        }
        if (node instanceof IASTName) {
            IBinding binding = ((IASTName)node).resolveBinding();
            if (binding instanceof ICPPClassType) {
                result.setType(65);
            } else if (binding instanceof ICompositeType) {
                int key = 1;
                try {
                    key = ((ICompositeType)binding).getKey();
                }
                catch (DOMException dOMException) {}
                switch (key) {
                    case 1: {
                        result.setType(67);
                        break;
                    }
                    case 2: {
                        result.setType(69);
                    }
                }
            } else if (binding instanceof ICPPNamespace) {
                result.setType(61);
            } else if (binding instanceof IEnumeration) {
                result.setType(63);
            } else if (binding instanceof IMacroBinding) {
                result.setType(79);
            } else if (binding instanceof IField) {
                result.setType(72);
                try {
                    result.setStatic(((IField)binding).isStatic());
                }
                catch (DOMException dOMException) {}
                if (binding instanceof ICPPMember) {
                    try {
                        switch (((ICPPMember)binding).getVisibility()) {
                            case 3: {
                                result.setVisibility(4096);
                                break;
                            }
                            case 1: {
                                result.setVisibility(8192);
                            }
                        }
                    }
                    catch (DOMException dOMException) {}
                }
                try {
                    result.setConst(ASTTypeUtil.isConst((IType)((IField)binding).getType()));
                }
                catch (DOMException dOMException) {}
            } else if (binding instanceof IVariable) {
                result.setType(76);
                try {
                    result.setConst(ASTTypeUtil.isConst((IType)((IVariable)binding).getType()));
                }
                catch (DOMException dOMException) {}
            } else if (binding instanceof IEnumerator) {
                result.setType(81);
            } else if (binding instanceof ICPPMethod) {
                result.setType(70);
                if (binding instanceof ICPPMember) {
                    try {
                        switch (((ICPPMember)binding).getVisibility()) {
                            case 3: {
                                result.setVisibility(4096);
                                break;
                            }
                            case 1: {
                                result.setVisibility(8192);
                            }
                        }
                    }
                    catch (DOMException dOMException) {}
                }
                try {
                    result.setConst(ASTTypeUtil.isConst((IType)((ICPPMethod)binding).getType()));
                }
                catch (DOMException dOMException) {}
            } else if (binding instanceof IFunction) {
                result.setType(74);
                try {
                    result.setStatic(((IFunction)binding).isStatic());
                }
                catch (DOMException dOMException) {}
            } else if (binding instanceof ITypedef) {
                result.setType(80);
            }
        } else {
            result.setType(93);
        }
        result.setReturnType(BLANK_STRING);
        return result;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this._result == null) {
            this._result = new CSearchResult(this);
        }
        return this._result;
    }
}

