/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.PDOMSearchMatch;
import org.eclipse.cdt.internal.ui.search.PDOMSearchResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class PDOMSearchQuery
implements ISearchQuery {
    public static final int FIND_DECLARATIONS = 1;
    public static final int FIND_DEFINITIONS = 2;
    public static final int FIND_REFERENCES = 4;
    private PDOMSearchResult result = new PDOMSearchResult(this);
    private PDOMBinding binding;
    private int flags;

    public PDOMSearchQuery(PDOMBinding binding, int flags) {
        this.binding = binding;
        this.flags = flags;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            IASTFileLocation loc;
            PDOMName name;
            if ((this.flags & 1) != 0) {
                name = this.binding.getFirstDeclaration();
                while (name != null) {
                    loc = name.getFileLocation();
                    this.result.addMatch(new PDOMSearchMatch(name, loc.getNodeOffset(), loc.getNodeLength()));
                    name = name.getNextInBinding();
                }
            }
            if ((this.flags & 1) != 0) {
                name = this.binding.getFirstDefinition();
                while (name != null) {
                    loc = name.getFileLocation();
                    this.result.addMatch(new PDOMSearchMatch(name, loc.getNodeOffset(), loc.getNodeLength()));
                    name = name.getNextInBinding();
                }
            }
            if ((this.flags & 4) != 0) {
                name = this.binding.getFirstReference();
                while (name != null) {
                    loc = name.getFileLocation();
                    this.result.addMatch(new PDOMSearchMatch(name, loc.getNodeOffset(), loc.getNodeLength()));
                    name = name.getNextInBinding();
                }
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.cdt.ui", 0, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String getLabel() {
        String type = null;
        type = (this.flags & 4) != 0 ? CSearchMessages.getString("PDOMSearch.query.refs.label") : ((this.flags & 1) != 0 ? CSearchMessages.getString("PDOMSearch.query.decls.label") : CSearchMessages.getString("PDOMSearch.query.defs.label"));
        return String.valueOf(type) + " " + this.binding.getName();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }
}

