/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.ui.search.PDOMSearchMatch;
import org.eclipse.cdt.internal.ui.search.PDOMSearchQuery;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class PDOMSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private PDOMSearchQuery query;

    public PDOMSearchResult(PDOMSearchQuery query) {
        this.query = query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    private String getFileName(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            return fileInput.getFile().getLocation().toOSString();
        }
        if (input instanceof ExternalEditorInput) {
            ExternalEditorInput extInput = (ExternalEditorInput)input;
            return extInput.getStorage().getFullPath().toOSString();
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        String filename = this.getFileName(editor);
        if (filename != null && match instanceof PDOMSearchMatch) {
            return filename.equals(((PDOMSearchMatch)match).getFileName());
        }
        return false;
    }

    private Match[] computeContainedMatches(AbstractTextSearchResult result, String filename) {
        ArrayList<Match> list = new ArrayList<Match>();
        Object[] elements = result.getElements();
        int i = 0;
        while (i < elements.length) {
            Match[] matches = result.getMatches(elements[i]);
            int j = 0;
            while (j < matches.length) {
                String mfilename;
                if (matches[j] instanceof PDOMSearchMatch && filename.equals(mfilename = ((PDOMSearchMatch)matches[j]).getFileName())) {
                    list.add(matches[j]);
                }
                ++j;
            }
            ++i;
        }
        return list.toArray(new Match[list.size()]);
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        String filename = this.getFileName(editor);
        if (filename != null) {
            return this.computeContainedMatches(result, filename);
        }
        return new Match[0];
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        String filename = file.getLocation().toOSString();
        return this.computeContainedMatches(result, filename);
    }

    public IFile getFile(Object element) {
        if (element instanceof PDOMName) {
            PDOMName name = (PDOMName)element;
            IASTFileLocation loc = name.getFileLocation();
            Path path = new Path(loc.getFileName());
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
            if (files.length > 0) {
                return files[0];
            }
            return null;
        }
        return null;
    }

    public String getLabel() {
        return this.query.getLabel();
    }

    public String getTooltip() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ISearchQuery getQuery() {
        return this.query;
    }
}

