/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.ui.search.PDOMSearchResult;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class PDOMSearchTreeContentProvider
implements ITreeContentProvider {
    private TreeViewer viewer;
    private PDOMSearchResult result;
    private HashMap tree;

    public Object[] getChildren(Object parentElement) {
        Set children = (Set)this.tree.get(parentElement);
        if (children == null) {
            return new Object[0];
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.tree.get(element) != null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren((Object)this.result);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        this.result = (PDOMSearchResult)((Object)newInput);
        this.tree = new HashMap();
    }

    private void insertChild(Object parent, Object child) {
        HashSet<Object> children = (HashSet<Object>)this.tree.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.tree.put(parent, children);
        }
        children.add(child);
    }

    private void insertName(PDOMName name) {
        IASTFileLocation loc = name.getFileLocation();
        Path path = new Path(loc.getFileName());
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
        if (files.length > 0) {
            int j = 0;
            while (j < files.length) {
                this.insertChild(files[j], name);
                this.insertResource((IResource)files[j]);
                ++j;
            }
        } else {
            String pathName = path.toOSString();
            this.insertChild(pathName, name);
            this.insertChild((Object)this.result, pathName);
        }
    }

    private void insertResource(IResource resource) {
        if (resource instanceof IProject) {
            this.insertChild((Object)this.result, resource);
        } else {
            IContainer parent = resource.getParent();
            this.insertChild(parent, resource);
            this.insertResource((IResource)parent);
        }
    }

    public void elementsChanged(Object[] elements) {
        if (elements == null || elements.length == 0) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            PDOMName name = (PDOMName)elements[i];
            this.insertName(name);
            ++i;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PDOMSearchTreeContentProvider.this.viewer.refresh();
            }
        });
    }

    public void clear() {
    }
}

