/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.search.PDOMSearchLabelProvider;
import org.eclipse.cdt.internal.ui.search.PDOMSearchMatch;
import org.eclipse.cdt.internal.ui.search.PDOMSearchTreeContentProvider;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class PDOMSearchViewPage
extends AbstractTextSearchViewPage {
    private PDOMSearchTreeContentProvider contentProvider;

    public PDOMSearchViewPage(int supportedLayouts) {
        super(supportedLayouts);
    }

    public PDOMSearchViewPage() {
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.contentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            this.contentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.contentProvider = new PDOMSearchTreeContentProvider();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new PDOMSearchLabelProvider());
    }

    protected void configureTableViewer(TableViewer viewer) {
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        if (!(match instanceof PDOMSearchMatch)) {
            return;
        }
        Path path = new Path(((PDOMSearchMatch)match).getFileName());
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path);
        if (files.length > 0) {
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)CUIPlugin.getActivePage(), (IFile)files[0]);
            try {
                IMarker marker = files[0].createMarker("org.eclipse.search.searchmarker");
                marker.setAttribute("charStart", currentOffset);
                marker.setAttribute("charEnd", currentOffset + currentLength);
                IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
                marker.delete();
            }
            catch (CoreException e) {
                CUIPlugin.getDefault().log(e);
            }
        } else {
            ExternalEditorInput input = new ExternalEditorInput((IStorage)new FileStorage((IPath)path));
            IEditorPart editor = CUIPlugin.getActivePage().openEditor((IEditorInput)input, "org.eclipse.cdt.ui.editor.ExternalSearchEditor");
            if (editor instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)editor;
                textEditor.selectAndReveal(currentOffset, currentLength);
            }
        }
    }
}

