/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchScopeFactory;
import org.eclipse.cdt.internal.ui.search.actions.FindAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

public class FindRefsProjectAction
extends FindAction {
    public FindRefsProjectAction(CEditor editor, String label, String tooltip) {
        super(editor);
        this.setText(label);
        this.setToolTipText(tooltip);
    }

    public FindRefsProjectAction(CEditor editor) {
        this(editor, CSearchMessages.getString("CSearch.FindReferencesProjectAction.label"), CSearchMessages.getString("CSearch.FindReferencesProjectAction.tooltip"));
    }

    public FindRefsProjectAction(IWorkbenchSite site) {
        this(site, CSearchMessages.getString("CSearch.FindReferencesProjectAction.label"), CSearchMessages.getString("CSearch.FindReferencesProjectAction.tooltip"));
    }

    public FindRefsProjectAction(IWorkbenchSite site, String label, String tooltip) {
        super(site);
        this.setText(label);
        this.setToolTipText(tooltip);
    }

    protected ICSearchScope getScope() {
        ICProject proj = null;
        if (this.fEditor != null) {
            proj = this.fEditor.getInputCElement().getCProject();
        } else if (this.fSite != null) {
            IStructuredSelection sel = (IStructuredSelection)this.getSelection();
            return CSearchScopeFactory.getInstance().createEnclosingProjectScope(sel);
        }
        ICElement[] element = new ICElement[]{proj};
        return SearchEngine.createCSearchScope((ICElement[])element);
    }

    protected String getScopeDescription() {
        return CSearchMessages.getString("ProjectScope");
    }

    protected ICSearchConstants.LimitTo getLimitTo() {
        return ICSearchConstants.REFERENCES;
    }
}

