/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.Vector;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CElementHyperlinkDetector;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.text.CAnnotationHover;
import org.eclipse.cdt.internal.ui.text.CAutoIndentStrategy;
import org.eclipse.cdt.internal.ui.text.CCommentAutoIndentStrategy;
import org.eclipse.cdt.internal.ui.text.CDoubleClickSelector;
import org.eclipse.cdt.internal.ui.text.CFormattingStrategy;
import org.eclipse.cdt.internal.ui.text.COutlineInformationControl;
import org.eclipse.cdt.internal.ui.text.CReconciler;
import org.eclipse.cdt.internal.ui.text.CReconcilingStrategy;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.HTMLTextPresenter;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.c.hover.CEditorTextHoverDescriptor;
import org.eclipse.cdt.internal.ui.text.c.hover.CEditorTextHoverProxy;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProcessor2;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistPreference;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;

public class CSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private CTextTools fTextTools;
    private CEditor fEditor;

    public CSourceViewerConfiguration(CTextTools tools, CEditor editor) {
        super(CUIPlugin.getDefault().getCombinedPreferenceStore());
        this.fTextTools = tools;
        this.fEditor = editor;
    }

    protected RuleBasedScanner getMultilineCommentScanner() {
        return this.fTextTools.getMultilineCommentScanner();
    }

    protected RuleBasedScanner getSinglelineCommentScanner() {
        return this.fTextTools.getSinglelineCommentScanner();
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fTextTools.getStringScanner();
    }

    protected IColorManager getColorManager() {
        return this.fTextTools.getColorManager();
    }

    protected ITextEditor getEditor() {
        return this.fEditor;
    }

    public IInformationPresenter getOutlinePresenter(CEditor editor) {
        IInformationControlCreator outlineControlCreator = this.getOutlineContolCreator(editor);
        InformationPresenter presenter = new InformationPresenter(outlineControlCreator);
        CElementContentProvider provider = new CElementContentProvider(this.getEditor());
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "c_multi_line_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "c_single_line_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "c_string");
        presenter.setSizeConstraints(20, 20, true, false);
        presenter.setRestoreInformationControlBounds(this.getSettings("outline_presenter_bounds"), true, true);
        return presenter;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        String language;
        PresentationReconciler reconciler = new PresentationReconciler();
        RuleBasedScanner scanner = sourceViewer instanceof CSourceViewer ? ((language = ((CSourceViewer)sourceViewer).getDisplayLanguage()) != null && language.equals("CEditor.language.cpp") ? this.fTextTools.getCppCodeScanner() : this.fTextTools.getCCodeScanner()) : this.fTextTools.getCCodeScanner();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "c_single_line_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "c_single_line_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "c_multi_line_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "c_multi_line_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "c_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "c_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "c_character");
        reconciler.setRepairer((IPresentationRepairer)dr, "c_character");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.getEditor() == null) {
            return null;
        }
        ContentAssistant assistant = new ContentAssistant();
        CCompletionProcessor2 processor = new CCompletionProcessor2((IEditorPart)this.getEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        ContentAssistPreference.configure(assistant, this.getPreferenceStore());
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fEditor != null && this.fEditor.isEditable()) {
            CReconciler reconciler = new CReconciler(){

                protected void initialProcess() {
                    IDocument doc = this.getDocument();
                    if (doc != null) {
                        super.initialProcess();
                    }
                }
            };
            reconciler.setDelay(1000);
            reconciler.setReconcilingStrategy(new CReconcilingStrategy(this.fEditor), "__dftl_partition_content_type");
            return reconciler;
        }
        return null;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("c_multi_line_comment".equals(contentType)) {
            return new IAutoEditStrategy[]{new CCommentAutoIndentStrategy()};
        }
        return new IAutoEditStrategy[]{new CAutoIndentStrategy()};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new CDoubleClickSelector();
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"//", ""};
    }

    public String getDefaultPrefix(ISourceViewer sourceViewer, String contentType) {
        if ("__dftl_partition_content_type".equals(contentType)) {
            return "//";
        }
        if ("c_single_line_comment".equals(contentType)) {
            return "//";
        }
        if ("c_multi_line_comment".equals(contentType)) {
            return "//";
        }
        return null;
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        int tabWidth = this.getTabWidth(sourceViewer);
        boolean useSpaces = this.getPreferenceStore().getBoolean("spacesForTabs");
        int i = 0;
        while (i <= tabWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            if (useSpaces) {
                j = 0;
                while (j + i < tabWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != tabWidth) {
                    prefix.append('\t');
                }
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new CAnnotationHover();
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        CEditorTextHoverDescriptor[] hoverDescs = CUIPlugin.getDefault().getCEditorTextHoverDescriptors();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = hoverDescs[i].getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        CEditorTextHoverDescriptor[] hoverDescs = CUIPlugin.getDefault().getCEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                return new CEditorTextHoverProxy(hoverDescs[i], (IEditorPart)this.getEditor());
            }
            ++i;
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "c_multi_line_comment", "c_single_line_comment", "c_string", "c_character"};
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new CFormattingStrategy());
        return formatter;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.fTextTools.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        this.fTextTools.adaptToPreferenceChange(event);
    }

    protected IPreferenceStore getPreferenceStore() {
        return CUIPlugin.getDefault().getPreferenceStore();
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return this.getInformationControlCreator(sourceViewer, true);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer, final boolean cutDown) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(parent, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        return super.getInformationPresenter(sourceViewer);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (this.fEditor == null) {
            return inheritedDetectors;
        }
        int inheritedDetectorsLength = inheritedDetectors != null ? inheritedDetectors.length : 0;
        IHyperlinkDetector[] detectors = new IHyperlinkDetector[inheritedDetectorsLength + 1];
        detectors[0] = new CElementHyperlinkDetector((ITextEditor)this.fEditor);
        int i = 0;
        while (i < inheritedDetectorsLength) {
            detectors[i + 1] = inheritedDetectors[i];
            ++i;
        }
        return detectors;
    }

    private IInformationControlCreator getOutlineContolCreator(final CEditor editor) {
        IInformationControlCreator conrolCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new COutlineInformationControl(editor, parent, shellStyle, treeStyle);
            }
        };
        return conrolCreator;
    }

    private IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = CUIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }
}

