/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IASTServiceProvider;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.dom.PDOM;
import org.eclipse.cdt.core.dom.ast.ASTCompletionNode;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.preferences.ProposalFilterPreferencesUtil;
import org.eclipse.cdt.internal.ui.text.CParameterListValidator;
import org.eclipse.cdt.internal.ui.text.contentassist.DefaultProposalFilter;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.contentassist.ICompletionContributor;
import org.eclipse.cdt.ui.text.contentassist.IProposalFilter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.IEditorPart;

public class CCompletionProcessor2
implements IContentAssistProcessor {
    private IEditorPart editor;
    private String errorMessage;
    private char[] autoActivationChars;
    private String assistPrefix = "CEditor.contentassist";
    private String noCompletions = String.valueOf(this.assistPrefix) + ".noCompletions";
    private String parseError = String.valueOf(this.assistPrefix) + ".parseError";
    private String dialectError = String.valueOf(this.assistPrefix) + ".badDialect";

    public CCompletionProcessor2(IEditorPart editor) {
        this.editor = editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.editor.getEditorInput());
            ASTCompletionNode completionNode = null;
            String prefix = null;
            IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
            boolean fileScope = store.getBoolean("content_assist_current_file_search_scope");
            store.getBoolean("content_assist_project_search_scope");
            if (fileScope && workingCopy != null) {
                IFile file = (IFile)workingCopy.getResource();
                if (file != null) {
                    IProject project = file.getProject();
                    IPDOM pdom = PDOM.getPDOM((IProject)project);
                    ICodeReaderFactory readerFactory = pdom != null ? pdom.getCodeReaderFactory(workingCopy) : CDOM.getInstance().getCodeReaderFactory(2);
                    completionNode = CDOM.getInstance().getCompletionNode(file, offset, readerFactory);
                } else if (this.editor.getEditorInput() instanceof ExternalEditorInput) {
                    IStorage storage = ((ExternalEditorInput)this.editor.getEditorInput()).getStorage();
                    IProject project = workingCopy.getCProject().getProject();
                    IPDOM pdom = PDOM.getPDOM((IProject)project);
                    ICodeReaderFactory readerFactory = pdom != null ? pdom.getCodeReaderFactory(workingCopy) : CDOM.getInstance().getCodeReaderFactory(2);
                    completionNode = CDOM.getInstance().getCompletionNode(storage, project, offset, readerFactory);
                }
                if (completionNode != null) {
                    prefix = completionNode.getPrefix();
                }
            }
            if (prefix == null) {
                prefix = this.scanPrefix(viewer.getDocument(), offset);
            }
            this.errorMessage = CUIMessages.getString(this.noCompletions);
            ArrayList proposals = new ArrayList();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", "completionContributors");
            if (point == null) {
                return null;
            }
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    Object contribObject;
                    IConfigurationElement element = elements[j];
                    if ("contributor".equals(element.getName()) && (contribObject = element.createExecutableExtension("class")) instanceof ICompletionContributor) {
                        ICompletionContributor contributor = (ICompletionContributor)contribObject;
                        contributor.contributeCompletionProposals(viewer, offset, workingCopy, completionNode, prefix, proposals);
                    }
                    ++j;
                }
                ++i;
            }
            IProposalFilter filter = this.getCompletionFilter();
            ICCompletionProposal[] proposalsInput = proposals.toArray(new ICCompletionProposal[proposals.size()]);
            ICompletionProposal[] proposalsFiltered = filter.filterProposals(proposalsInput);
            return proposalsFiltered;
        }
        catch (IASTServiceProvider.UnsupportedDialectException unsupportedDialectException) {
            this.errorMessage = CUIMessages.getString(this.dialectError);
        }
        catch (Throwable e) {
            this.errorMessage = e.toString();
        }
        return null;
    }

    private IProposalFilter getCompletionFilter() {
        IProposalFilter filter = null;
        try {
            Object contribObject;
            IConfigurationElement filterElement = ProposalFilterPreferencesUtil.getPreferredFilterElement();
            if (filterElement != null && (contribObject = filterElement.createExecutableExtension("class")) instanceof IProposalFilter) {
                filter = (IProposalFilter)contribObject;
            }
        }
        catch (InvalidRegistryObjectException e) {
            CUIPlugin.getDefault().log(e);
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
        }
        if (filter == null) {
            filter = new DefaultProposalFilter();
        }
        return filter;
    }

    private String scanPrefix(IDocument document, int end) {
        try {
            int start = end;
            while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                --start;
            }
            if (start != 0 && Character.isUnicodeIdentifierStart(document.getChar(start - 1))) {
                --start;
            }
            return document.get(start, end - start);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.autoActivationChars;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] autoActivationChars) {
        this.autoActivationChars = autoActivationChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new CParameterListValidator();
    }

    public void orderProposalsAlphabetically(boolean order) {
    }

    public void allowAddingIncludes(boolean allowAddingIncludes) {
    }
}

